/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto;

import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;

public class BufferedAsymmetricBlockCipher {
    protected byte[] buf;
    protected int bufOff;
    private final AsymmetricBlockCipher a;

    public BufferedAsymmetricBlockCipher(AsymmetricBlockCipher cipher) {
        this.a = cipher;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.a;
    }

    public int getBufferPosition() {
        return this.bufOff;
    }

    public void init(boolean forEncryption, CipherParameters params) {
        this.reset();
        this.a.init(forEncryption, params);
        this.buf = new byte[this.a.getInputBlockSize() + (forEncryption ? 1 : 0)];
        this.bufOff = 0;
    }

    public int getInputBlockSize() {
        return this.a.getInputBlockSize();
    }

    public int getOutputBlockSize() {
        return this.a.getOutputBlockSize();
    }

    public void processByte(byte in) {
        if (this.bufOff >= this.buf.length) {
            throw new DataLengthException("attempt to process message too long for cipher");
        }
        this.buf[this.bufOff++] = in;
    }

    public void processBytes(byte[] in, int inOff, int len) {
        if (len == 0) {
            return;
        }
        if (len < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        if (this.bufOff + len > this.buf.length) {
            throw new DataLengthException("attempt to process message too long for cipher");
        }
        System.arraycopy(in, inOff, this.buf, this.bufOff, len);
        this.bufOff += len;
    }

    public byte[] doFinal() throws InvalidCipherTextException {
        byte[] byArray = this.a.processBlock(this.buf, 0, this.bufOff);
        this.reset();
        return byArray;
    }

    public void reset() {
        if (this.buf != null) {
            for (int i2 = 0; i2 < this.buf.length; ++i2) {
                this.buf[i2] = 0;
            }
        }
        this.bufOff = 0;
    }
}

