/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.agreement.DHBasicAgreement;
import com.enterprisedt.bouncycastle.crypto.agreement.a;
import com.enterprisedt.bouncycastle.crypto.params.DHUPrivateParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHUPublicParameters;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class DHUnifiedAgreement {
    private DHUPrivateParameters a;

    public void init(CipherParameters key) {
        this.a = (DHUPrivateParameters)key;
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.agreement.a.a("DHU", this.a.getStaticPrivateKey()));
    }

    public int getFieldSize() {
        return (this.a.getStaticPrivateKey().getParameters().getP().bitLength() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters pubKey) {
        DHUPublicParameters dHUPublicParameters = (DHUPublicParameters)pubKey;
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        DHBasicAgreement dHBasicAgreement2 = new DHBasicAgreement();
        dHBasicAgreement.init(this.a.getStaticPrivateKey());
        BigInteger bigInteger = dHBasicAgreement.calculateAgreement(dHUPublicParameters.getStaticPublicKey());
        dHBasicAgreement2.init(this.a.getEphemeralPrivateKey());
        BigInteger bigInteger2 = dHBasicAgreement2.calculateAgreement(dHUPublicParameters.getEphemeralPublicKey());
        int n2 = this.getFieldSize();
        byte[] byArray = new byte[n2 * 2];
        BigIntegers.asUnsignedByteArray(bigInteger2, byArray, 0, n2);
        BigIntegers.asUnsignedByteArray(bigInteger, byArray, n2, n2);
        return byArray;
    }
}

