/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.agreement.a;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithUKM;
import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class ECVKOAgreement {
    private final Digest a;
    private ECPrivateKeyParameters b;
    private BigInteger c;

    public ECVKOAgreement(Digest digest) {
        this.a = digest;
    }

    public void init(CipherParameters key) {
        ParametersWithUKM parametersWithUKM = (ParametersWithUKM)key;
        this.b = (ECPrivateKeyParameters)parametersWithUKM.getParameters();
        this.c = new BigInteger(1, Arrays.reverse(parametersWithUKM.getUKM()));
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.agreement.a.a("ECVKO", this.b));
    }

    public int getAgreementSize() {
        return this.a.getDigestSize();
    }

    public int getFieldSize() {
        return (this.b.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters pubKey) {
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)pubKey;
        ECDomainParameters eCDomainParameters = this.b.getParameters();
        if (!eCDomainParameters.equals(eCPublicKeyParameters.getParameters())) {
            throw new IllegalStateException("ECVKO public key has wrong domain parameters");
        }
        BigInteger bigInteger = eCDomainParameters.getH().multiply(this.c).multiply(this.b.getD()).mod(eCDomainParameters.getN());
        ECPoint eCPoint = ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPublicKeyParameters.getQ());
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECVKO");
        }
        ECPoint eCPoint2 = eCPoint.multiply(bigInteger).normalize();
        if (eCPoint2.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECVKO");
        }
        byte[] byArray = eCPoint2.getEncoded(false);
        int n2 = byArray.length;
        int n3 = n2 / 2;
        Arrays.reverseInPlace(byArray, n2 - n3 * 2, n3);
        Arrays.reverseInPlace(byArray, n2 - n3, n3);
        byte[] byArray2 = new byte[this.a.getDigestSize()];
        this.a.update(byArray, n2 - n3 * 2, n3 * 2);
        this.a.doFinal(byArray2, 0);
        return byArray2;
    }
}

