/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement;

import com.enterprisedt.bouncycastle.crypto.BasicAgreement;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.RawAgreement;
import com.enterprisedt.bouncycastle.crypto.agreement.X25519Agreement;
import com.enterprisedt.bouncycastle.crypto.agreement.X448Agreement;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.X448PrivateKeyParameters;
import java.math.BigInteger;

public class XDHBasicAgreement
implements BasicAgreement {
    private AsymmetricKeyParameter a;
    private RawAgreement b;
    private int c = 0;

    @Override
    public void init(CipherParameters key) {
        if (key instanceof X25519PrivateKeyParameters) {
            this.c = 32;
            this.b = new X25519Agreement();
        } else if (key instanceof X448PrivateKeyParameters) {
            this.c = 56;
            this.b = new X448Agreement();
        } else {
            throw new IllegalArgumentException("key is neither X25519 nor X448");
        }
        this.a = (AsymmetricKeyParameter)key;
        this.b.init(key);
    }

    @Override
    public int getFieldSize() {
        return this.c;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters pubKey) {
        byte[] byArray = new byte[this.c];
        this.b.calculateAgreement(pubKey, byArray, 0);
        return new BigInteger(1, byArray);
    }
}

