/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement.jpake;

import com.enterprisedt.bouncycastle.crypto.agreement.jpake.JPAKEUtil;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class JPAKERound1Payload {
    private final String a;
    private final BigInteger b;
    private final BigInteger c;
    private final BigInteger[] d;
    private final BigInteger[] e;

    public JPAKERound1Payload(String participantId, BigInteger gx1, BigInteger gx2, BigInteger[] knowledgeProofForX1, BigInteger[] knowledgeProofForX2) {
        JPAKEUtil.validateNotNull(participantId, "participantId");
        JPAKEUtil.validateNotNull(gx1, "gx1");
        JPAKEUtil.validateNotNull(gx2, "gx2");
        JPAKEUtil.validateNotNull(knowledgeProofForX1, "knowledgeProofForX1");
        JPAKEUtil.validateNotNull(knowledgeProofForX2, "knowledgeProofForX2");
        this.a = participantId;
        this.b = gx1;
        this.c = gx2;
        this.d = Arrays.copyOf(knowledgeProofForX1, knowledgeProofForX1.length);
        this.e = Arrays.copyOf(knowledgeProofForX2, knowledgeProofForX2.length);
    }

    public String getParticipantId() {
        return this.a;
    }

    public BigInteger getGx1() {
        return this.b;
    }

    public BigInteger getGx2() {
        return this.c;
    }

    public BigInteger[] getKnowledgeProofForX1() {
        return Arrays.copyOf(this.d, this.d.length);
    }

    public BigInteger[] getKnowledgeProofForX2() {
        return Arrays.copyOf(this.e, this.e.length);
    }
}

