/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement.jpake;

import com.enterprisedt.bouncycastle.crypto.CryptoException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.macs.HMac;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import com.enterprisedt.bouncycastle.util.Strings;
import java.math.BigInteger;
import java.security.SecureRandom;

public class JPAKEUtil {
    static final BigInteger a = BigInteger.valueOf(0L);
    static final BigInteger b = BigInteger.valueOf(1L);

    public static BigInteger generateX1(BigInteger q2, SecureRandom random) {
        BigInteger bigInteger = a;
        BigInteger bigInteger2 = q2.subtract(b);
        return BigIntegers.createRandomInRange(bigInteger, bigInteger2, random);
    }

    public static BigInteger generateX2(BigInteger q2, SecureRandom random) {
        BigInteger bigInteger = b;
        BigInteger bigInteger2 = q2.subtract(b);
        return BigIntegers.createRandomInRange(bigInteger, bigInteger2, random);
    }

    public static BigInteger calculateS(char[] password) {
        return new BigInteger(1, Strings.toUTF8ByteArray(password));
    }

    public static BigInteger calculateS(BigInteger q2, byte[] password) throws CryptoException {
        BigInteger bigInteger = new BigInteger(1, password).mod(q2);
        if (bigInteger.signum() == 0) {
            throw new CryptoException("MUST ensure s is not equal to 0 modulo q");
        }
        return bigInteger;
    }

    public static BigInteger calculateS(BigInteger q2, char[] password) throws CryptoException {
        return JPAKEUtil.calculateS(q2, Strings.toUTF8ByteArray(password));
    }

    public static BigInteger calculateGx(BigInteger p2, BigInteger g2, BigInteger x) {
        return g2.modPow(x, p2);
    }

    public static BigInteger calculateGA(BigInteger p2, BigInteger gx1, BigInteger gx3, BigInteger gx4) {
        return gx1.multiply(gx3).multiply(gx4).mod(p2);
    }

    public static BigInteger calculateX2s(BigInteger q2, BigInteger x2, BigInteger s2) {
        return x2.multiply(s2).mod(q2);
    }

    public static BigInteger calculateA(BigInteger p2, BigInteger q2, BigInteger gA, BigInteger x2s) {
        return gA.modPow(x2s, p2);
    }

    public static BigInteger[] calculateZeroKnowledgeProof(BigInteger p2, BigInteger q2, BigInteger g2, BigInteger gx, BigInteger x, String participantId, Digest digest, SecureRandom random) {
        BigInteger[] bigIntegerArray = new BigInteger[2];
        BigInteger bigInteger = a;
        BigInteger bigInteger2 = q2.subtract(b);
        BigInteger bigInteger3 = BigIntegers.createRandomInRange(bigInteger, bigInteger2, random);
        BigInteger bigInteger4 = g2.modPow(bigInteger3, p2);
        BigInteger bigInteger5 = JPAKEUtil.a(g2, bigInteger4, gx, participantId, digest);
        bigIntegerArray[0] = bigInteger4;
        bigIntegerArray[1] = bigInteger3.subtract(x.multiply(bigInteger5)).mod(q2);
        return bigIntegerArray;
    }

    private static BigInteger a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, String string, Digest digest) {
        digest.reset();
        JPAKEUtil.b(digest, bigInteger);
        JPAKEUtil.b(digest, bigInteger2);
        JPAKEUtil.b(digest, bigInteger3);
        JPAKEUtil.b(digest, string);
        byte[] byArray = new byte[digest.getDigestSize()];
        digest.doFinal(byArray, 0);
        return new BigInteger(byArray);
    }

    public static void validateGx4(BigInteger gx4) throws CryptoException {
        if (gx4.equals(b)) {
            throw new CryptoException("g^x validation failed.  g^x should not be 1.");
        }
    }

    public static void validateGa(BigInteger ga) throws CryptoException {
        if (ga.equals(b)) {
            throw new CryptoException("ga is equal to 1.  It should not be.  The chances of this happening are on the order of 2^160 for a 160-bit q.  Try again.");
        }
    }

    public static void validateZeroKnowledgeProof(BigInteger p2, BigInteger q2, BigInteger g2, BigInteger gx, BigInteger[] zeroKnowledgeProof, String participantId, Digest digest) throws CryptoException {
        BigInteger bigInteger = zeroKnowledgeProof[0];
        BigInteger bigInteger2 = zeroKnowledgeProof[1];
        BigInteger bigInteger3 = JPAKEUtil.a(g2, bigInteger, gx, participantId, digest);
        if (gx.compareTo(a) != 1 || gx.compareTo(p2) != -1 || gx.modPow(q2, p2).compareTo(b) != 0 || g2.modPow(bigInteger2, p2).multiply(gx.modPow(bigInteger3, p2)).mod(p2).compareTo(bigInteger) != 0) {
            throw new CryptoException("Zero-knowledge proof validation failed");
        }
    }

    public static BigInteger calculateKeyingMaterial(BigInteger p2, BigInteger q2, BigInteger gx4, BigInteger x2, BigInteger s2, BigInteger B) {
        return gx4.modPow(x2.multiply(s2).negate().mod(q2), p2).multiply(B).modPow(x2, p2);
    }

    public static void validateParticipantIdsDiffer(String participantId1, String participantId2) throws CryptoException {
        if (participantId1.equals(participantId2)) {
            throw new CryptoException("Both participants are using the same participantId (" + participantId1 + "). This is not allowed. Each participant must use a unique participantId.");
        }
    }

    public static void validateParticipantIdsEqual(String expectedParticipantId, String actualParticipantId) throws CryptoException {
        if (!expectedParticipantId.equals(actualParticipantId)) {
            throw new CryptoException("Received payload from incorrect partner (" + actualParticipantId + "). Expected to receive payload from " + expectedParticipantId + ".");
        }
    }

    public static void validateNotNull(Object object, String description) {
        if (object == null) {
            throw new NullPointerException(description + " must not be null");
        }
    }

    public static BigInteger calculateMacTag(String participantId, String partnerParticipantId, BigInteger gx1, BigInteger gx2, BigInteger gx3, BigInteger gx4, BigInteger keyingMaterial, Digest digest) {
        byte[] byArray = JPAKEUtil.a(keyingMaterial, digest);
        HMac hMac = new HMac(digest);
        byte[] byArray2 = new byte[hMac.getMacSize()];
        hMac.init(new KeyParameter(byArray));
        JPAKEUtil.a((Mac)hMac, "KC_1_U");
        JPAKEUtil.a((Mac)hMac, participantId);
        JPAKEUtil.a((Mac)hMac, partnerParticipantId);
        JPAKEUtil.a((Mac)hMac, gx1);
        JPAKEUtil.a((Mac)hMac, gx2);
        JPAKEUtil.a((Mac)hMac, gx3);
        JPAKEUtil.a((Mac)hMac, gx4);
        hMac.doFinal(byArray2, 0);
        Arrays.fill(byArray, (byte)0);
        return new BigInteger(byArray2);
    }

    private static byte[] a(BigInteger bigInteger, Digest digest) {
        digest.reset();
        JPAKEUtil.a(digest, bigInteger);
        JPAKEUtil.a(digest, "JPAKE_KC");
        byte[] byArray = new byte[digest.getDigestSize()];
        digest.doFinal(byArray, 0);
        return byArray;
    }

    public static void validateMacTag(String participantId, String partnerParticipantId, BigInteger gx1, BigInteger gx2, BigInteger gx3, BigInteger gx4, BigInteger keyingMaterial, Digest digest, BigInteger partnerMacTag) throws CryptoException {
        BigInteger bigInteger = JPAKEUtil.calculateMacTag(partnerParticipantId, participantId, gx3, gx4, gx1, gx2, keyingMaterial, digest);
        if (!bigInteger.equals(partnerMacTag)) {
            throw new CryptoException("Partner MacTag validation failed. Therefore, the password, MAC, or digest algorithm of each participant does not match.");
        }
    }

    private static void a(Digest digest, BigInteger bigInteger) {
        byte[] byArray = BigIntegers.asUnsignedByteArray(bigInteger);
        digest.update(byArray, 0, byArray.length);
        Arrays.fill(byArray, (byte)0);
    }

    private static void b(Digest digest, BigInteger bigInteger) {
        byte[] byArray = BigIntegers.asUnsignedByteArray(bigInteger);
        digest.update(JPAKEUtil.a(byArray.length), 0, 4);
        digest.update(byArray, 0, byArray.length);
        Arrays.fill(byArray, (byte)0);
    }

    private static void a(Digest digest, String string) {
        byte[] byArray = Strings.toUTF8ByteArray(string);
        digest.update(byArray, 0, byArray.length);
        Arrays.fill(byArray, (byte)0);
    }

    private static void b(Digest digest, String string) {
        byte[] byArray = Strings.toUTF8ByteArray(string);
        digest.update(JPAKEUtil.a(byArray.length), 0, 4);
        digest.update(byArray, 0, byArray.length);
        Arrays.fill(byArray, (byte)0);
    }

    private static void a(Mac mac, BigInteger bigInteger) {
        byte[] byArray = BigIntegers.asUnsignedByteArray(bigInteger);
        mac.update(byArray, 0, byArray.length);
        Arrays.fill(byArray, (byte)0);
    }

    private static void a(Mac mac, String string) {
        byte[] byArray = Strings.toUTF8ByteArray(string);
        mac.update(byArray, 0, byArray.length);
        Arrays.fill(byArray, (byte)0);
    }

    private static byte[] a(int n2) {
        return new byte[]{(byte)(n2 >>> 24), (byte)(n2 >>> 16), (byte)(n2 >>> 8), (byte)n2};
    }
}

