/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.commitments;

import com.enterprisedt.bouncycastle.crypto.Commitment;
import com.enterprisedt.bouncycastle.crypto.Committer;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class GeneralHashCommitter
implements Committer {
    private final Digest a;
    private final int b;
    private final SecureRandom c;

    public GeneralHashCommitter(ExtendedDigest digest, SecureRandom random) {
        this.a = digest;
        this.b = digest.getByteLength();
        this.c = random;
    }

    @Override
    public Commitment commit(byte[] message) {
        if (message.length > this.b / 2) {
            throw new DataLengthException("Message to be committed to too large for digest.");
        }
        byte[] byArray = new byte[this.b - message.length];
        this.c.nextBytes(byArray);
        return new Commitment(byArray, this.a(byArray, message));
    }

    @Override
    public boolean isRevealed(Commitment commitment, byte[] message) {
        if (message.length + commitment.getSecret().length != this.b) {
            throw new DataLengthException("Message and witness secret lengths do not match.");
        }
        byte[] byArray = this.a(commitment.getSecret(), message);
        return Arrays.constantTimeAreEqual(commitment.getCommitment(), byArray);
    }

    private byte[] a(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[this.a.getDigestSize()];
        this.a.update(byArray, 0, byArray.length);
        this.a.update(byArray2, 0, byArray2.length);
        this.a.update((byte)(byArray2.length >>> 8));
        this.a.update((byte)byArray2.length);
        this.a.doFinal(byArray3, 0);
        return byArray3;
    }
}

