/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.constraints;

import com.enterprisedt.bouncycastle.crypto.CryptoServiceConstraintsException;
import com.enterprisedt.bouncycastle.crypto.CryptoServiceProperties;
import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.constraints.ServicesConstraint;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;

public class LegacyBitsOfSecurityConstraint
extends ServicesConstraint {
    private final int a;
    private final int b;

    public LegacyBitsOfSecurityConstraint(int requiredBitsOfSecurity) {
        this(requiredBitsOfSecurity, 0);
    }

    public LegacyBitsOfSecurityConstraint(int requiredBitsOfSecurity, int legacyRequiredBitsOfSecurity) {
        super(Collections.EMPTY_SET);
        this.a = requiredBitsOfSecurity;
        this.b = legacyRequiredBitsOfSecurity;
    }

    public LegacyBitsOfSecurityConstraint(int requiredBitsOfSecurity, Set<String> exceptions) {
        this(requiredBitsOfSecurity, 0, exceptions);
    }

    public LegacyBitsOfSecurityConstraint(int requiredBitsOfSecurity, int legacyRequiredBitsOfSecurity, Set<String> exceptions) {
        super(exceptions);
        this.a = requiredBitsOfSecurity;
        this.b = legacyRequiredBitsOfSecurity;
    }

    @Override
    public void check(CryptoServiceProperties service) {
        if (this.isException(service.getServiceName())) {
            return;
        }
        CryptoServicePurpose cryptoServicePurpose = service.getPurpose();
        switch (cryptoServicePurpose) {
            case ANY: 
            case VERIFYING: 
            case DECRYPTION: 
            case VERIFICATION: {
                if (service.bitsOfSecurity() < this.b) {
                    throw new CryptoServiceConstraintsException("service does not provide " + this.b + " bits of security only " + service.bitsOfSecurity());
                }
                if (cryptoServicePurpose != CryptoServicePurpose.ANY && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("usage of legacy cryptography service for algorithm " + service.getServiceName());
                }
                return;
            }
        }
        if (service.bitsOfSecurity() < this.a) {
            throw new CryptoServiceConstraintsException("service does not provide " + this.a + " bits of security only " + service.bitsOfSecurity());
        }
    }
}

