/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import java.io.ByteArrayOutputStream;

public class AsconDigest
implements ExtendedDigest {
    AsconParameters a;
    private final String b;
    private final ByteArrayOutputStream c = new ByteArrayOutputStream();
    private long d;
    private long e;
    private long f;
    private long g;
    private long h;
    private final int i = 32;
    private final int j;

    public AsconDigest(AsconParameters parameters) {
        this.a = parameters;
        switch (parameters) {
            case AsconHash: {
                this.j = 12;
                this.b = "Ascon-Hash";
                break;
            }
            case AsconHashA: {
                this.j = 8;
                this.b = "Ascon-HashA";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameter settings for Ascon Hash");
            }
        }
        this.reset();
    }

    private long a(long l2, int n2) {
        return l2 >>> n2 | l2 << 64 - n2;
    }

    private void a(long l2) {
        long l3 = this.d ^ this.e ^ this.f ^ this.g ^ l2 ^ this.e & (this.d ^ this.f ^ this.h ^ l2);
        long l4 = this.d ^ this.f ^ this.g ^ this.h ^ l2 ^ (this.e ^ this.f ^ l2) & (this.e ^ this.g);
        long l5 = this.e ^ this.f ^ this.h ^ l2 ^ this.g & this.h;
        long l6 = this.d ^ this.e ^ this.f ^ l2 ^ (this.d ^ 0xFFFFFFFFFFFFFFFFL) & (this.g ^ this.h);
        long l7 = this.e ^ this.g ^ this.h ^ (this.d ^ this.h) & this.e;
        this.d = l3 ^ this.a(l3, 19) ^ this.a(l3, 28);
        this.e = l4 ^ this.a(l4, 39) ^ this.a(l4, 61);
        this.f = l5 ^ this.a(l5, 1) ^ this.a(l5, 6) ^ 0xFFFFFFFFFFFFFFFFL;
        this.g = l6 ^ this.a(l6, 10) ^ this.a(l6, 17);
        this.h = l7 ^ this.a(l7, 7) ^ this.a(l7, 41);
    }

    private void a(int n2) {
        if (n2 == 12) {
            this.a(240L);
            this.a(225L);
            this.a(210L);
            this.a(195L);
        }
        if (n2 >= 8) {
            this.a(180L);
            this.a(165L);
        }
        this.a(150L);
        this.a(135L);
        this.a(120L);
        this.a(105L);
        this.a(90L);
        this.a(75L);
    }

    private long b(int n2) {
        return 128L << 56 - (n2 << 3);
    }

    private long a(byte[] byArray, int n2, int n3) {
        long l2 = 0L;
        for (int i2 = 0; i2 < n3; ++i2) {
            l2 |= ((long)byArray[i2 + n2] & 0xFFL) << (7 - i2 << 3);
        }
        return l2;
    }

    private void a(byte[] byArray, int n2, long l2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[i2 + n2] = (byte)(l2 >>> (7 - i2 << 3));
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.b;
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public int getByteLength() {
        return 8;
    }

    @Override
    public void update(byte in) {
        this.c.write(in);
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.c.write(input, inOff, len);
    }

    @Override
    public int doFinal(byte[] output, int outOff) {
        int n2;
        if (32 + outOff > output.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        byte[] byArray = this.c.toByteArray();
        int n3 = 0;
        int n4 = 8;
        for (n2 = this.c.size(); n2 >= n4; n2 -= n4) {
            this.d ^= this.a(byArray, n3, 8);
            this.a(this.j);
            n3 += n4;
        }
        this.d ^= this.a(byArray, n3, n2);
        this.d ^= this.b(n2);
        int n5 = 12;
        this.a(n5);
        for (n2 = 32; n2 > n4; n2 -= n4) {
            this.a(output, outOff, this.d, 8);
            this.a(this.j);
            outOff += n4;
        }
        this.a(output, outOff, this.d, n2);
        this.reset();
        return 32;
    }

    @Override
    public void reset() {
        this.c.reset();
        switch (this.a) {
            case AsconHashA: {
                this.d = 92044056785660070L;
                this.e = 8326807761760157607L;
                this.f = 3371194088139667532L;
                this.g = -2956994353054992515L;
                this.h = -6828509670848688761L;
                break;
            }
            case AsconHash: {
                this.d = -1255492011513352131L;
                this.e = -8380609354527731710L;
                this.f = -5437372128236807582L;
                this.g = 4834782570098516968L;
                this.h = 3787428097924915520L;
            }
        }
    }

    public static enum AsconParameters {
        AsconHash,
        AsconHashA;

    }
}

