/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.Xof;
import java.io.ByteArrayOutputStream;

public class AsconXof
implements Xof {
    AsconParameters a;
    private final String b;
    private final ByteArrayOutputStream c = new ByteArrayOutputStream();
    private long d;
    private long e;
    private long f;
    private long g;
    private long h;
    private final int i = 32;
    private final int j;

    public AsconXof(AsconParameters parameters) {
        this.a = parameters;
        switch (parameters) {
            case AsconXof: {
                this.j = 12;
                this.b = "Ascon-Xof";
                break;
            }
            case AsconXofA: {
                this.j = 8;
                this.b = "Ascon-XofA";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameter settings for Ascon Hash");
            }
        }
        this.reset();
    }

    private long a(long l2, int n2) {
        return l2 >>> n2 | l2 << 64 - n2;
    }

    private void a(long l2) {
        long l3 = this.d ^ this.e ^ this.f ^ this.g ^ l2 ^ this.e & (this.d ^ this.f ^ this.h ^ l2);
        long l4 = this.d ^ this.f ^ this.g ^ this.h ^ l2 ^ (this.e ^ this.f ^ l2) & (this.e ^ this.g);
        long l5 = this.e ^ this.f ^ this.h ^ l2 ^ this.g & this.h;
        long l6 = this.d ^ this.e ^ this.f ^ l2 ^ (this.d ^ 0xFFFFFFFFFFFFFFFFL) & (this.g ^ this.h);
        long l7 = this.e ^ this.g ^ this.h ^ (this.d ^ this.h) & this.e;
        this.d = l3 ^ this.a(l3, 19) ^ this.a(l3, 28);
        this.e = l4 ^ this.a(l4, 39) ^ this.a(l4, 61);
        this.f = l5 ^ this.a(l5, 1) ^ this.a(l5, 6) ^ 0xFFFFFFFFFFFFFFFFL;
        this.g = l6 ^ this.a(l6, 10) ^ this.a(l6, 17);
        this.h = l7 ^ this.a(l7, 7) ^ this.a(l7, 41);
    }

    private void a(int n2) {
        if (n2 == 12) {
            this.a(240L);
            this.a(225L);
            this.a(210L);
            this.a(195L);
        }
        if (n2 >= 8) {
            this.a(180L);
            this.a(165L);
        }
        this.a(150L);
        this.a(135L);
        this.a(120L);
        this.a(105L);
        this.a(90L);
        this.a(75L);
    }

    private long b(int n2) {
        return 128L << 56 - (n2 << 3);
    }

    private long a(byte[] byArray, int n2, int n3) {
        long l2 = 0L;
        for (int i2 = 0; i2 < n3; ++i2) {
            l2 |= ((long)byArray[i2 + n2] & 0xFFL) << (7 - i2 << 3);
        }
        return l2;
    }

    private void a(byte[] byArray, int n2, long l2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[i2 + n2] = (byte)(l2 >>> (7 - i2 << 3));
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.b;
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public void update(byte in) {
        this.c.write(in);
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.c.write(input, inOff, len);
    }

    @Override
    public int doOutput(byte[] output, int outOff, int outLen) {
        int n2;
        if (32 + outOff > output.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        byte[] byArray = this.c.toByteArray();
        int n3 = 0;
        int n4 = 8;
        for (n2 = this.c.size(); n2 >= n4; n2 -= n4) {
            this.d ^= this.a(byArray, n3, 8);
            this.a(this.j);
            n3 += n4;
        }
        this.d ^= this.a(byArray, n3, n2);
        this.d ^= this.b(n2);
        int n5 = 12;
        this.a(n5);
        for (n2 = 32; n2 > n4; n2 -= n4) {
            this.a(output, outOff, this.d, 8);
            this.a(this.j);
            outOff += n4;
        }
        this.a(output, outOff, this.d, n2);
        this.reset();
        return 32;
    }

    @Override
    public int doFinal(byte[] output, int outOff) {
        return this.doOutput(output, outOff, this.getDigestSize());
    }

    @Override
    public int doFinal(byte[] output, int outOff, int outLen) {
        return this.doOutput(output, outOff, outLen);
    }

    @Override
    public int getByteLength() {
        return 8;
    }

    @Override
    public void reset() {
        this.c.reset();
        switch (this.a) {
            case AsconXof: {
                this.d = -5368810569253202922L;
                this.e = 3121280575360345120L;
                this.f = 7395939140700676632L;
                this.g = 6533890155656471820L;
                this.h = 5710016986865767350L;
                break;
            }
            case AsconXofA: {
                this.d = 4940560291654768690L;
                this.e = -3635129828240960206L;
                this.f = -597534922722107095L;
                this.g = 2623493988082852443L;
                this.h = -6283826724160825537L;
            }
        }
    }

    public static enum AsconParameters {
        AsconXof,
        AsconXofA;

    }
}

