/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.digests.a;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Longs;
import com.enterprisedt.bouncycastle.util.Pack;

public class Blake2bDigest
implements ExtendedDigest {
    private static final long[] a = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};
    private static final byte[][] b = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}, {11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4}, {7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8}, {9, 0, 5, 7, 2, 4, 10, 15, 14, 1, 11, 12, 6, 8, 3, 13}, {2, 12, 6, 10, 0, 11, 8, 3, 4, 13, 7, 5, 15, 14, 1, 9}, {12, 5, 1, 15, 14, 13, 4, 10, 0, 7, 6, 3, 9, 2, 8, 11}, {13, 11, 7, 14, 12, 1, 3, 9, 5, 0, 15, 4, 8, 6, 2, 10}, {6, 15, 14, 9, 11, 3, 0, 8, 12, 2, 13, 7, 1, 4, 10, 5}, {10, 2, 8, 4, 7, 6, 1, 5, 15, 11, 9, 14, 3, 12, 13, 0}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}};
    private static int c = 12;
    private int d = 64;
    private int e = 0;
    private byte[] f = null;
    private byte[] g = null;
    private byte[] h = null;
    private int i = 1;
    private int j = 1;
    private int k = 0;
    private long l = 0L;
    private int m = 0;
    private int n = 0;
    private boolean o = false;
    private byte[] p = null;
    private int q = 0;
    private long[] r = new long[16];
    private long[] s = null;
    private long t = 0L;
    private long u = 0L;
    private long v = 0L;
    private long w = 0L;
    private final CryptoServicePurpose x;

    public Blake2bDigest() {
        this(512, CryptoServicePurpose.ANY);
    }

    public Blake2bDigest(int digestSize) {
        this(digestSize, CryptoServicePurpose.ANY);
    }

    public Blake2bDigest(Blake2bDigest digest) {
        this.q = digest.q;
        this.p = Arrays.clone(digest.p);
        this.e = digest.e;
        this.h = Arrays.clone(digest.h);
        this.d = digest.d;
        this.s = Arrays.clone(digest.s);
        this.g = Arrays.clone(digest.g);
        this.f = Arrays.clone(digest.f);
        this.t = digest.t;
        this.u = digest.u;
        this.v = digest.v;
        this.x = digest.x;
    }

    public Blake2bDigest(int digestSize, CryptoServicePurpose purpose) {
        this.x = purpose;
        if (digestSize < 8 || digestSize > 512 || digestSize % 8 != 0) {
            throw new IllegalArgumentException("BLAKE2b digest bit length must be a multiple of 8 and not greater than 512");
        }
        this.p = new byte[128];
        this.e = 0;
        this.d = digestSize / 8;
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.digests.a.a(this, digestSize, purpose));
        this.a();
    }

    public Blake2bDigest(byte[] key) {
        this(key, CryptoServicePurpose.ANY);
    }

    public Blake2bDigest(byte[] key, CryptoServicePurpose purpose) {
        this.p = new byte[128];
        if (key != null) {
            this.h = new byte[key.length];
            System.arraycopy(key, 0, this.h, 0, key.length);
            if (key.length > 64) {
                throw new IllegalArgumentException("Keys > 64 are not supported");
            }
            this.e = key.length;
            System.arraycopy(key, 0, this.p, 0, key.length);
            this.q = 128;
        }
        this.x = purpose;
        this.d = 64;
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.digests.a.a(this, this.d * 8, purpose));
        this.a();
    }

    public Blake2bDigest(byte[] key, int digestLength, byte[] salt, byte[] personalization) {
        this(key, digestLength, salt, personalization, CryptoServicePurpose.ANY);
    }

    public Blake2bDigest(byte[] key, int digestLength, byte[] salt, byte[] personalization, CryptoServicePurpose purpose) {
        this.x = purpose;
        this.p = new byte[128];
        if (digestLength < 1 || digestLength > 64) {
            throw new IllegalArgumentException("Invalid digest length (required: 1 - 64)");
        }
        this.d = digestLength;
        if (salt != null) {
            if (salt.length != 16) {
                throw new IllegalArgumentException("salt length must be exactly 16 bytes");
            }
            this.f = new byte[16];
            System.arraycopy(salt, 0, this.f, 0, salt.length);
        }
        if (personalization != null) {
            if (personalization.length != 16) {
                throw new IllegalArgumentException("personalization length must be exactly 16 bytes");
            }
            this.g = new byte[16];
            System.arraycopy(personalization, 0, this.g, 0, personalization.length);
        }
        if (key != null) {
            this.h = new byte[key.length];
            System.arraycopy(key, 0, this.h, 0, key.length);
            if (key.length > 64) {
                throw new IllegalArgumentException("Keys > 64 are not supported");
            }
            this.e = key.length;
            System.arraycopy(key, 0, this.p, 0, key.length);
            this.q = 128;
        }
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.digests.a.a(this, digestLength * 8, purpose));
        this.a();
    }

    public Blake2bDigest(byte[] key, byte[] param) {
        this.p = new byte[128];
        this.x = CryptoServicePurpose.ANY;
        this.d = param[0];
        this.e = param[1];
        this.i = param[2];
        this.j = param[3];
        this.k = Pack.littleEndianToInt(param, 4);
        this.l |= (long)Pack.littleEndianToInt(param, 8);
        this.m = param[16];
        this.n = param[17];
        this.a();
    }

    private void a() {
        if (this.s == null) {
            this.s = new long[8];
            this.s[0] = a[0] ^ (long)(this.d | this.e << 8 | (this.i << 16 | this.j << 24 | this.k << 32));
            this.s[1] = a[1] ^ this.l;
            this.s[2] = a[2] ^ (long)(this.m | this.n << 8);
            this.s[3] = a[3];
            this.s[4] = a[4];
            this.s[5] = a[5];
            if (this.f != null) {
                this.s[4] = this.s[4] ^ Pack.littleEndianToLong(this.f, 0);
                this.s[5] = this.s[5] ^ Pack.littleEndianToLong(this.f, 8);
            }
            this.s[6] = a[6];
            this.s[7] = a[7];
            if (this.g != null) {
                this.s[6] = this.s[6] ^ Pack.littleEndianToLong(this.g, 0);
                this.s[7] = this.s[7] ^ Pack.littleEndianToLong(this.g, 8);
            }
        }
    }

    private void b() {
        System.arraycopy(this.s, 0, this.r, 0, this.s.length);
        System.arraycopy(a, 0, this.r, this.s.length, 4);
        this.r[12] = this.t ^ a[4];
        this.r[13] = this.u ^ a[5];
        this.r[14] = this.v ^ a[6];
        this.r[15] = this.w ^ a[7];
    }

    @Override
    public void update(byte b2) {
        int n2 = 0;
        n2 = 128 - this.q;
        if (n2 == 0) {
            this.t += 128L;
            if (this.t == 0L) {
                ++this.u;
            }
        } else {
            this.p[this.q] = b2;
            ++this.q;
            return;
        }
        this.a(this.p, 0);
        Arrays.fill(this.p, (byte)0);
        this.p[0] = b2;
        this.q = 1;
    }

    @Override
    public void update(byte[] message, int offset, int len) {
        int n2;
        if (message == null || len == 0) {
            return;
        }
        int n3 = 0;
        if (this.q != 0) {
            n3 = 128 - this.q;
            if (n3 < len) {
                System.arraycopy(message, offset, this.p, this.q, n3);
                this.t += 128L;
                if (this.t == 0L) {
                    ++this.u;
                }
                this.a(this.p, 0);
                this.q = 0;
                Arrays.fill(this.p, (byte)0);
            } else {
                System.arraycopy(message, offset, this.p, this.q, len);
                this.q += len;
                return;
            }
        }
        int n4 = offset + len - 128;
        for (n2 = offset + n3; n2 < n4; n2 += 128) {
            this.t += 128L;
            if (this.t == 0L) {
                ++this.u;
            }
            this.a(message, n2);
        }
        System.arraycopy(message, n2, this.p, 0, offset + len - n2);
        this.q += offset + len - n2;
    }

    @Override
    public int doFinal(byte[] out, int outOffset) {
        if (outOffset > out.length - this.d) {
            throw new OutputLengthException("output buffer too short");
        }
        this.v = -1L;
        if (this.o) {
            this.w = -1L;
        }
        this.t += (long)this.q;
        if (this.q > 0 && this.t == 0L) {
            ++this.u;
        }
        this.a(this.p, 0);
        Arrays.fill(this.p, (byte)0);
        Arrays.fill(this.r, 0L);
        int n2 = this.d >>> 3;
        int n3 = this.d & 7;
        Pack.longToLittleEndian(this.s, 0, n2, out, outOffset);
        if (n3 > 0) {
            byte[] byArray = new byte[8];
            Pack.longToLittleEndian(this.s[n2], byArray, 0);
            System.arraycopy(byArray, 0, out, outOffset + this.d - n3, n3);
        }
        Arrays.fill(this.s, 0L);
        this.reset();
        return this.d;
    }

    @Override
    public void reset() {
        this.q = 0;
        this.v = 0L;
        this.w = 0L;
        this.t = 0L;
        this.u = 0L;
        this.o = false;
        this.s = null;
        Arrays.fill(this.p, (byte)0);
        if (this.h != null) {
            System.arraycopy(this.h, 0, this.p, 0, this.h.length);
            this.q = 128;
        }
        this.a();
    }

    private void a(byte[] byArray, int n2) {
        int n3;
        this.b();
        long[] lArray = new long[16];
        Pack.littleEndianToLong(byArray, n2, lArray);
        for (n3 = 0; n3 < c; ++n3) {
            this.a(lArray[b[n3][0]], lArray[b[n3][1]], 0, 4, 8, 12);
            this.a(lArray[b[n3][2]], lArray[b[n3][3]], 1, 5, 9, 13);
            this.a(lArray[b[n3][4]], lArray[b[n3][5]], 2, 6, 10, 14);
            this.a(lArray[b[n3][6]], lArray[b[n3][7]], 3, 7, 11, 15);
            this.a(lArray[b[n3][8]], lArray[b[n3][9]], 0, 5, 10, 15);
            this.a(lArray[b[n3][10]], lArray[b[n3][11]], 1, 6, 11, 12);
            this.a(lArray[b[n3][12]], lArray[b[n3][13]], 2, 7, 8, 13);
            this.a(lArray[b[n3][14]], lArray[b[n3][15]], 3, 4, 9, 14);
        }
        for (n3 = 0; n3 < this.s.length; ++n3) {
            this.s[n3] = this.s[n3] ^ this.r[n3] ^ this.r[n3 + 8];
        }
    }

    private void a(long l2, long l3, int n2, int n3, int n4, int n5) {
        this.r[n2] = this.r[n2] + this.r[n3] + l2;
        this.r[n5] = Longs.rotateRight(this.r[n5] ^ this.r[n2], 32);
        this.r[n4] = this.r[n4] + this.r[n5];
        this.r[n3] = Longs.rotateRight(this.r[n3] ^ this.r[n4], 24);
        this.r[n2] = this.r[n2] + this.r[n3] + l3;
        this.r[n5] = Longs.rotateRight(this.r[n5] ^ this.r[n2], 16);
        this.r[n4] = this.r[n4] + this.r[n5];
        this.r[n3] = Longs.rotateRight(this.r[n3] ^ this.r[n4], 63);
    }

    protected void setAsLastNode() {
        this.o = true;
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2b";
    }

    @Override
    public int getDigestSize() {
        return this.d;
    }

    @Override
    public int getByteLength() {
        return 128;
    }

    public void clearKey() {
        if (this.h != null) {
            Arrays.fill(this.h, (byte)0);
            Arrays.fill(this.p, (byte)0);
        }
    }

    public void clearSalt() {
        if (this.f != null) {
            Arrays.fill(this.f, (byte)0);
        }
    }
}

