/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;
import com.enterprisedt.bouncycastle.crypto.digests.Blake2bDigest;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;

public class Blake2bpDigest
implements ExtendedDigest {
    private int a = 0;
    private int b = 0;
    private int c;
    private int d;
    private int e;
    private int f = 0;
    private long g;
    private Blake2bDigest[] h = new Blake2bDigest[4];
    private Blake2bDigest i;
    private byte[] j = null;
    private byte[] k = null;
    private byte[] l = null;
    private byte[] m = null;
    private final int n = 128;
    private final int o = 64;
    private final int p = 64;
    private final int q = 4;
    private final byte[] r = new byte[1];

    public Blake2bpDigest(byte[] key) {
        this.l = new byte[64];
        this.j = new byte[512];
        this.a(key);
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2bp";
    }

    @Override
    public int getDigestSize() {
        return this.c;
    }

    @Override
    public void update(byte in) {
        this.r[0] = in;
        this.update(this.r, 0, 1);
    }

    @Override
    public void update(byte[] message, int offset, int len) {
        int n2;
        int n3 = this.a;
        int n4 = 1024 - n3;
        if (n3 != 0 && len >= n4) {
            System.arraycopy(message, offset, this.j, n3, n4);
            for (n2 = 0; n2 < 4; ++n2) {
                this.h[n2].update(this.j, n2 * 128, 128);
            }
            offset += n4;
            len -= n4;
            n3 = 0;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            int n5 = offset;
            n5 += n2 * 128;
            for (int i2 = len; i2 >= 512; i2 -= 512) {
                this.h[n2].update(message, n5, 128);
                n5 += 512;
            }
        }
        offset += len - len % 512;
        if ((len %= 512) > 0) {
            System.arraycopy(message, offset, this.j, n3, len);
        }
        this.a = n3 + len;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        int n2;
        byte[][] byArray = new byte[4][64];
        int n3 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            if (this.a > n2 * 128) {
                n3 = this.a - n2 * 128;
                if (n3 > 128) {
                    n3 = 128;
                }
                this.h[n2].update(this.j, n2 * 128, n3);
            }
            this.h[n2].doFinal(byArray[n2], 0);
        }
        for (n2 = 0; n2 < 4; ++n2) {
            this.i.update(byArray[n2], 0, 64);
        }
        n2 = this.i.doFinal(out, outOff);
        this.reset();
        return n2;
    }

    @Override
    public void reset() {
        this.a = 0;
        this.c = 64;
        this.i.reset();
        for (int i2 = 0; i2 < 4; ++i2) {
            this.h[i2].reset();
        }
        this.i.setAsLastNode();
        this.h[3].setAsLastNode();
        if (this.m != null) {
            byte[] byArray = new byte[128];
            System.arraycopy(this.m, 0, byArray, 0, this.b);
            for (int i3 = 0; i3 < 4; ++i3) {
                this.h[i3].update(byArray, 0, 128);
            }
        }
    }

    @Override
    public int getByteLength() {
        return 0;
    }

    private void a(byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            this.b = byArray.length;
            if (this.b > 64) {
                throw new IllegalArgumentException("Keys > 64 bytes are not supported");
            }
            this.m = Arrays.clone(byArray);
        }
        this.a = 0;
        this.c = 64;
        this.d = 4;
        this.e = 2;
        this.g = 64L;
        this.l[0] = (byte)this.c;
        this.l[1] = (byte)this.b;
        this.l[2] = (byte)this.d;
        this.l[3] = (byte)this.e;
        this.l[16] = 1;
        this.l[17] = (byte)this.g;
        this.i = new Blake2bDigest(null, this.l);
        Pack.intToLittleEndian(this.f, this.l, 8);
        this.l[16] = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            Pack.intToLittleEndian(i2, this.l, 8);
            this.h[i2] = new Blake2bDigest(null, this.l);
        }
        this.i.setAsLastNode();
        this.h[3].setAsLastNode();
        if (byArray != null && this.b > 0) {
            byte[] byArray2 = new byte[128];
            System.arraycopy(byArray, 0, byArray2, 0, this.b);
            for (int i3 = 0; i3 < 4; ++i3) {
                this.h[i3].update(byArray2, 0, 128);
            }
        }
    }
}

