/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.digests.a;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Integers;
import com.enterprisedt.bouncycastle.util.Pack;

public class Blake2sDigest
implements ExtendedDigest {
    private static final int[] a = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final byte[][] b = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}, {11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4}, {7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8}, {9, 0, 5, 7, 2, 4, 10, 15, 14, 1, 11, 12, 6, 8, 3, 13}, {2, 12, 6, 10, 0, 11, 8, 3, 4, 13, 7, 5, 15, 14, 1, 9}, {12, 5, 1, 15, 14, 13, 4, 10, 0, 7, 6, 3, 9, 2, 8, 11}, {13, 11, 7, 14, 12, 1, 3, 9, 5, 0, 15, 4, 8, 6, 2, 10}, {6, 15, 14, 9, 11, 3, 0, 8, 12, 2, 13, 7, 1, 4, 10, 5}, {10, 2, 8, 4, 7, 6, 1, 5, 15, 11, 9, 14, 3, 12, 13, 0}};
    private int c = 32;
    private int d = 0;
    private byte[] e = null;
    private byte[] f = null;
    private byte[] g = null;
    private int h = 1;
    private int i = 1;
    private int j = 0;
    private long k = 0L;
    private int l = 0;
    private int m = 0;
    private boolean n = false;
    private byte[] o = null;
    private int p = 0;
    private int[] q = new int[16];
    private int[] r = null;
    private int s = 0;
    private int t = 0;
    private int u = 0;
    private int v = 0;
    private final CryptoServicePurpose w;

    public Blake2sDigest() {
        this(256, CryptoServicePurpose.ANY);
    }

    public Blake2sDigest(int digestSize) {
        this(digestSize, CryptoServicePurpose.ANY);
    }

    public Blake2sDigest(Blake2sDigest digest) {
        this.p = digest.p;
        this.o = Arrays.clone(digest.o);
        this.d = digest.d;
        this.g = Arrays.clone(digest.g);
        this.c = digest.c;
        this.q = Arrays.clone(digest.q);
        this.r = Arrays.clone(digest.r);
        this.s = digest.s;
        this.t = digest.t;
        this.u = digest.u;
        this.e = Arrays.clone(digest.e);
        this.f = Arrays.clone(digest.f);
        this.h = digest.h;
        this.i = digest.i;
        this.j = digest.j;
        this.k = digest.k;
        this.l = digest.l;
        this.m = digest.m;
        this.w = digest.w;
    }

    public Blake2sDigest(int digestBits, CryptoServicePurpose purpose) {
        if (digestBits < 8 || digestBits > 256 || digestBits % 8 != 0) {
            throw new IllegalArgumentException("BLAKE2s digest bit length must be a multiple of 8 and not greater than 256");
        }
        this.c = digestBits / 8;
        this.w = purpose;
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.digests.a.a(this, digestBits, purpose));
        this.a(null, null, null);
    }

    public Blake2sDigest(byte[] key) {
        this(key, CryptoServicePurpose.ANY);
    }

    public Blake2sDigest(byte[] key, CryptoServicePurpose purpose) {
        this.w = purpose;
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.digests.a.a(this, key.length * 8, purpose));
        this.a(null, null, key);
    }

    public Blake2sDigest(byte[] key, int digestBytes, byte[] salt, byte[] personalization) {
        this(key, digestBytes, salt, personalization, CryptoServicePurpose.ANY);
    }

    public Blake2sDigest(byte[] key, int digestBytes, byte[] salt, byte[] personalization, CryptoServicePurpose purpose) {
        if (digestBytes < 1 || digestBytes > 32) {
            throw new IllegalArgumentException("Invalid digest length (required: 1 - 32)");
        }
        this.c = digestBytes;
        this.w = purpose;
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.digests.a.a(this, digestBytes * 8, purpose));
        this.a(salt, personalization, key);
    }

    Blake2sDigest(int digestBytes, byte[] key, byte[] salt, byte[] personalization, long offset, CryptoServicePurpose purpose) {
        this.c = digestBytes;
        this.k = offset;
        this.w = purpose;
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.digests.a.a(this, digestBytes * 8, purpose));
        this.a(salt, personalization, key);
    }

    Blake2sDigest(int digestBytes, int hashLength, long offset) {
        this(digestBytes, hashLength, offset, CryptoServicePurpose.ANY);
    }

    Blake2sDigest(int digestBytes, int hashLength, long offset, CryptoServicePurpose purpose) {
        this.c = digestBytes;
        this.k = offset;
        this.h = 0;
        this.i = 0;
        this.j = hashLength;
        this.m = hashLength;
        this.l = 0;
        this.w = purpose;
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.digests.a.a(this, digestBytes * 8, purpose));
        this.a(null, null, null);
    }

    Blake2sDigest(byte[] key, byte[] param) {
        this.w = CryptoServicePurpose.ANY;
        this.c = param[0];
        this.d = param[1];
        this.h = param[2];
        this.i = param[3];
        this.j = Pack.littleEndianToInt(param, 4);
        this.k |= (long)Pack.littleEndianToInt(param, 8);
        this.l = param[14];
        this.m = param[15];
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[8];
        System.arraycopy(param, 16, byArray, 0, 8);
        System.arraycopy(param, 24, byArray2, 0, 8);
        this.a(byArray, byArray2, key);
    }

    private void a(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.o = new byte[64];
        if (byArray3 != null && byArray3.length > 0) {
            this.d = byArray3.length;
            if (this.d > 32) {
                throw new IllegalArgumentException("Keys > 32 bytes are not supported");
            }
            this.g = new byte[this.d];
            System.arraycopy(byArray3, 0, this.g, 0, this.d);
            System.arraycopy(byArray3, 0, this.o, 0, this.d);
            this.p = 64;
        }
        if (this.r == null) {
            this.r = new int[8];
            this.r[0] = a[0] ^ (this.c | this.d << 8 | (this.h << 16 | this.i << 24));
            this.r[1] = a[1] ^ this.j;
            int n2 = (int)(this.k >> 32);
            int n3 = (int)this.k;
            this.r[2] = a[2] ^ n3;
            this.r[3] = a[3] ^ (n2 | this.l << 16 | this.m << 24);
            this.r[4] = a[4];
            this.r[5] = a[5];
            if (byArray != null) {
                if (byArray.length != 8) {
                    throw new IllegalArgumentException("Salt length must be exactly 8 bytes");
                }
                this.e = new byte[8];
                System.arraycopy(byArray, 0, this.e, 0, byArray.length);
                this.r[4] = this.r[4] ^ Pack.littleEndianToInt(byArray, 0);
                this.r[5] = this.r[5] ^ Pack.littleEndianToInt(byArray, 4);
            }
            this.r[6] = a[6];
            this.r[7] = a[7];
            if (byArray2 != null) {
                if (byArray2.length != 8) {
                    throw new IllegalArgumentException("Personalization length must be exactly 8 bytes");
                }
                this.f = new byte[8];
                System.arraycopy(byArray2, 0, this.f, 0, byArray2.length);
                this.r[6] = this.r[6] ^ Pack.littleEndianToInt(byArray2, 0);
                this.r[7] = this.r[7] ^ Pack.littleEndianToInt(byArray2, 4);
            }
        }
    }

    private void a() {
        System.arraycopy(this.r, 0, this.q, 0, this.r.length);
        System.arraycopy(a, 0, this.q, this.r.length, 4);
        this.q[12] = this.s ^ a[4];
        this.q[13] = this.t ^ a[5];
        this.q[14] = this.u ^ a[6];
        this.q[15] = this.v ^ a[7];
    }

    @Override
    public void update(byte b2) {
        int n2 = 64 - this.p;
        if (n2 == 0) {
            this.s += 64;
            if (this.s == 0) {
                ++this.t;
            }
            this.a(this.o, 0);
            Arrays.fill(this.o, (byte)0);
            this.o[0] = b2;
            this.p = 1;
        } else {
            this.o[this.p] = b2;
            ++this.p;
        }
    }

    @Override
    public void update(byte[] message, int offset, int len) {
        int n2;
        if (message == null || len == 0) {
            return;
        }
        int n3 = 0;
        if (this.p != 0) {
            n3 = 64 - this.p;
            if (n3 < len) {
                System.arraycopy(message, offset, this.o, this.p, n3);
                this.s += 64;
                if (this.s == 0) {
                    ++this.t;
                }
                this.a(this.o, 0);
                this.p = 0;
                Arrays.fill(this.o, (byte)0);
            } else {
                System.arraycopy(message, offset, this.o, this.p, len);
                this.p += len;
                return;
            }
        }
        int n4 = offset + len - 64;
        for (n2 = offset + n3; n2 < n4; n2 += 64) {
            this.s += 64;
            if (this.s == 0) {
                ++this.t;
            }
            this.a(message, n2);
        }
        System.arraycopy(message, n2, this.o, 0, offset + len - n2);
        this.p += offset + len - n2;
    }

    @Override
    public int doFinal(byte[] out, int outOffset) {
        if (outOffset > out.length - this.c) {
            throw new OutputLengthException("output buffer too short");
        }
        this.u = -1;
        if (this.n) {
            this.v = -1;
        }
        this.s += this.p;
        if (this.s < 0 && this.p > -this.s) {
            ++this.t;
        }
        this.a(this.o, 0);
        Arrays.fill(this.o, (byte)0);
        Arrays.fill(this.q, 0);
        int n2 = this.c >>> 2;
        int n3 = this.c & 3;
        Pack.intToLittleEndian(this.r, 0, n2, out, outOffset);
        if (n3 > 0) {
            byte[] byArray = new byte[4];
            Pack.intToLittleEndian(this.r[n2], byArray, 0);
            System.arraycopy(byArray, 0, out, outOffset + this.c - n3, n3);
        }
        Arrays.fill(this.r, 0);
        this.reset();
        return this.c;
    }

    @Override
    public void reset() {
        this.p = 0;
        this.u = 0;
        this.v = 0;
        this.s = 0;
        this.t = 0;
        this.n = false;
        this.r = null;
        Arrays.fill(this.o, (byte)0);
        if (this.g != null) {
            System.arraycopy(this.g, 0, this.o, 0, this.g.length);
            this.p = 64;
        }
        this.a(this.e, this.f, this.g);
    }

    private void a(byte[] byArray, int n2) {
        int n3;
        this.a();
        int[] nArray = new int[16];
        Pack.littleEndianToInt(byArray, n2, nArray);
        for (n3 = 0; n3 < 10; ++n3) {
            this.a(nArray[b[n3][0]], nArray[b[n3][1]], 0, 4, 8, 12);
            this.a(nArray[b[n3][2]], nArray[b[n3][3]], 1, 5, 9, 13);
            this.a(nArray[b[n3][4]], nArray[b[n3][5]], 2, 6, 10, 14);
            this.a(nArray[b[n3][6]], nArray[b[n3][7]], 3, 7, 11, 15);
            this.a(nArray[b[n3][8]], nArray[b[n3][9]], 0, 5, 10, 15);
            this.a(nArray[b[n3][10]], nArray[b[n3][11]], 1, 6, 11, 12);
            this.a(nArray[b[n3][12]], nArray[b[n3][13]], 2, 7, 8, 13);
            this.a(nArray[b[n3][14]], nArray[b[n3][15]], 3, 4, 9, 14);
        }
        for (n3 = 0; n3 < this.r.length; ++n3) {
            this.r[n3] = this.r[n3] ^ this.q[n3] ^ this.q[n3 + 8];
        }
    }

    private void a(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.q[n4] = this.q[n4] + this.q[n5] + n2;
        this.q[n7] = Integers.rotateRight(this.q[n7] ^ this.q[n4], 16);
        this.q[n6] = this.q[n6] + this.q[n7];
        this.q[n5] = Integers.rotateRight(this.q[n5] ^ this.q[n6], 12);
        this.q[n4] = this.q[n4] + this.q[n5] + n3;
        this.q[n7] = Integers.rotateRight(this.q[n7] ^ this.q[n4], 8);
        this.q[n6] = this.q[n6] + this.q[n7];
        this.q[n5] = Integers.rotateRight(this.q[n5] ^ this.q[n6], 7);
    }

    protected void setAsLastNode() {
        this.n = true;
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2s";
    }

    @Override
    public int getDigestSize() {
        return this.c;
    }

    @Override
    public int getByteLength() {
        return 64;
    }

    public void clearKey() {
        if (this.g != null) {
            Arrays.fill(this.g, (byte)0);
            Arrays.fill(this.o, (byte)0);
        }
    }

    public void clearSalt() {
        if (this.e != null) {
            Arrays.fill(this.e, (byte)0);
        }
    }
}

