/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;
import com.enterprisedt.bouncycastle.crypto.digests.Blake2sDigest;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;

public class Blake2spDigest
implements ExtendedDigest {
    private int a = 0;
    private int b = 0;
    private int c;
    private int d;
    private int e;
    private int f = 0;
    private long g;
    private Blake2sDigest[] h = new Blake2sDigest[8];
    private Blake2sDigest i;
    private byte[] j = null;
    private byte[] k = null;
    private byte[] l = null;
    private byte[] m = null;
    private final int n = 64;
    private final int o = 32;
    private final int p = 32;
    private final int q = 8;
    private final byte[] r = new byte[1];

    public Blake2spDigest(byte[] key) {
        this.l = new byte[32];
        this.j = new byte[512];
        this.a(key);
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2sp";
    }

    @Override
    public int getDigestSize() {
        return this.c;
    }

    @Override
    public void update(byte in) {
        this.r[0] = in;
        this.update(this.r, 0, 1);
    }

    @Override
    public void update(byte[] message, int offset, int len) {
        int n2;
        int n3 = this.a;
        int n4 = 512 - n3;
        if (n3 != 0 && len >= n4) {
            System.arraycopy(message, offset, this.j, n3, n4);
            for (n2 = 0; n2 < 8; ++n2) {
                this.h[n2].update(this.j, n2 * 64, 64);
            }
            offset += n4;
            len -= n4;
            n3 = 0;
        }
        for (n2 = 0; n2 < 8; ++n2) {
            int n5 = offset;
            n5 += n2 * 64;
            for (int i2 = len; i2 >= 512; i2 -= 512) {
                this.h[n2].update(message, n5, 64);
                n5 += 512;
            }
        }
        offset += len - len % 512;
        if ((len %= 512) > 0) {
            System.arraycopy(message, offset, this.j, n3, len);
        }
        this.a = n3 + len;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        int n2;
        byte[][] byArray = new byte[8][32];
        int n3 = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            if (this.a > n2 * 64) {
                n3 = this.a - n2 * 64;
                if (n3 > 64) {
                    n3 = 64;
                }
                this.h[n2].update(this.j, n2 * 64, n3);
            }
            this.h[n2].doFinal(byArray[n2], 0);
        }
        for (n2 = 0; n2 < 8; ++n2) {
            this.i.update(byArray[n2], 0, 32);
        }
        n2 = this.i.doFinal(out, outOff);
        this.reset();
        return n2;
    }

    @Override
    public void reset() {
        this.a = 0;
        this.c = 32;
        this.i.reset();
        for (int i2 = 0; i2 < 8; ++i2) {
            this.h[i2].reset();
        }
        this.i.setAsLastNode();
        this.h[7].setAsLastNode();
        if (this.m != null) {
            byte[] byArray = new byte[64];
            System.arraycopy(this.m, 0, byArray, 0, this.b);
            for (int i3 = 0; i3 < 8; ++i3) {
                this.h[i3].update(byArray, 0, 64);
            }
        }
    }

    @Override
    public int getByteLength() {
        return 64;
    }

    private void a(byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            this.b = byArray.length;
            if (this.b > 32) {
                throw new IllegalArgumentException("Keys > 32 bytes are not supported");
            }
            this.m = Arrays.clone(byArray);
        }
        this.a = 0;
        this.c = 32;
        this.d = 8;
        this.e = 2;
        this.g = 32L;
        this.l[0] = (byte)this.c;
        this.l[1] = (byte)this.b;
        this.l[2] = (byte)this.d;
        this.l[3] = (byte)this.e;
        Pack.intToLittleEndian(0, this.l, 8);
        this.l[14] = 1;
        this.l[15] = (byte)this.g;
        this.i = new Blake2sDigest(null, this.l);
        Pack.intToLittleEndian(this.f, this.l, 8);
        this.l[14] = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            Pack.intToLittleEndian(i2, this.l, 8);
            this.h[i2] = new Blake2sDigest(null, this.l);
        }
        this.i.setAsLastNode();
        this.h[7].setAsLastNode();
        if (byArray != null && this.b > 0) {
            byte[] byArray2 = new byte[64];
            System.arraycopy(byArray, 0, byArray2, 0, this.b);
            for (int i3 = 0; i3 < 8; ++i3) {
                this.h[i3].update(byArray2, 0, 64);
            }
        }
    }
}

