/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CryptoServiceProperties;
import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;
import com.enterprisedt.bouncycastle.crypto.digests.a;
import com.enterprisedt.bouncycastle.crypto.engines.GOST28147Engine;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithSBox;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Memoable;
import com.enterprisedt.bouncycastle.util.Pack;

public class GOST3411Digest
implements ExtendedDigest,
Memoable {
    private final CryptoServicePurpose h;
    private byte[] i = new byte[32];
    private byte[] j = new byte[32];
    private byte[] k = new byte[32];
    private byte[] l = new byte[32];
    private byte[][] m = new byte[4][32];
    private byte[] n = new byte[32];
    private int o;
    private long p;
    private BlockCipher q = new GOST28147Engine();
    private byte[] r;
    private byte[] s = new byte[32];
    byte[] a = new byte[8];
    short[] b = new short[16];
    short[] c = new short[16];
    byte[] d = new byte[32];
    byte[] e = new byte[32];
    byte[] f = new byte[32];
    byte[] g = new byte[32];
    private static final byte[] t = new byte[]{0, -1, 0, -1, 0, -1, 0, -1, -1, 0, -1, 0, -1, 0, -1, 0, 0, -1, -1, 0, -1, 0, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1};

    public GOST3411Digest() {
        this(CryptoServicePurpose.ANY);
    }

    public GOST3411Digest(CryptoServicePurpose purpose) {
        this.h = purpose;
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        this.r = GOST28147Engine.getSBox("D-A");
        this.q.init(true, new ParametersWithSBox(null, this.r));
        this.reset();
    }

    public GOST3411Digest(byte[] sBoxParam) {
        this(sBoxParam, CryptoServicePurpose.ANY);
    }

    public GOST3411Digest(byte[] sBoxParam, CryptoServicePurpose purpose) {
        this.h = purpose;
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        this.r = Arrays.clone(sBoxParam);
        this.q.init(true, new ParametersWithSBox(null, this.r));
        this.reset();
    }

    public GOST3411Digest(GOST3411Digest t2) {
        this.h = t2.h;
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        this.reset(t2);
    }

    @Override
    public String getAlgorithmName() {
        return "GOST3411";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public void update(byte in) {
        this.n[this.o++] = in;
        if (this.o == this.n.length) {
            this.d(this.n);
            this.processBlock(this.n, 0);
            this.o = 0;
        }
        ++this.p;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        while (this.o != 0 && len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
        }
        while (len >= this.n.length) {
            System.arraycopy(in, inOff, this.n, 0, this.n.length);
            this.d(this.n);
            this.processBlock(this.n, 0);
            inOff += this.n.length;
            len -= this.n.length;
            this.p += (long)this.n.length;
        }
        while (len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
        }
    }

    private byte[] a(byte[] byArray) {
        for (int i2 = 0; i2 < 8; ++i2) {
            this.s[4 * i2] = byArray[i2];
            this.s[1 + 4 * i2] = byArray[8 + i2];
            this.s[2 + 4 * i2] = byArray[16 + i2];
            this.s[3 + 4 * i2] = byArray[24 + i2];
        }
        return this.s;
    }

    private byte[] b(byte[] byArray) {
        for (int i2 = 0; i2 < 8; ++i2) {
            this.a[i2] = (byte)(byArray[i2] ^ byArray[i2 + 8]);
        }
        System.arraycopy(byArray, 8, byArray, 0, 24);
        System.arraycopy(this.a, 0, byArray, 24, 8);
        return byArray;
    }

    private void a(byte[] byArray, byte[] byArray2, int n2, byte[] byArray3, int n3) {
        this.q.init(true, new KeyParameter(byArray));
        this.q.processBlock(byArray3, n3, byArray2, n2);
    }

    private void c(byte[] byArray) {
        this.a(byArray, this.b);
        this.c[15] = (short)(this.b[0] ^ this.b[1] ^ this.b[2] ^ this.b[3] ^ this.b[12] ^ this.b[15]);
        System.arraycopy(this.b, 1, this.c, 0, 15);
        this.a(this.c, byArray);
    }

    protected void processBlock(byte[] in, int inOff) {
        int n2;
        System.arraycopy(in, inOff, this.k, 0, 32);
        System.arraycopy(this.i, 0, this.e, 0, 32);
        System.arraycopy(this.k, 0, this.f, 0, 32);
        for (n2 = 0; n2 < 32; ++n2) {
            this.g[n2] = (byte)(this.e[n2] ^ this.f[n2]);
        }
        this.a(this.a(this.g), this.d, 0, this.i, 0);
        for (n2 = 1; n2 < 4; ++n2) {
            int n3;
            byte[] byArray = this.b(this.e);
            for (n3 = 0; n3 < 32; ++n3) {
                this.e[n3] = (byte)(byArray[n3] ^ this.m[n2][n3]);
            }
            this.f = this.b(this.b(this.f));
            for (n3 = 0; n3 < 32; ++n3) {
                this.g[n3] = (byte)(this.e[n3] ^ this.f[n3]);
            }
            this.a(this.a(this.g), this.d, n2 * 8, this.i, n2 * 8);
        }
        for (n2 = 0; n2 < 12; ++n2) {
            this.c(this.d);
        }
        for (n2 = 0; n2 < 32; ++n2) {
            this.d[n2] = (byte)(this.d[n2] ^ this.k[n2]);
        }
        this.c(this.d);
        for (n2 = 0; n2 < 32; ++n2) {
            this.d[n2] = (byte)(this.i[n2] ^ this.d[n2]);
        }
        for (n2 = 0; n2 < 61; ++n2) {
            this.c(this.d);
        }
        System.arraycopy(this.d, 0, this.i, 0, this.i.length);
    }

    private void a() {
        Pack.longToLittleEndian(this.p * 8L, this.j, 0);
        while (this.o != 0) {
            this.update((byte)0);
        }
        this.processBlock(this.j, 0);
        this.processBlock(this.l, 0);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.a();
        System.arraycopy(this.i, 0, out, outOff, this.i.length);
        this.reset();
        return 32;
    }

    @Override
    public void reset() {
        int n2;
        this.p = 0L;
        this.o = 0;
        for (n2 = 0; n2 < this.i.length; ++n2) {
            this.i[n2] = 0;
        }
        for (n2 = 0; n2 < this.j.length; ++n2) {
            this.j[n2] = 0;
        }
        for (n2 = 0; n2 < this.k.length; ++n2) {
            this.k[n2] = 0;
        }
        for (n2 = 0; n2 < this.m[1].length; ++n2) {
            this.m[1][n2] = 0;
        }
        for (n2 = 0; n2 < this.m[3].length; ++n2) {
            this.m[3][n2] = 0;
        }
        for (n2 = 0; n2 < this.l.length; ++n2) {
            this.l[n2] = 0;
        }
        for (n2 = 0; n2 < this.n.length; ++n2) {
            this.n[n2] = 0;
        }
        System.arraycopy(t, 0, this.m[2], 0, t.length);
    }

    private void d(byte[] byArray) {
        int n2 = 0;
        for (int i2 = 0; i2 != this.l.length; ++i2) {
            int n3 = (this.l[i2] & 0xFF) + (byArray[i2] & 0xFF) + n2;
            this.l[i2] = (byte)n3;
            n2 = n3 >>> 8;
        }
    }

    private void a(byte[] byArray, short[] sArray) {
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            sArray[i2] = (short)(byArray[i2 * 2 + 1] << 8 & 0xFF00 | byArray[i2 * 2] & 0xFF);
        }
    }

    private void a(short[] sArray, byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            byArray[i2 * 2 + 1] = (byte)(sArray[i2] >> 8);
            byArray[i2 * 2] = (byte)sArray[i2];
        }
    }

    @Override
    public int getByteLength() {
        return 32;
    }

    @Override
    public Memoable copy() {
        return new GOST3411Digest(this);
    }

    @Override
    public void reset(Memoable other) {
        GOST3411Digest gOST3411Digest = (GOST3411Digest)other;
        this.r = gOST3411Digest.r;
        this.q.init(true, new ParametersWithSBox(null, this.r));
        this.reset();
        System.arraycopy(gOST3411Digest.i, 0, this.i, 0, gOST3411Digest.i.length);
        System.arraycopy(gOST3411Digest.j, 0, this.j, 0, gOST3411Digest.j.length);
        System.arraycopy(gOST3411Digest.k, 0, this.k, 0, gOST3411Digest.k.length);
        System.arraycopy(gOST3411Digest.l, 0, this.l, 0, gOST3411Digest.l.length);
        System.arraycopy(gOST3411Digest.m[1], 0, this.m[1], 0, gOST3411Digest.m[1].length);
        System.arraycopy(gOST3411Digest.m[2], 0, this.m[2], 0, gOST3411Digest.m[2].length);
        System.arraycopy(gOST3411Digest.m[3], 0, this.m[3], 0, gOST3411Digest.m[3].length);
        System.arraycopy(gOST3411Digest.n, 0, this.n, 0, gOST3411Digest.n.length);
        this.o = gOST3411Digest.o;
        this.p = gOST3411Digest.p;
    }

    protected CryptoServiceProperties cryptoServiceProperties() {
        return com.enterprisedt.bouncycastle.crypto.digests.a.a(this, 256, this.h);
    }
}

