/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.digests.HarakaBase;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Bytes;

public class Haraka512Digest
extends HarakaBase {
    private final byte[] b;
    private int c;
    private final CryptoServicePurpose d;

    public Haraka512Digest() {
        this(CryptoServicePurpose.ANY);
    }

    public Haraka512Digest(CryptoServicePurpose purpose) {
        this.d = purpose;
        this.b = new byte[64];
    }

    public Haraka512Digest(Haraka512Digest digest) {
        this.d = digest.d;
        this.b = Arrays.clone(digest.b);
        this.c = digest.c;
    }

    private void a(byte[][] byArray, byte[][] byArray2) {
        System.arraycopy(byArray[0], 12, byArray2[0], 0, 4);
        System.arraycopy(byArray[2], 12, byArray2[0], 4, 4);
        System.arraycopy(byArray[1], 12, byArray2[0], 8, 4);
        System.arraycopy(byArray[3], 12, byArray2[0], 12, 4);
        System.arraycopy(byArray[2], 0, byArray2[1], 0, 4);
        System.arraycopy(byArray[0], 0, byArray2[1], 4, 4);
        System.arraycopy(byArray[3], 0, byArray2[1], 8, 4);
        System.arraycopy(byArray[1], 0, byArray2[1], 12, 4);
        System.arraycopy(byArray[2], 4, byArray2[2], 0, 4);
        System.arraycopy(byArray[0], 4, byArray2[2], 4, 4);
        System.arraycopy(byArray[3], 4, byArray2[2], 8, 4);
        System.arraycopy(byArray[1], 4, byArray2[2], 12, 4);
        System.arraycopy(byArray[0], 8, byArray2[3], 0, 4);
        System.arraycopy(byArray[2], 8, byArray2[3], 4, 4);
        System.arraycopy(byArray[1], 8, byArray2[3], 8, 4);
        System.arraycopy(byArray[3], 8, byArray2[3], 12, 4);
    }

    private int a(byte[] byArray, byte[] byArray2, int n2) {
        byte[][] byArray3 = new byte[4][16];
        byte[][] byArray4 = new byte[4][16];
        System.arraycopy(byArray, 0, byArray3[0], 0, 16);
        System.arraycopy(byArray, 16, byArray3[1], 0, 16);
        System.arraycopy(byArray, 32, byArray3[2], 0, 16);
        System.arraycopy(byArray, 48, byArray3[3], 0, 16);
        byArray3[0] = Haraka512Digest.a(byArray3[0], a[0]);
        byArray3[1] = Haraka512Digest.a(byArray3[1], a[1]);
        byArray3[2] = Haraka512Digest.a(byArray3[2], a[2]);
        byArray3[3] = Haraka512Digest.a(byArray3[3], a[3]);
        byArray3[0] = Haraka512Digest.a(byArray3[0], a[4]);
        byArray3[1] = Haraka512Digest.a(byArray3[1], a[5]);
        byArray3[2] = Haraka512Digest.a(byArray3[2], a[6]);
        byArray3[3] = Haraka512Digest.a(byArray3[3], a[7]);
        this.a(byArray3, byArray4);
        byArray3[0] = Haraka512Digest.a(byArray4[0], a[8]);
        byArray3[1] = Haraka512Digest.a(byArray4[1], a[9]);
        byArray3[2] = Haraka512Digest.a(byArray4[2], a[10]);
        byArray3[3] = Haraka512Digest.a(byArray4[3], a[11]);
        byArray3[0] = Haraka512Digest.a(byArray3[0], a[12]);
        byArray3[1] = Haraka512Digest.a(byArray3[1], a[13]);
        byArray3[2] = Haraka512Digest.a(byArray3[2], a[14]);
        byArray3[3] = Haraka512Digest.a(byArray3[3], a[15]);
        this.a(byArray3, byArray4);
        byArray3[0] = Haraka512Digest.a(byArray4[0], a[16]);
        byArray3[1] = Haraka512Digest.a(byArray4[1], a[17]);
        byArray3[2] = Haraka512Digest.a(byArray4[2], a[18]);
        byArray3[3] = Haraka512Digest.a(byArray4[3], a[19]);
        byArray3[0] = Haraka512Digest.a(byArray3[0], a[20]);
        byArray3[1] = Haraka512Digest.a(byArray3[1], a[21]);
        byArray3[2] = Haraka512Digest.a(byArray3[2], a[22]);
        byArray3[3] = Haraka512Digest.a(byArray3[3], a[23]);
        this.a(byArray3, byArray4);
        byArray3[0] = Haraka512Digest.a(byArray4[0], a[24]);
        byArray3[1] = Haraka512Digest.a(byArray4[1], a[25]);
        byArray3[2] = Haraka512Digest.a(byArray4[2], a[26]);
        byArray3[3] = Haraka512Digest.a(byArray4[3], a[27]);
        byArray3[0] = Haraka512Digest.a(byArray3[0], a[28]);
        byArray3[1] = Haraka512Digest.a(byArray3[1], a[29]);
        byArray3[2] = Haraka512Digest.a(byArray3[2], a[30]);
        byArray3[3] = Haraka512Digest.a(byArray3[3], a[31]);
        this.a(byArray3, byArray4);
        byArray3[0] = Haraka512Digest.a(byArray4[0], a[32]);
        byArray3[1] = Haraka512Digest.a(byArray4[1], a[33]);
        byArray3[2] = Haraka512Digest.a(byArray4[2], a[34]);
        byArray3[3] = Haraka512Digest.a(byArray4[3], a[35]);
        byArray3[0] = Haraka512Digest.a(byArray3[0], a[36]);
        byArray3[1] = Haraka512Digest.a(byArray3[1], a[37]);
        byArray3[2] = Haraka512Digest.a(byArray3[2], a[38]);
        byArray3[3] = Haraka512Digest.a(byArray3[3], a[39]);
        this.a(byArray3, byArray4);
        Bytes.xor(16, byArray4[0], 0, byArray, 0, byArray3[0], 0);
        Bytes.xor(16, byArray4[1], 0, byArray, 16, byArray3[1], 0);
        Bytes.xor(16, byArray4[2], 0, byArray, 32, byArray3[2], 0);
        Bytes.xor(16, byArray4[3], 0, byArray, 48, byArray3[3], 0);
        System.arraycopy(byArray3[0], 8, byArray2, n2, 8);
        System.arraycopy(byArray3[1], 8, byArray2, n2 + 8, 8);
        System.arraycopy(byArray3[2], 0, byArray2, n2 + 16, 8);
        System.arraycopy(byArray3[3], 0, byArray2, n2 + 24, 8);
        return 32;
    }

    @Override
    public String getAlgorithmName() {
        return "Haraka-512";
    }

    @Override
    public void update(byte in) {
        if (this.c > 63) {
            throw new IllegalArgumentException("total input cannot be more than 64 bytes");
        }
        this.b[this.c++] = in;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        if (this.c > 64 - len) {
            throw new IllegalArgumentException("total input cannot be more than 64 bytes");
        }
        System.arraycopy(in, inOff, this.b, this.c, len);
        this.c += len;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        if (this.c != 64) {
            throw new IllegalStateException("input must be exactly 64 bytes");
        }
        if (out.length - outOff < 32) {
            throw new IllegalArgumentException("output too short to receive digest");
        }
        int n2 = this.a(this.b, out, outOff);
        this.reset();
        return n2;
    }

    @Override
    public void reset() {
        this.c = 0;
        Arrays.clear(this.b);
    }
}

