/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Xof;
import com.enterprisedt.bouncycastle.crypto.digests.CSHAKEDigest;
import com.enterprisedt.bouncycastle.crypto.digests.XofUtils;
import com.enterprisedt.bouncycastle.crypto.digests.a;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;

public class ParallelHash
implements Digest,
Xof {
    private static final byte[] a = Strings.toByteArray("ParallelHash");
    private final CSHAKEDigest b;
    private final CSHAKEDigest c;
    private final int d;
    private final int e;
    private final int f;
    private final byte[] g;
    private final byte[] h;
    private boolean i;
    private int j;
    private int k;
    private final CryptoServicePurpose l;

    public ParallelHash(int bitLength, byte[] S, int B) {
        this(bitLength, S, B, bitLength * 2, CryptoServicePurpose.ANY);
    }

    public ParallelHash(int bitLength, byte[] S, int B, int outputSize) {
        this(bitLength, S, B, outputSize, CryptoServicePurpose.ANY);
    }

    public ParallelHash(int bitLength, byte[] S, int B, int outputSize, CryptoServicePurpose purpose) {
        this.b = new CSHAKEDigest(bitLength, a, S);
        this.c = new CSHAKEDigest(bitLength, new byte[0], new byte[0]);
        this.d = bitLength;
        this.f = B;
        this.e = (outputSize + 7) / 8;
        this.g = new byte[B];
        this.h = new byte[bitLength * 2 / 8];
        this.l = purpose;
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.digests.a.a(this, bitLength, purpose));
        this.reset();
    }

    public ParallelHash(ParallelHash source) {
        this.b = new CSHAKEDigest(source.b);
        this.c = new CSHAKEDigest(source.c);
        this.d = source.d;
        this.f = source.f;
        this.e = source.e;
        this.g = Arrays.clone(source.g);
        this.h = Arrays.clone(source.h);
        this.l = source.l;
        this.i = source.i;
        this.j = source.j;
        this.k = source.k;
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.digests.a.a(this, this.d, this.l));
    }

    @Override
    public String getAlgorithmName() {
        return "ParallelHash" + this.b.getAlgorithmName().substring(6);
    }

    @Override
    public int getByteLength() {
        return this.b.getByteLength();
    }

    @Override
    public int getDigestSize() {
        return this.e;
    }

    @Override
    public void update(byte in) throws IllegalStateException {
        this.g[this.k++] = in;
        if (this.k == this.g.length) {
            this.a();
        }
    }

    @Override
    public void update(byte[] in, int inOff, int len) throws DataLengthException, IllegalStateException {
        len = Math.max(0, len);
        int n2 = 0;
        if (this.k != 0) {
            while (n2 < len && this.k != this.g.length) {
                this.g[this.k++] = in[inOff + n2++];
            }
            if (this.k == this.g.length) {
                this.a();
            }
        }
        if (n2 < len) {
            while (len - n2 >= this.f) {
                this.a(in, inOff + n2, this.f);
                n2 += this.f;
            }
        }
        while (n2 < len) {
            this.update(in[inOff + n2++]);
        }
    }

    private void a() {
        this.a(this.g, 0, this.k);
        this.k = 0;
    }

    private void a(byte[] byArray, int n2, int n3) {
        this.c.update(byArray, n2, n3);
        this.c.doFinal(this.h, 0, this.h.length);
        this.b.update(this.h, 0, this.h.length);
        ++this.j;
    }

    private void a(int n2) {
        if (this.k != 0) {
            this.a();
        }
        byte[] byArray = XofUtils.rightEncode(this.j);
        byte[] byArray2 = XofUtils.rightEncode(n2 * 8);
        this.b.update(byArray, 0, byArray.length);
        this.b.update(byArray2, 0, byArray2.length);
        this.i = false;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (this.i) {
            this.a(this.e);
        }
        int n2 = this.b.doFinal(out, outOff, this.getDigestSize());
        this.reset();
        return n2;
    }

    @Override
    public int doFinal(byte[] out, int outOff, int outLen) {
        if (this.i) {
            this.a(this.e);
        }
        int n2 = this.b.doFinal(out, outOff, outLen);
        this.reset();
        return n2;
    }

    @Override
    public int doOutput(byte[] out, int outOff, int outLen) {
        if (this.i) {
            this.a(0);
        }
        return this.b.doOutput(out, outOff, outLen);
    }

    @Override
    public void reset() {
        this.b.reset();
        Arrays.clear(this.g);
        byte[] byArray = XofUtils.leftEncode(this.f);
        this.b.update(byArray, 0, byArray.length);
        this.j = 0;
        this.k = 0;
        this.i = true;
    }
}

