/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.digests.KeccakDigest;

public class SHA3Digest
extends KeccakDigest {
    private static int a(int n2) {
        switch (n2) {
            case 224: 
            case 256: 
            case 384: 
            case 512: {
                return n2;
            }
        }
        throw new IllegalArgumentException("'bitLength' " + n2 + " not supported for SHA-3");
    }

    public SHA3Digest() {
        this(256, CryptoServicePurpose.ANY);
    }

    public SHA3Digest(CryptoServicePurpose purpose) {
        this(256, purpose);
    }

    public SHA3Digest(int bitLength) {
        super(SHA3Digest.a(bitLength), CryptoServicePurpose.ANY);
    }

    public SHA3Digest(int bitLength, CryptoServicePurpose purpose) {
        super(SHA3Digest.a(bitLength), purpose);
    }

    public SHA3Digest(SHA3Digest source) {
        super(source);
    }

    @Override
    public String getAlgorithmName() {
        return "SHA3-" + this.fixedOutputLength;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.absorbBits(2, 2);
        return super.doFinal(out, outOff);
    }

    @Override
    protected int doFinal(byte[] out, int outOff, byte partialByte, int partialBits) {
        if (partialBits < 0 || partialBits > 7) {
            throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
        }
        int n2 = partialByte & (1 << partialBits) - 1 | 2 << partialBits;
        int n3 = partialBits + 2;
        if (n3 >= 8) {
            this.absorb((byte)n2);
            n3 -= 8;
            n2 >>>= 8;
        }
        return super.doFinal(out, outOff, (byte)n2, n3);
    }
}

