/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.CryptoServiceProperties;
import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.digests.LongDigest;
import com.enterprisedt.bouncycastle.crypto.digests.a;
import com.enterprisedt.bouncycastle.util.Memoable;
import com.enterprisedt.bouncycastle.util.MemoableResetException;
import com.enterprisedt.bouncycastle.util.Pack;

public class SHA512tDigest
extends LongDigest {
    private int b;
    private long c;
    private long d;
    private long e;
    private long f;
    private long g;
    private long h;
    private long i;
    private long j;

    public SHA512tDigest(int bitLength) {
        this(bitLength, CryptoServicePurpose.ANY);
    }

    public SHA512tDigest(int bitLength, CryptoServicePurpose purpose) {
        if (bitLength >= 512) {
            throw new IllegalArgumentException("bitLength cannot be >= 512");
        }
        if (bitLength % 8 != 0) {
            throw new IllegalArgumentException("bitLength needs to be a multiple of 8");
        }
        if (bitLength == 384) {
            throw new IllegalArgumentException("bitLength cannot be 384 use SHA384 instead");
        }
        this.b = bitLength / 8;
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        this.a(this.b * 8);
        this.reset();
    }

    public SHA512tDigest(SHA512tDigest t2) {
        super(t2);
        this.b = t2.b;
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        this.reset(t2);
    }

    public SHA512tDigest(byte[] encodedState) {
        this(SHA512tDigest.a(encodedState), CryptoServicePurpose.values()[encodedState[encodedState.length - 1]]);
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        this.restoreState(encodedState);
    }

    private static int a(byte[] byArray) {
        return Pack.bigEndianToInt(byArray, byArray.length - 5);
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-512/" + Integer.toString(this.b * 8);
    }

    @Override
    public int getDigestSize() {
        return this.b;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.finish();
        SHA512tDigest.a(this.H1, out, outOff, this.b);
        SHA512tDigest.a(this.H2, out, outOff + 8, this.b - 8);
        SHA512tDigest.a(this.H3, out, outOff + 16, this.b - 16);
        SHA512tDigest.a(this.H4, out, outOff + 24, this.b - 24);
        SHA512tDigest.a(this.H5, out, outOff + 32, this.b - 32);
        SHA512tDigest.a(this.H6, out, outOff + 40, this.b - 40);
        SHA512tDigest.a(this.H7, out, outOff + 48, this.b - 48);
        SHA512tDigest.a(this.H8, out, outOff + 56, this.b - 56);
        this.reset();
        return this.b;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = this.c;
        this.H2 = this.d;
        this.H3 = this.e;
        this.H4 = this.f;
        this.H5 = this.g;
        this.H6 = this.h;
        this.H7 = this.i;
        this.H8 = this.j;
    }

    private void a(int n2) {
        this.H1 = -3482333909917012819L;
        this.H2 = 2216346199247487646L;
        this.H3 = -7364697282686394994L;
        this.H4 = 65953792586715988L;
        this.H5 = -816286391624063116L;
        this.H6 = 4512832404995164602L;
        this.H7 = -5033199132376557362L;
        this.H8 = -124578254951840548L;
        this.update((byte)83);
        this.update((byte)72);
        this.update((byte)65);
        this.update((byte)45);
        this.update((byte)53);
        this.update((byte)49);
        this.update((byte)50);
        this.update((byte)47);
        if (n2 > 100) {
            this.update((byte)(n2 / 100 + 48));
            this.update((byte)((n2 %= 100) / 10 + 48));
            this.update((byte)((n2 %= 10) + 48));
        } else if (n2 > 10) {
            this.update((byte)(n2 / 10 + 48));
            this.update((byte)((n2 %= 10) + 48));
        } else {
            this.update((byte)(n2 + 48));
        }
        this.finish();
        this.c = this.H1;
        this.d = this.H2;
        this.e = this.H3;
        this.f = this.H4;
        this.g = this.H5;
        this.h = this.H6;
        this.i = this.H7;
        this.j = this.H8;
    }

    private static void a(long l2, byte[] byArray, int n2, int n3) {
        if (n3 > 0) {
            SHA512tDigest.a((int)(l2 >>> 32), byArray, n2, n3);
            if (n3 > 4) {
                SHA512tDigest.a((int)(l2 & 0xFFFFFFFFL), byArray, n2 + 4, n3 - 4);
            }
        }
    }

    private static void a(int n2, byte[] byArray, int n3, int n4) {
        int n5 = Math.min(4, n4);
        while (--n5 >= 0) {
            int n6 = 8 * (3 - n5);
            byArray[n3 + n5] = (byte)(n2 >>> n6);
        }
    }

    @Override
    public Memoable copy() {
        return new SHA512tDigest(this);
    }

    @Override
    public void reset(Memoable other) {
        SHA512tDigest sHA512tDigest = (SHA512tDigest)other;
        if (this.b != sHA512tDigest.b) {
            throw new MemoableResetException("digestLength inappropriate in other");
        }
        super.copyIn(sHA512tDigest);
        this.c = sHA512tDigest.c;
        this.d = sHA512tDigest.d;
        this.e = sHA512tDigest.e;
        this.f = sHA512tDigest.f;
        this.g = sHA512tDigest.g;
        this.h = sHA512tDigest.h;
        this.i = sHA512tDigest.i;
        this.j = sHA512tDigest.j;
    }

    @Override
    public byte[] getEncodedState() {
        int n2 = this.getEncodedStateSize();
        byte[] byArray = new byte[n2 + 4 + 1];
        this.populateState(byArray);
        Pack.intToBigEndian(this.b * 8, byArray, n2);
        byArray[byArray.length - 1] = (byte)this.purpose.ordinal();
        return byArray;
    }

    @Override
    protected CryptoServiceProperties cryptoServiceProperties() {
        return com.enterprisedt.bouncycastle.crypto.digests.a.a(this, this.getDigestSize() * 8, this.purpose);
    }
}

