/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;
import com.enterprisedt.bouncycastle.crypto.digests.SkeinEngine;
import com.enterprisedt.bouncycastle.crypto.digests.a;
import com.enterprisedt.bouncycastle.crypto.params.SkeinParameters;
import com.enterprisedt.bouncycastle.util.Memoable;

public class SkeinDigest
implements ExtendedDigest,
Memoable {
    public static final int SKEIN_256 = 256;
    public static final int SKEIN_512 = 512;
    public static final int SKEIN_1024 = 1024;
    private final CryptoServicePurpose a;
    private SkeinEngine b;

    public SkeinDigest(int stateSizeBits, int digestSizeBits) {
        this(stateSizeBits, digestSizeBits, CryptoServicePurpose.ANY);
    }

    public SkeinDigest(int stateSizeBits, int digestSizeBits, CryptoServicePurpose purpose) {
        this.b = new SkeinEngine(stateSizeBits, digestSizeBits);
        this.a = purpose;
        this.init(null);
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.digests.a.a(this, this.getDigestSize() * 4, purpose));
    }

    public SkeinDigest(SkeinDigest digest) {
        this.b = new SkeinEngine(digest.b);
        this.a = digest.a;
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.digests.a.a(this, digest.getDigestSize() * 4, this.a));
    }

    @Override
    public void reset(Memoable other) {
        SkeinDigest skeinDigest = (SkeinDigest)other;
        this.b.reset(skeinDigest.b);
    }

    @Override
    public Memoable copy() {
        return new SkeinDigest(this);
    }

    @Override
    public String getAlgorithmName() {
        return "Skein-" + this.b.getBlockSize() * 8 + "-" + this.b.getOutputSize() * 8;
    }

    @Override
    public int getDigestSize() {
        return this.b.getOutputSize();
    }

    @Override
    public int getByteLength() {
        return this.b.getBlockSize();
    }

    public void init(SkeinParameters params) {
        this.b.init(params);
    }

    @Override
    public void reset() {
        this.b.reset();
    }

    @Override
    public void update(byte in) {
        this.b.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.b.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        return this.b.doFinal(out, outOff);
    }
}

