/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.ByteArrayOutputStream;

public class XoodyakDigest
implements Digest {
    private byte[] a;
    private int b;
    private a c;
    private int d;
    private final int e = 48;
    private final int f = 16;
    private final int g = 1;
    private final int h = 2;
    private final int i = 12;
    private final int j = 3;
    private final int k = 4;
    private final int l = 12;
    private final int m = 16;
    private final int[] n = new int[]{88, 56, 960, 208, 288, 20, 96, 44, 896, 240, 416, 18};
    private final ByteArrayOutputStream o = new ByteArrayOutputStream();

    public XoodyakDigest() {
        this.a = new byte[48];
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return "Xoodyak Hash";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public void update(byte input) {
        this.o.write(input);
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.o.write(input, inOff, len);
    }

    @Override
    public int doFinal(byte[] output, int outOff) {
        int n2;
        if (32 + outOff > output.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        byte[] byArray = this.o.toByteArray();
        int n3 = 0;
        int n4 = this.o.size();
        int n5 = 3;
        do {
            if (this.b != 2) {
                this.b(null, 0, 0, 0);
            }
            n2 = Math.min(n4, this.d);
            this.a(byArray, n3, n2, n5);
            n5 = 0;
            n3 += n2;
        } while ((n4 -= n2) != 0);
        this.b(output, outOff, 16, 64);
        this.a(null, 0, 0, 0);
        this.b(output, outOff + 16, 16, 0);
        return 32;
    }

    @Override
    public void reset() {
        Arrays.fill(this.a, (byte)0);
        this.b = 2;
        this.c = com.enterprisedt.bouncycastle.crypto.digests.XoodyakDigest$a.a;
        this.d = 16;
        this.o.reset();
    }

    private void b(byte[] byArray, int n2, int n3, int n4) {
        if (this.c != com.enterprisedt.bouncycastle.crypto.digests.XoodyakDigest$a.a) {
            this.a[47] = (byte)(this.a[47] ^ n4);
        }
        int[] nArray = new int[12];
        Pack.littleEndianToInt(this.a, 0, nArray, 0, nArray.length);
        int[] nArray2 = new int[12];
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        for (int i2 = 0; i2 < 12; ++i2) {
            int n5;
            int n6;
            for (n6 = 0; n6 < 4; ++n6) {
                nArray3[n6] = nArray[this.a(n6, 0)] ^ nArray[this.a(n6, 1)] ^ nArray[this.a(n6, 2)];
            }
            for (n6 = 0; n6 < 4; ++n6) {
                n5 = nArray3[n6 + 3 & 3];
                nArray4[n6] = this.b(n5, 5) ^ this.b(n5, 14);
            }
            for (n6 = 0; n6 < 4; ++n6) {
                for (n5 = 0; n5 < 3; ++n5) {
                    int n7 = this.a(n6, n5);
                    nArray[n7] = nArray[n7] ^ nArray4[n6];
                }
            }
            for (n6 = 0; n6 < 4; ++n6) {
                nArray2[this.a((int)n6, (int)0)] = nArray[this.a(n6, 0)];
                nArray2[this.a((int)n6, (int)1)] = nArray[this.a(n6 + 3, 1)];
                nArray2[this.a((int)n6, (int)2)] = this.b(nArray[this.a(n6, 2)], 11);
            }
            nArray2[0] = nArray2[0] ^ this.n[i2];
            for (n6 = 0; n6 < 4; ++n6) {
                for (n5 = 0; n5 < 3; ++n5) {
                    nArray[this.a((int)n6, (int)n5)] = nArray2[this.a(n6, n5)] ^ ~nArray2[this.a(n6, n5 + 1)] & nArray2[this.a(n6, n5 + 2)];
                }
            }
            for (n6 = 0; n6 < 4; ++n6) {
                nArray2[this.a((int)n6, (int)0)] = nArray[this.a(n6, 0)];
                nArray2[this.a((int)n6, (int)1)] = this.b(nArray[this.a(n6, 1)], 1);
                nArray2[this.a((int)n6, (int)2)] = this.b(nArray[this.a(n6 + 2, 2)], 8);
            }
            System.arraycopy(nArray2, 0, nArray, 0, 12);
        }
        Pack.intToLittleEndian(nArray, 0, nArray.length, this.a, 0);
        this.b = 2;
        if (byArray != null) {
            System.arraycopy(this.a, 0, byArray, n2, n3);
        }
    }

    void a(byte[] byArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n3) {
            int n6 = n5++;
            this.a[n6] = (byte)(this.a[n6] ^ byArray[n2++]);
        }
        int n7 = n3;
        this.a[n7] = (byte)(this.a[n7] ^ 1);
        this.a[47] = (byte)(this.a[47] ^ (this.c == com.enterprisedt.bouncycastle.crypto.digests.XoodyakDigest$a.a ? n4 & 1 : n4));
        this.b = 1;
    }

    private int a(int n2, int n3) {
        return n3 % 3 * 4 + n2 % 4;
    }

    private int b(int n2, int n3) {
        return n2 << (n3 & 0x1F) ^ n2 >>> (32 - n3 & 0x1F);
    }

    static enum a {
        a,
        b;

    }
}

