/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.encodings;

import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Properties;
import java.security.SecureRandom;

public class PKCS1Encoding
implements AsymmetricBlockCipher {
    public static final String STRICT_LENGTH_ENABLED_PROPERTY = "com.enterprisedt.bouncycastle.pkcs1.strict";
    public static final String NOT_STRICT_LENGTH_ENABLED_PROPERTY = "com.enterprisedt.bouncycastle.pkcs1.not_strict";
    private SecureRandom a;
    private AsymmetricBlockCipher b;
    private boolean c;
    private boolean d;
    private boolean e;
    private int f = -1;
    private byte[] g = null;
    private byte[] h;

    public PKCS1Encoding(AsymmetricBlockCipher cipher) {
        this.b = cipher;
        this.e = this.a();
    }

    public PKCS1Encoding(AsymmetricBlockCipher cipher, int pLen) {
        this.b = cipher;
        this.e = this.a();
        this.f = pLen;
    }

    public PKCS1Encoding(AsymmetricBlockCipher cipher, byte[] fallback) {
        this.b = cipher;
        this.e = this.a();
        this.g = fallback;
        this.f = fallback.length;
    }

    private boolean a() {
        if (Properties.isOverrideSetTo(NOT_STRICT_LENGTH_ENABLED_PROPERTY, true)) {
            return false;
        }
        return !Properties.isOverrideSetTo(STRICT_LENGTH_ENABLED_PROPERTY, false);
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.b;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
            this.a = parametersWithRandom.getRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            asymmetricKeyParameter = (AsymmetricKeyParameter)param;
            if (!asymmetricKeyParameter.isPrivate() && forEncryption) {
                this.a = CryptoServicesRegistrar.getSecureRandom();
            }
        }
        this.b.init(forEncryption, param);
        this.d = asymmetricKeyParameter.isPrivate();
        this.c = forEncryption;
        this.h = new byte[this.b.getOutputBlockSize()];
        if (this.f > 0 && this.g == null && this.a == null) {
            throw new IllegalArgumentException("encoder requires random");
        }
    }

    @Override
    public int getInputBlockSize() {
        int n2 = this.b.getInputBlockSize();
        if (this.c) {
            return n2 - 10;
        }
        return n2;
    }

    @Override
    public int getOutputBlockSize() {
        int n2 = this.b.getOutputBlockSize();
        if (this.c) {
            return n2;
        }
        return n2 - 10;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.c) {
            return this.a(in, inOff, inLen);
        }
        return this.c(in, inOff, inLen);
    }

    private byte[] a(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (n3 > this.getInputBlockSize()) {
            throw new IllegalArgumentException("input data too large");
        }
        byte[] byArray2 = new byte[this.b.getInputBlockSize()];
        if (this.d) {
            byArray2[0] = 1;
            for (int i2 = 1; i2 != byArray2.length - n3 - 1; ++i2) {
                byArray2[i2] = -1;
            }
        } else {
            this.a.nextBytes(byArray2);
            byArray2[0] = 2;
            for (int i3 = 1; i3 != byArray2.length - n3 - 1; ++i3) {
                while (byArray2[i3] == 0) {
                    byArray2[i3] = (byte)this.a.nextInt();
                }
            }
        }
        byArray2[byArray2.length - n3 - 1] = 0;
        System.arraycopy(byArray, n2, byArray2, byArray2.length - n3, n3);
        return this.b.processBlock(byArray2, 0, byArray2.length);
    }

    private static int a(byte[] byArray) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = -(byArray[0] & 0xFF ^ 1);
        for (n2 = 1; n2 < byArray.length; ++n2) {
            int n6 = byArray[n2] & 0xFF;
            int n7 = (n6 ^ 0) - 1 >> 31;
            int n8 = (n6 ^ 0xFF) - 1 >> 31;
            n4 ^= n2 & ~n3 & n7;
            n5 |= ~((n3 |= n7) | n8);
        }
        n2 = byArray.length - 1 - n4;
        return n2 | (n5 |= n4 - 9) >> 31;
    }

    private static int b(byte[] byArray) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = -(byArray[0] & 0xFF ^ 2);
        for (n2 = 1; n2 < byArray.length; ++n2) {
            int n6 = byArray[n2] & 0xFF;
            int n7 = (n6 ^ 0) - 1 >> 31;
            n4 ^= n2 & ~n3 & n7;
            n3 |= n7;
        }
        n2 = byArray.length - 1 - n4;
        return n2 | (n5 |= n4 - 9) >> 31;
    }

    private static int a(byte[] byArray, int n2) {
        int n3 = -(byArray[0] & 0xFF ^ 2);
        int n4 = byArray.length - 1 - n2;
        n3 |= n4 - 9;
        for (int i2 = 1; i2 < n4; ++i2) {
            n3 |= (byArray[i2] & 0xFF) - 1;
        }
        return (n3 |= -(byArray[n4] & 0xFF)) >> 31;
    }

    private byte[] b(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte[] byArray2;
        if (!this.d) {
            throw new InvalidCipherTextException("sorry, this method is only for decryption, not for signing");
        }
        int n4 = this.f;
        byte[] byArray3 = this.g;
        if (this.g == null) {
            byArray3 = new byte[n4];
            this.a.nextBytes(byArray3);
        }
        int n5 = 0;
        int n6 = this.b.getOutputBlockSize();
        byte[] byArray4 = byArray2 = this.b.processBlock(byArray, n2, n3);
        if (byArray2.length != n6 && (this.e || byArray2.length < n6)) {
            byArray4 = this.h;
        }
        n5 |= PKCS1Encoding.a(byArray4, n4);
        int n7 = byArray4.length - n4;
        byte[] byArray5 = new byte[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray5[i2] = (byte)(byArray4[n7 + i2] & ~n5 | byArray3[i2] & n5);
        }
        Arrays.fill(byArray2, (byte)0);
        Arrays.fill(this.h, 0, Math.max(0, this.h.length - byArray2.length), (byte)0);
        return byArray5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] c(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (this.d && this.f != -1) {
            return this.b(byArray, n2, n3);
        }
        int n4 = this.b.getOutputBlockSize();
        byte[] byArray2 = this.b.processBlock(byArray, n2, n3);
        boolean bl = this.e & byArray2.length != n4;
        byte[] byArray3 = byArray2;
        if (byArray2.length < n4) {
            byArray3 = this.h;
        }
        int n5 = this.d ? PKCS1Encoding.b(byArray3) : PKCS1Encoding.a(byArray3);
        try {
            if (n5 < 0) {
                throw new InvalidCipherTextException("block incorrect");
            }
            if (bl) {
                throw new InvalidCipherTextException("block incorrect size");
            }
            byte[] byArray4 = new byte[n5];
            System.arraycopy(byArray3, byArray3.length - n5, byArray4, 0, n5);
            byte[] byArray5 = byArray4;
            return byArray5;
        }
        finally {
            Arrays.fill(byArray2, (byte)0);
            Arrays.fill(this.h, 0, Math.max(0, this.h.length - byArray2.length), (byte)0);
        }
    }
}

