/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.engines.c;
import com.enterprisedt.bouncycastle.crypto.modes.AEADCipher;
import com.enterprisedt.bouncycastle.crypto.params.AEADParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Longs;
import com.enterprisedt.bouncycastle.util.Pack;

public class AsconEngine
implements AEADCipher {
    private final AsconParameters a;
    private a b = com.enterprisedt.bouncycastle.crypto.engines.AsconEngine$a.a;
    private byte[] c;
    private byte[] d;
    private final String e;
    private final int f;
    private final int g;
    private final int h;
    private final int i;
    private long j;
    private long k;
    private long l;
    private long m;
    private long n;
    private final long o;
    private long p;
    private long q;
    private long r;
    private long s;
    private long t;
    private final int u;
    private final byte[] v;
    private int w = 0;

    public AsconEngine(AsconParameters asconParameters) {
        this.a = asconParameters;
        switch (asconParameters) {
            case ascon80pq: {
                this.f = 20;
                this.g = 16;
                this.h = 8;
                this.o = -6899501409222262784L;
                this.e = "Ascon-80pq AEAD";
                break;
            }
            case ascon128a: {
                this.f = 16;
                this.g = 16;
                this.h = 16;
                this.o = -9187330011336540160L;
                this.e = "Ascon-128a AEAD";
                break;
            }
            case ascon128: {
                this.f = 16;
                this.g = 16;
                this.h = 8;
                this.o = -9205344418435956736L;
                this.e = "Ascon-128 AEAD";
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid parameter setting for ASCON AEAD");
            }
        }
        this.i = this.h == 8 ? 6 : 8;
        this.u = this.h + this.g;
        this.v = new byte[this.u];
    }

    private long a(int n2) {
        return 128L << 56 - (n2 << 3);
    }

    private void a(long l2) {
        long l3 = this.p ^ this.q ^ this.r ^ this.s ^ l2 ^ this.q & (this.p ^ this.r ^ this.t ^ l2);
        long l4 = this.p ^ this.r ^ this.s ^ this.t ^ l2 ^ (this.q ^ this.r ^ l2) & (this.q ^ this.s);
        long l5 = this.q ^ this.r ^ this.t ^ l2 ^ this.s & this.t;
        long l6 = this.p ^ this.q ^ this.r ^ l2 ^ (this.p ^ 0xFFFFFFFFFFFFFFFFL) & (this.s ^ this.t);
        long l7 = this.q ^ this.s ^ this.t ^ (this.p ^ this.t) & this.q;
        this.p = l3 ^ Longs.rotateRight(l3, 19) ^ Longs.rotateRight(l3, 28);
        this.q = l4 ^ Longs.rotateRight(l4, 39) ^ Longs.rotateRight(l4, 61);
        this.r = l5 ^ Longs.rotateRight(l5, 1) ^ Longs.rotateRight(l5, 6) ^ 0xFFFFFFFFFFFFFFFFL;
        this.s = l6 ^ Longs.rotateRight(l6, 10) ^ Longs.rotateRight(l6, 17);
        this.t = l7 ^ Longs.rotateRight(l7, 7) ^ Longs.rotateRight(l7, 41);
    }

    private void b(int n2) {
        if (n2 >= 8) {
            if (n2 == 12) {
                this.a(240L);
                this.a(225L);
                this.a(210L);
                this.a(195L);
            }
            this.a(180L);
            this.a(165L);
        }
        this.a(150L);
        this.a(135L);
        this.a(120L);
        this.a(105L);
        this.a(90L);
        this.a(75L);
    }

    private void a() {
        this.p = this.o;
        if (this.f == 20) {
            this.p ^= this.j;
        }
        this.q = this.k;
        this.r = this.l;
        this.s = this.m;
        this.t = this.n;
        this.b(12);
        if (this.f == 20) {
            this.r ^= this.j;
        }
        this.s ^= this.k;
        this.t ^= this.l;
    }

    private void b() {
        switch (this.b) {
            case f: {
                this.b = com.enterprisedt.bouncycastle.crypto.engines.AsconEngine$a.g;
                break;
            }
            case b: {
                this.b = com.enterprisedt.bouncycastle.crypto.engines.AsconEngine$a.c;
                break;
            }
            case g: 
            case c: {
                break;
            }
            case e: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
            default: {
                throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
            }
        }
    }

    private boolean c() {
        switch (this.b) {
            case f: 
            case g: {
                this.a(com.enterprisedt.bouncycastle.crypto.engines.AsconEngine$a.h);
                return false;
            }
            case b: 
            case c: {
                this.a(com.enterprisedt.bouncycastle.crypto.engines.AsconEngine$a.d);
                return true;
            }
            case h: {
                return false;
            }
            case d: {
                return true;
            }
            case e: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
        }
        throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
    }

    private void a(byte[] byArray, int n2) {
        this.p ^= Pack.bigEndianToLong(byArray, n2);
        if (this.h == 16) {
            this.q ^= Pack.bigEndianToLong(byArray, 8 + n2);
        }
        this.b(this.i);
    }

    private void a(a a2) {
        switch (this.b) {
            case g: 
            case c: {
                this.v[this.w] = -128;
                if (this.w >= 8) {
                    this.p ^= Pack.bigEndianToLong(this.v, 0);
                    this.q ^= Pack.bigEndianToLong(this.v, 8) & -1L << 56 - (this.w - 8 << 3);
                } else {
                    this.p ^= Pack.bigEndianToLong(this.v, 0) & -1L << 56 - (this.w << 3);
                }
                this.b(this.i);
                break;
            }
        }
        this.t ^= 1L;
        this.w = 0;
        this.b = a2;
    }

    private void a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (n3 + this.h > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        long l2 = Pack.bigEndianToLong(byArray, n2);
        Pack.longToBigEndian(this.p ^ l2, byArray2, n3);
        this.p = l2;
        if (this.h == 16) {
            long l3 = Pack.bigEndianToLong(byArray, n2 + 8);
            Pack.longToBigEndian(this.q ^ l3, byArray2, n3 + 8);
            this.q = l3;
        }
        this.b(this.i);
    }

    private void b(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (n3 + this.h > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        this.p ^= Pack.bigEndianToLong(byArray, n2);
        Pack.longToBigEndian(this.p, byArray2, n3);
        if (this.h == 16) {
            this.q ^= Pack.bigEndianToLong(byArray, n2 + 8);
            Pack.longToBigEndian(this.q, byArray2, n3 + 8);
        }
        this.b(this.i);
    }

    private void a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (n3 >= 8) {
            long l2 = Pack.bigEndianToLong(byArray, n2);
            this.p ^= l2;
            Pack.longToBigEndian(this.p, byArray2, n4);
            this.p = l2;
            n2 += 8;
            n4 += 8;
            this.q ^= this.a(n3 -= 8);
            if (n3 != 0) {
                long l3 = Pack.littleEndianToLong_High(byArray, n2, n3);
                this.q ^= l3;
                Pack.longToLittleEndian_High(this.q, byArray2, n4, n3);
                this.q &= -1L >>> (n3 << 3);
                this.q ^= l3;
            }
        } else {
            this.p ^= this.a(n3);
            if (n3 != 0) {
                long l4 = Pack.littleEndianToLong_High(byArray, n2, n3);
                this.p ^= l4;
                Pack.longToLittleEndian_High(this.p, byArray2, n4, n3);
                this.p &= -1L >>> (n3 << 3);
                this.p ^= l4;
            }
        }
        this.b(com.enterprisedt.bouncycastle.crypto.engines.AsconEngine$a.i);
    }

    private void b(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (n3 >= 8) {
            this.p ^= Pack.bigEndianToLong(byArray, n2);
            Pack.longToBigEndian(this.p, byArray2, n4);
            n2 += 8;
            n4 += 8;
            this.q ^= this.a(n3 -= 8);
            if (n3 != 0) {
                this.q ^= Pack.littleEndianToLong_High(byArray, n2, n3);
                Pack.longToLittleEndian_High(this.q, byArray2, n4, n3);
            }
        } else {
            this.p ^= this.a(n3);
            if (n3 != 0) {
                this.p ^= Pack.littleEndianToLong_High(byArray, n2, n3);
                Pack.longToLittleEndian_High(this.p, byArray2, n4, n3);
            }
        }
        this.b(com.enterprisedt.bouncycastle.crypto.engines.AsconEngine$a.e);
    }

    private void b(a a2) {
        switch (this.a) {
            case ascon128: {
                this.q ^= this.k;
                this.r ^= this.l;
                break;
            }
            case ascon128a: {
                this.r ^= this.k;
                this.s ^= this.l;
                break;
            }
            case ascon80pq: {
                this.q ^= this.j << 32 | this.k >> 32;
                this.r ^= this.k << 32 | this.l >> 32;
                this.s ^= this.l << 32;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.b(12);
        this.s ^= this.k;
        this.t ^= this.l;
        this.b = a2;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        byte[] byArray;
        KeyParameter keyParameter;
        Object object;
        if (params instanceof AEADParameters) {
            object = (AEADParameters)params;
            keyParameter = ((AEADParameters)object).getKey();
            byArray = ((AEADParameters)object).getNonce();
            this.d = ((AEADParameters)object).getAssociatedText();
            int n2 = ((AEADParameters)object).getMacSize();
            if (n2 != this.g * 8) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + n2);
            }
        } else if (params instanceof ParametersWithIV) {
            object = (ParametersWithIV)params;
            keyParameter = (KeyParameter)((ParametersWithIV)object).getParameters();
            byArray = ((ParametersWithIV)object).getIV();
            this.d = null;
        } else {
            throw new IllegalArgumentException("invalid parameters passed to Ascon");
        }
        if (keyParameter == null) {
            throw new IllegalArgumentException("Ascon Init parameters must include a key");
        }
        if (byArray == null || byArray.length != this.g) {
            throw new IllegalArgumentException((Object)((Object)this.a) + " requires exactly " + this.g + " bytes of IV");
        }
        object = keyParameter.getKey();
        if (((Object)object).length != this.f) {
            throw new IllegalArgumentException((Object)((Object)this.a) + " key must be " + this.f + " bytes long");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, com.enterprisedt.bouncycastle.crypto.engines.c.a(forEncryption)));
        this.m = Pack.bigEndianToLong(byArray, 0);
        this.n = Pack.bigEndianToLong(byArray, 8);
        if (this.f == 16) {
            this.k = Pack.bigEndianToLong((byte[])object, 0);
            this.l = Pack.bigEndianToLong((byte[])object, 8);
        } else if (this.f == 20) {
            this.j = Pack.bigEndianToInt((byte[])object, 0);
            this.k = Pack.bigEndianToLong((byte[])object, 4);
            this.l = Pack.bigEndianToLong((byte[])object, 12);
        } else {
            throw new IllegalStateException();
        }
        this.b = forEncryption ? com.enterprisedt.bouncycastle.crypto.engines.AsconEngine$a.b : com.enterprisedt.bouncycastle.crypto.engines.AsconEngine$a.f;
        this.a(true);
    }

    @Override
    public String getAlgorithmName() {
        return this.e;
    }

    public String getAlgorithmVersion() {
        return "v1.2";
    }

    @Override
    public void processAADByte(byte in) {
        this.b();
        this.v[this.w] = in;
        if (++this.w == this.h) {
            this.a(this.v, 0);
        }
    }

    @Override
    public void processAADBytes(byte[] inBytes, int inOff, int len) {
        if (inOff + len > inBytes.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (len <= 0) {
            return;
        }
        this.b();
        if (this.w > 0) {
            int n2 = this.h - this.w;
            if (len < n2) {
                System.arraycopy(inBytes, inOff, this.v, this.w, len);
                this.w += len;
                return;
            }
            System.arraycopy(inBytes, inOff, this.v, this.w, n2);
            inOff += n2;
            len -= n2;
            this.a(this.v, 0);
        }
        while (len >= this.h) {
            this.a(inBytes, inOff);
            inOff += this.h;
            len -= this.h;
        }
        System.arraycopy(inBytes, inOff, this.v, 0, len);
        this.w = len;
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{in}, 0, 1, out, outOff);
    }

    @Override
    public int processBytes(byte[] inBytes, int inOff, int len, byte[] outBytes, int outOff) throws DataLengthException {
        if (inOff + len > inBytes.length) {
            throw new DataLengthException("input buffer too short");
        }
        boolean bl = this.c();
        int n2 = 0;
        if (bl) {
            if (this.w > 0) {
                int n3 = this.h - this.w;
                if (len < n3) {
                    System.arraycopy(inBytes, inOff, this.v, this.w, len);
                    this.w += len;
                    return 0;
                }
                System.arraycopy(inBytes, inOff, this.v, this.w, n3);
                inOff += n3;
                len -= n3;
                this.b(this.v, 0, outBytes, outOff);
                n2 = this.h;
            }
            while (len >= this.h) {
                this.b(inBytes, inOff, outBytes, outOff + n2);
                inOff += this.h;
                len -= this.h;
                n2 += this.h;
            }
        } else {
            int n4 = this.u - this.w;
            if (len < n4) {
                System.arraycopy(inBytes, inOff, this.v, this.w, len);
                this.w += len;
                return 0;
            }
            while (this.w >= this.h) {
                this.a(this.v, 0, outBytes, outOff + n2);
                this.w -= this.h;
                System.arraycopy(this.v, this.h, this.v, 0, this.w);
                n2 += this.h;
                if (len >= (n4 += this.h)) continue;
                System.arraycopy(inBytes, inOff, this.v, this.w, len);
                this.w += len;
                return n2;
            }
            n4 = this.h - this.w;
            System.arraycopy(inBytes, inOff, this.v, this.w, n4);
            inOff += n4;
            len -= n4;
            this.a(this.v, 0, outBytes, outOff + n2);
            n2 += this.h;
            while (len >= this.u) {
                this.a(inBytes, inOff, outBytes, outOff + n2);
                inOff += this.h;
                len -= this.h;
                n2 += this.h;
            }
        }
        System.arraycopy(inBytes, inOff, this.v, 0, len);
        this.w = len;
        return n2;
    }

    @Override
    public int doFinal(byte[] outBytes, int outOff) throws IllegalStateException, InvalidCipherTextException, DataLengthException {
        int n2;
        boolean bl = this.c();
        if (bl) {
            n2 = this.w + this.g;
            if (outOff + n2 > outBytes.length) {
                throw new OutputLengthException("output buffer too short");
            }
            this.b(this.v, 0, this.w, outBytes, outOff);
            this.c = new byte[this.g];
            Pack.longToBigEndian(this.s, this.c, 0);
            Pack.longToBigEndian(this.t, this.c, 8);
            System.arraycopy(this.c, 0, outBytes, outOff + this.w, this.g);
            this.a(false);
        } else {
            if (this.w < this.g) {
                throw new InvalidCipherTextException("data too short");
            }
            this.w -= this.g;
            n2 = this.w;
            if (outOff + n2 > outBytes.length) {
                throw new OutputLengthException("output buffer too short");
            }
            this.a(this.v, 0, this.w, outBytes, outOff);
            this.s ^= Pack.bigEndianToLong(this.v, this.w);
            this.t ^= Pack.bigEndianToLong(this.v, this.w + 8);
            if ((this.s | this.t) != 0L) {
                throw new InvalidCipherTextException("mac check in " + this.getAlgorithmName() + " failed");
            }
            this.a(true);
        }
        return n2;
    }

    @Override
    public byte[] getMac() {
        return this.c;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        int n2 = Math.max(0, len);
        switch (this.b) {
            case f: 
            case g: {
                n2 = Math.max(0, n2 - this.g);
                break;
            }
            case h: 
            case i: {
                n2 = Math.max(0, n2 + this.w - this.g);
                break;
            }
            case e: 
            case d: {
                n2 += this.w;
                break;
            }
        }
        return n2 - n2 % this.h;
    }

    @Override
    public int getOutputSize(int len) {
        int n2 = Math.max(0, len);
        switch (this.b) {
            case f: 
            case g: {
                return Math.max(0, n2 - this.g);
            }
            case h: 
            case i: {
                return Math.max(0, n2 + this.w - this.g);
            }
            case e: 
            case d: {
                return n2 + this.w + this.g;
            }
        }
        return n2 + this.g;
    }

    @Override
    public void reset() {
        this.a(true);
    }

    private void a(boolean bl) {
        if (bl) {
            this.c = null;
        }
        Arrays.clear(this.v);
        this.w = 0;
        switch (this.b) {
            case f: 
            case b: {
                break;
            }
            case g: 
            case h: 
            case i: {
                this.b = com.enterprisedt.bouncycastle.crypto.engines.AsconEngine$a.f;
                break;
            }
            case c: 
            case e: 
            case d: {
                this.b = com.enterprisedt.bouncycastle.crypto.engines.AsconEngine$a.e;
                return;
            }
            default: {
                throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
            }
        }
        this.a();
        if (this.d != null) {
            this.processAADBytes(this.d, 0, this.d.length);
        }
    }

    public int getKeyBytesSize() {
        return this.f;
    }

    public int getIVBytesSize() {
        return this.g;
    }

    private static enum a {
        a,
        b,
        c,
        d,
        e,
        f,
        g,
        h,
        i;

    }

    public static enum AsconParameters {
        ascon80pq,
        ascon128a,
        ascon128;

    }
}

