/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.engines.CAST5Engine;

public final class CAST6Engine
extends CAST5Engine {
    protected static final int ROUNDS = 12;
    protected static final int BLOCK_SIZE = 16;
    protected int[] _Kr = new int[48];
    protected int[] _Km = new int[48];
    protected int[] _Tr = new int[192];
    protected int[] _Tm = new int[192];
    private int[] a = new int[8];

    @Override
    public String getAlgorithmName() {
        return "CAST6";
    }

    @Override
    public void reset() {
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    protected void setKey(byte[] key) {
        int n2;
        int n3;
        int n4 = 1518500249;
        int n5 = 1859775393;
        int n6 = 19;
        int n7 = 17;
        for (int i2 = 0; i2 < 24; ++i2) {
            for (n3 = 0; n3 < 8; ++n3) {
                this._Tm[i2 * 8 + n3] = n4;
                n4 += n5;
                this._Tr[i2 * 8 + n3] = n6;
                n6 = n6 + n7 & 0x1F;
            }
        }
        byte[] byArray = new byte[64];
        n3 = key.length;
        System.arraycopy(key, 0, byArray, 0, n3);
        for (n2 = 0; n2 < 8; ++n2) {
            this.a[n2] = this.BytesTo32bits(byArray, n2 * 4);
        }
        for (n2 = 0; n2 < 12; ++n2) {
            int n8 = n2 * 2 * 8;
            this.a[6] = this.a[6] ^ this.F1(this.a[7], this._Tm[n8], this._Tr[n8]);
            this.a[5] = this.a[5] ^ this.F2(this.a[6], this._Tm[n8 + 1], this._Tr[n8 + 1]);
            this.a[4] = this.a[4] ^ this.F3(this.a[5], this._Tm[n8 + 2], this._Tr[n8 + 2]);
            this.a[3] = this.a[3] ^ this.F1(this.a[4], this._Tm[n8 + 3], this._Tr[n8 + 3]);
            this.a[2] = this.a[2] ^ this.F2(this.a[3], this._Tm[n8 + 4], this._Tr[n8 + 4]);
            this.a[1] = this.a[1] ^ this.F3(this.a[2], this._Tm[n8 + 5], this._Tr[n8 + 5]);
            this.a[0] = this.a[0] ^ this.F1(this.a[1], this._Tm[n8 + 6], this._Tr[n8 + 6]);
            this.a[7] = this.a[7] ^ this.F2(this.a[0], this._Tm[n8 + 7], this._Tr[n8 + 7]);
            n8 = (n2 * 2 + 1) * 8;
            this.a[6] = this.a[6] ^ this.F1(this.a[7], this._Tm[n8], this._Tr[n8]);
            this.a[5] = this.a[5] ^ this.F2(this.a[6], this._Tm[n8 + 1], this._Tr[n8 + 1]);
            this.a[4] = this.a[4] ^ this.F3(this.a[5], this._Tm[n8 + 2], this._Tr[n8 + 2]);
            this.a[3] = this.a[3] ^ this.F1(this.a[4], this._Tm[n8 + 3], this._Tr[n8 + 3]);
            this.a[2] = this.a[2] ^ this.F2(this.a[3], this._Tm[n8 + 4], this._Tr[n8 + 4]);
            this.a[1] = this.a[1] ^ this.F3(this.a[2], this._Tm[n8 + 5], this._Tr[n8 + 5]);
            this.a[0] = this.a[0] ^ this.F1(this.a[1], this._Tm[n8 + 6], this._Tr[n8 + 6]);
            this.a[7] = this.a[7] ^ this.F2(this.a[0], this._Tm[n8 + 7], this._Tr[n8 + 7]);
            this._Kr[n2 * 4] = this.a[0] & 0x1F;
            this._Kr[n2 * 4 + 1] = this.a[2] & 0x1F;
            this._Kr[n2 * 4 + 2] = this.a[4] & 0x1F;
            this._Kr[n2 * 4 + 3] = this.a[6] & 0x1F;
            this._Km[n2 * 4] = this.a[7];
            this._Km[n2 * 4 + 1] = this.a[5];
            this._Km[n2 * 4 + 2] = this.a[3];
            this._Km[n2 * 4 + 3] = this.a[1];
        }
    }

    @Override
    protected int encryptBlock(byte[] src, int srcIndex, byte[] dst, int dstIndex) {
        int[] nArray = new int[4];
        int n2 = this.BytesTo32bits(src, srcIndex);
        int n3 = this.BytesTo32bits(src, srcIndex + 4);
        int n4 = this.BytesTo32bits(src, srcIndex + 8);
        int n5 = this.BytesTo32bits(src, srcIndex + 12);
        this.CAST_Encipher(n2, n3, n4, n5, nArray);
        this.Bits32ToBytes(nArray[0], dst, dstIndex);
        this.Bits32ToBytes(nArray[1], dst, dstIndex + 4);
        this.Bits32ToBytes(nArray[2], dst, dstIndex + 8);
        this.Bits32ToBytes(nArray[3], dst, dstIndex + 12);
        return 16;
    }

    @Override
    protected int decryptBlock(byte[] src, int srcIndex, byte[] dst, int dstIndex) {
        int[] nArray = new int[4];
        int n2 = this.BytesTo32bits(src, srcIndex);
        int n3 = this.BytesTo32bits(src, srcIndex + 4);
        int n4 = this.BytesTo32bits(src, srcIndex + 8);
        int n5 = this.BytesTo32bits(src, srcIndex + 12);
        this.CAST_Decipher(n2, n3, n4, n5, nArray);
        this.Bits32ToBytes(nArray[0], dst, dstIndex);
        this.Bits32ToBytes(nArray[1], dst, dstIndex + 4);
        this.Bits32ToBytes(nArray[2], dst, dstIndex + 8);
        this.Bits32ToBytes(nArray[3], dst, dstIndex + 12);
        return 16;
    }

    protected final void CAST_Encipher(int A, int B, int C, int D, int[] result) {
        int n2;
        int n3;
        for (n3 = 0; n3 < 6; ++n3) {
            n2 = n3 * 4;
            D ^= this.F1(A ^= this.F3(B ^= this.F2(C ^= this.F1(D, this._Km[n2], this._Kr[n2]), this._Km[n2 + 1], this._Kr[n2 + 1]), this._Km[n2 + 2], this._Kr[n2 + 2]), this._Km[n2 + 3], this._Kr[n2 + 3]);
        }
        for (n3 = 6; n3 < 12; ++n3) {
            n2 = n3 * 4;
            B ^= this.F2(C, this._Km[n2 + 1], this._Kr[n2 + 1]);
            C ^= this.F1(D ^= this.F1(A ^= this.F3(B, this._Km[n2 + 2], this._Kr[n2 + 2]), this._Km[n2 + 3], this._Kr[n2 + 3]), this._Km[n2], this._Kr[n2]);
        }
        result[0] = A;
        result[1] = B;
        result[2] = C;
        result[3] = D;
    }

    protected final void CAST_Decipher(int A, int B, int C, int D, int[] result) {
        int n2;
        int n3;
        for (n3 = 0; n3 < 6; ++n3) {
            n2 = (11 - n3) * 4;
            D ^= this.F1(A ^= this.F3(B ^= this.F2(C ^= this.F1(D, this._Km[n2], this._Kr[n2]), this._Km[n2 + 1], this._Kr[n2 + 1]), this._Km[n2 + 2], this._Kr[n2 + 2]), this._Km[n2 + 3], this._Kr[n2 + 3]);
        }
        for (n3 = 6; n3 < 12; ++n3) {
            n2 = (11 - n3) * 4;
            B ^= this.F2(C, this._Km[n2 + 1], this._Kr[n2 + 1]);
            C ^= this.F1(D ^= this.F1(A ^= this.F3(B, this._Km[n2 + 2], this._Kr[n2 + 2]), this._Km[n2 + 3], this._Kr[n2 + 3]), this._Km[n2], this._Kr[n2]);
        }
        result[0] = A;
        result[1] = B;
        result[2] = C;
        result[3] = D;
    }
}

