/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.engines.Salsa20Engine;
import com.enterprisedt.bouncycastle.util.Integers;
import com.enterprisedt.bouncycastle.util.Pack;

public class ChaChaEngine
extends Salsa20Engine {
    public ChaChaEngine() {
    }

    public ChaChaEngine(int rounds) {
        super(rounds);
    }

    @Override
    public String getAlgorithmName() {
        return "ChaCha" + this.rounds;
    }

    @Override
    protected void advanceCounter(long diff) {
        int n2 = (int)(diff >>> 32);
        int n3 = (int)diff;
        if (n2 > 0) {
            this.engineState[13] = this.engineState[13] + n2;
        }
        int n4 = this.engineState[12];
        this.engineState[12] = this.engineState[12] + n3;
        if (n4 != 0 && this.engineState[12] < n4) {
            this.engineState[13] = this.engineState[13] + 1;
        }
    }

    @Override
    protected void advanceCounter() {
        this.engineState[12] = this.engineState[12] + 1;
        if (this.engineState[12] == 0) {
            this.engineState[13] = this.engineState[13] + 1;
        }
    }

    @Override
    protected void retreatCounter(long diff) {
        int n2 = (int)(diff >>> 32);
        int n3 = (int)diff;
        if (n2 != 0) {
            if (((long)this.engineState[13] & 0xFFFFFFFFL) >= ((long)n2 & 0xFFFFFFFFL)) {
                this.engineState[13] = this.engineState[13] - n2;
            } else {
                throw new IllegalStateException("attempt to reduce counter past zero.");
            }
        }
        if (((long)this.engineState[12] & 0xFFFFFFFFL) >= ((long)n3 & 0xFFFFFFFFL)) {
            this.engineState[12] = this.engineState[12] - n3;
        } else if (this.engineState[13] != 0) {
            this.engineState[13] = this.engineState[13] - 1;
            this.engineState[12] = this.engineState[12] - n3;
        } else {
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
    }

    @Override
    protected void retreatCounter() {
        if (this.engineState[12] == 0 && this.engineState[13] == 0) {
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
        this.engineState[12] = this.engineState[12] - 1;
        if (this.engineState[12] == -1) {
            this.engineState[13] = this.engineState[13] - 1;
        }
    }

    @Override
    protected long getCounter() {
        return (long)this.engineState[13] << 32 | (long)this.engineState[12] & 0xFFFFFFFFL;
    }

    @Override
    protected void resetCounter() {
        this.engineState[13] = 0;
        this.engineState[12] = 0;
    }

    @Override
    protected void setKey(byte[] keyBytes, byte[] ivBytes) {
        if (keyBytes != null) {
            if (keyBytes.length != 16 && keyBytes.length != 32) {
                throw new IllegalArgumentException(this.getAlgorithmName() + " requires 128 bit or 256 bit key");
            }
            this.packTauOrSigma(keyBytes.length, this.engineState, 0);
            Pack.littleEndianToInt(keyBytes, 0, this.engineState, 4, 4);
            Pack.littleEndianToInt(keyBytes, keyBytes.length - 16, this.engineState, 8, 4);
        }
        Pack.littleEndianToInt(ivBytes, 0, this.engineState, 14, 2);
    }

    @Override
    protected void generateKeyStream(byte[] output) {
        ChaChaEngine.chachaCore(this.rounds, this.engineState, this.x);
        Pack.intToLittleEndian(this.x, output, 0);
    }

    public static void chachaCore(int rounds, int[] input, int[] x) {
        if (input.length != 16) {
            throw new IllegalArgumentException();
        }
        if (x.length != 16) {
            throw new IllegalArgumentException();
        }
        if (rounds % 2 != 0) {
            throw new IllegalArgumentException("Number of rounds must be even");
        }
        int n2 = input[0];
        int n3 = input[1];
        int n4 = input[2];
        int n5 = input[3];
        int n6 = input[4];
        int n7 = input[5];
        int n8 = input[6];
        int n9 = input[7];
        int n10 = input[8];
        int n11 = input[9];
        int n12 = input[10];
        int n13 = input[11];
        int n14 = input[12];
        int n15 = input[13];
        int n16 = input[14];
        int n17 = input[15];
        for (int i2 = rounds; i2 > 0; i2 -= 2) {
            n14 = Integers.rotateLeft(n14 ^ (n2 += n6), 16);
            n6 = Integers.rotateLeft(n6 ^ (n10 += n14), 12);
            n14 = Integers.rotateLeft(n14 ^ (n2 += n6), 8);
            n6 = Integers.rotateLeft(n6 ^ (n10 += n14), 7);
            n15 = Integers.rotateLeft(n15 ^ (n3 += n7), 16);
            n7 = Integers.rotateLeft(n7 ^ (n11 += n15), 12);
            n15 = Integers.rotateLeft(n15 ^ (n3 += n7), 8);
            n7 = Integers.rotateLeft(n7 ^ (n11 += n15), 7);
            n16 = Integers.rotateLeft(n16 ^ (n4 += n8), 16);
            n8 = Integers.rotateLeft(n8 ^ (n12 += n16), 12);
            n16 = Integers.rotateLeft(n16 ^ (n4 += n8), 8);
            n8 = Integers.rotateLeft(n8 ^ (n12 += n16), 7);
            n17 = Integers.rotateLeft(n17 ^ (n5 += n9), 16);
            n9 = Integers.rotateLeft(n9 ^ (n13 += n17), 12);
            n17 = Integers.rotateLeft(n17 ^ (n5 += n9), 8);
            n9 = Integers.rotateLeft(n9 ^ (n13 += n17), 7);
            n17 = Integers.rotateLeft(n17 ^ (n2 += n7), 16);
            n7 = Integers.rotateLeft(n7 ^ (n12 += n17), 12);
            n17 = Integers.rotateLeft(n17 ^ (n2 += n7), 8);
            n7 = Integers.rotateLeft(n7 ^ (n12 += n17), 7);
            n14 = Integers.rotateLeft(n14 ^ (n3 += n8), 16);
            n8 = Integers.rotateLeft(n8 ^ (n13 += n14), 12);
            n14 = Integers.rotateLeft(n14 ^ (n3 += n8), 8);
            n8 = Integers.rotateLeft(n8 ^ (n13 += n14), 7);
            n15 = Integers.rotateLeft(n15 ^ (n4 += n9), 16);
            n9 = Integers.rotateLeft(n9 ^ (n10 += n15), 12);
            n15 = Integers.rotateLeft(n15 ^ (n4 += n9), 8);
            n9 = Integers.rotateLeft(n9 ^ (n10 += n15), 7);
            n16 = Integers.rotateLeft(n16 ^ (n5 += n6), 16);
            n6 = Integers.rotateLeft(n6 ^ (n11 += n16), 12);
            n16 = Integers.rotateLeft(n16 ^ (n5 += n6), 8);
            n6 = Integers.rotateLeft(n6 ^ (n11 += n16), 7);
        }
        x[0] = n2 + input[0];
        x[1] = n3 + input[1];
        x[2] = n4 + input[2];
        x[3] = n5 + input[3];
        x[4] = n6 + input[4];
        x[5] = n7 + input[5];
        x[6] = n8 + input[6];
        x[7] = n9 + input[7];
        x[8] = n10 + input[8];
        x[9] = n11 + input[9];
        x[10] = n12 + input[10];
        x[11] = n13 + input[11];
        x[12] = n14 + input[12];
        x[13] = n15 + input[13];
        x[14] = n16 + input[14];
        x[15] = n17 + input[15];
    }
}

