/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;

public class CramerShoupCiphertext {
    BigInteger a;
    BigInteger b;
    BigInteger c;
    BigInteger d;

    public CramerShoupCiphertext() {
    }

    public CramerShoupCiphertext(BigInteger u1, BigInteger u2, BigInteger e2, BigInteger v2) {
        this.a = u1;
        this.b = u2;
        this.c = e2;
        this.d = v2;
    }

    public CramerShoupCiphertext(byte[] c2) {
        int n2 = 0;
        int n3 = Pack.bigEndianToInt(c2, n2);
        byte[] byArray = Arrays.copyOfRange(c2, n2 += 4, n2 + n3);
        n2 += n3;
        this.a = new BigInteger(byArray);
        n3 = Pack.bigEndianToInt(c2, n2);
        byArray = Arrays.copyOfRange(c2, n2 += 4, n2 + n3);
        n2 += n3;
        this.b = new BigInteger(byArray);
        n3 = Pack.bigEndianToInt(c2, n2);
        byArray = Arrays.copyOfRange(c2, n2 += 4, n2 + n3);
        n2 += n3;
        this.c = new BigInteger(byArray);
        n3 = Pack.bigEndianToInt(c2, n2);
        byArray = Arrays.copyOfRange(c2, n2 += 4, n2 + n3);
        n2 += n3;
        this.d = new BigInteger(byArray);
    }

    public BigInteger getU1() {
        return this.a;
    }

    public void setU1(BigInteger u1) {
        this.a = u1;
    }

    public BigInteger getU2() {
        return this.b;
    }

    public void setU2(BigInteger u2) {
        this.b = u2;
    }

    public BigInteger getE() {
        return this.c;
    }

    public void setE(BigInteger e2) {
        this.c = e2;
    }

    public BigInteger getV() {
        return this.d;
    }

    public void setV(BigInteger v2) {
        this.d = v2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("u1: " + this.a.toString());
        stringBuffer.append("\nu2: " + this.b.toString());
        stringBuffer.append("\ne: " + this.c.toString());
        stringBuffer.append("\nv: " + this.d.toString());
        return stringBuffer.toString();
    }

    public byte[] toByteArray() {
        byte[] byArray = this.a.toByteArray();
        int n2 = byArray.length;
        byte[] byArray2 = this.b.toByteArray();
        int n3 = byArray2.length;
        byte[] byArray3 = this.c.toByteArray();
        int n4 = byArray3.length;
        byte[] byArray4 = this.d.toByteArray();
        int n5 = byArray4.length;
        int n6 = 0;
        byte[] byArray5 = new byte[n2 + n3 + n4 + n5 + 16];
        Pack.intToBigEndian(n2, byArray5, n6);
        System.arraycopy(byArray, 0, byArray5, n6 += 4, n2);
        Pack.intToBigEndian(n3, byArray5, n6 += n2);
        System.arraycopy(byArray2, 0, byArray5, n6 += 4, n3);
        Pack.intToBigEndian(n4, byArray5, n6 += n3);
        System.arraycopy(byArray3, 0, byArray5, n6 += 4, n4);
        Pack.intToBigEndian(n5, byArray5, n6 += n4);
        System.arraycopy(byArray4, 0, byArray5, n6 += 4, n5);
        n6 += n5;
        return byArray5;
    }
}

