/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.Wrapper;
import com.enterprisedt.bouncycastle.crypto.engines.DSTU7624Engine;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.util.ArrayList;

public class DSTU7624WrapEngine
implements Wrapper {
    private boolean a;
    private DSTU7624Engine b;
    private byte[] c;
    private byte[] d;
    private byte[] e;
    private byte[] f;
    private ArrayList<byte[]> g;

    public DSTU7624WrapEngine(int blockBitLength) {
        this.b = new DSTU7624Engine(blockBitLength);
        this.c = new byte[this.b.getBlockSize() / 2];
        this.e = new byte[this.b.getBlockSize()];
        this.f = new byte[this.b.getBlockSize()];
        this.g = new ArrayList();
        this.d = new byte[4];
    }

    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            param = ((ParametersWithRandom)param).getParameters();
        }
        this.a = forWrapping;
        if (!(param instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameters passed to DSTU7624WrapEngine");
        }
        this.b.init(forWrapping, param);
    }

    @Override
    public String getAlgorithmName() {
        return "DSTU7624WrapEngine";
    }

    @Override
    public byte[] wrap(byte[] in, int inOff, int inLen) {
        int n2;
        if (!this.a) {
            throw new IllegalStateException("not set for wrapping");
        }
        if (inLen % this.b.getBlockSize() != 0) {
            throw new DataLengthException("wrap data must be a multiple of " + this.b.getBlockSize() + " bytes");
        }
        if (inOff + inLen > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        int n3 = 2 * (1 + inLen / this.b.getBlockSize());
        int n4 = (n3 - 1) * 6;
        byte[] byArray = new byte[inLen + this.b.getBlockSize()];
        System.arraycopy(in, inOff, byArray, 0, inLen);
        System.arraycopy(byArray, 0, this.c, 0, this.b.getBlockSize() / 2);
        this.g.clear();
        int n5 = byArray.length - this.b.getBlockSize() / 2;
        int n6 = this.b.getBlockSize() / 2;
        while (n5 != 0) {
            byte[] byArray2 = new byte[this.b.getBlockSize() / 2];
            System.arraycopy(byArray, n6, byArray2, 0, this.b.getBlockSize() / 2);
            this.g.add(byArray2);
            n5 -= this.b.getBlockSize() / 2;
            n6 += this.b.getBlockSize() / 2;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            int n7;
            System.arraycopy(this.c, 0, byArray, 0, this.b.getBlockSize() / 2);
            System.arraycopy(this.g.get(0), 0, byArray, this.b.getBlockSize() / 2, this.b.getBlockSize() / 2);
            this.b.processBlock(byArray, 0, byArray, 0);
            this.a(n2 + 1, this.d, 0);
            for (n7 = 0; n7 < 4; ++n7) {
                int n8 = n7 + this.b.getBlockSize() / 2;
                byArray[n8] = (byte)(byArray[n8] ^ this.d[n7]);
            }
            System.arraycopy(byArray, this.b.getBlockSize() / 2, this.c, 0, this.b.getBlockSize() / 2);
            for (n7 = 2; n7 < n3; ++n7) {
                System.arraycopy(this.g.get(n7 - 1), 0, this.g.get(n7 - 2), 0, this.b.getBlockSize() / 2);
            }
            System.arraycopy(byArray, 0, this.g.get(n3 - 2), 0, this.b.getBlockSize() / 2);
        }
        System.arraycopy(this.c, 0, byArray, 0, this.b.getBlockSize() / 2);
        n6 = this.b.getBlockSize() / 2;
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            System.arraycopy(this.g.get(n2), 0, byArray, n6, this.b.getBlockSize() / 2);
            n6 += this.b.getBlockSize() / 2;
        }
        return byArray;
    }

    @Override
    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int n2;
        if (this.a) {
            throw new IllegalStateException("not set for unwrapping");
        }
        if (inLen % this.b.getBlockSize() != 0) {
            throw new DataLengthException("unwrap data must be a multiple of " + this.b.getBlockSize() + " bytes");
        }
        int n3 = 2 * inLen / this.b.getBlockSize();
        int n4 = (n3 - 1) * 6;
        byte[] byArray = new byte[inLen];
        System.arraycopy(in, inOff, byArray, 0, inLen);
        byte[] byArray2 = new byte[this.b.getBlockSize() / 2];
        System.arraycopy(byArray, 0, byArray2, 0, this.b.getBlockSize() / 2);
        this.g.clear();
        int n5 = byArray.length - this.b.getBlockSize() / 2;
        int n6 = this.b.getBlockSize() / 2;
        while (n5 != 0) {
            byte[] byArray3 = new byte[this.b.getBlockSize() / 2];
            System.arraycopy(byArray, n6, byArray3, 0, this.b.getBlockSize() / 2);
            this.g.add(byArray3);
            n5 -= this.b.getBlockSize() / 2;
            n6 += this.b.getBlockSize() / 2;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            int n7;
            System.arraycopy(this.g.get(n3 - 2), 0, byArray, 0, this.b.getBlockSize() / 2);
            System.arraycopy(byArray2, 0, byArray, this.b.getBlockSize() / 2, this.b.getBlockSize() / 2);
            this.a(n4 - n2, this.d, 0);
            for (n7 = 0; n7 < 4; ++n7) {
                int n8 = n7 + this.b.getBlockSize() / 2;
                byArray[n8] = (byte)(byArray[n8] ^ this.d[n7]);
            }
            this.b.processBlock(byArray, 0, byArray, 0);
            System.arraycopy(byArray, 0, byArray2, 0, this.b.getBlockSize() / 2);
            for (n7 = 2; n7 < n3; ++n7) {
                System.arraycopy(this.g.get(n3 - n7 - 1), 0, this.g.get(n3 - n7), 0, this.b.getBlockSize() / 2);
            }
            System.arraycopy(byArray, this.b.getBlockSize() / 2, this.g.get(0), 0, this.b.getBlockSize() / 2);
        }
        System.arraycopy(byArray2, 0, byArray, 0, this.b.getBlockSize() / 2);
        n6 = this.b.getBlockSize() / 2;
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            System.arraycopy(this.g.get(n2), 0, byArray, n6, this.b.getBlockSize() / 2);
            n6 += this.b.getBlockSize() / 2;
        }
        System.arraycopy(byArray, byArray.length - this.b.getBlockSize(), this.e, 0, this.b.getBlockSize());
        byte[] byArray4 = new byte[byArray.length - this.b.getBlockSize()];
        if (!Arrays.areEqual(this.e, this.f)) {
            throw new InvalidCipherTextException("checksum failed");
        }
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length - this.b.getBlockSize());
        return byArray4;
    }

    private void a(int n2, byte[] byArray, int n3) {
        byArray[n3 + 3] = (byte)(n2 >> 24);
        byArray[n3 + 2] = (byte)(n2 >> 16);
        byArray[n3 + 1] = (byte)(n2 >> 8);
        byArray[n3] = (byte)n2;
    }
}

