/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.engines.c;
import com.enterprisedt.bouncycastle.crypto.modes.AEADCipher;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class ElephantEngine
implements AEADCipher {
    private boolean a;
    private final String b;
    private final ElephantParameters c;
    private final int d;
    private int e;
    private int f;
    private final int g;
    private byte h;
    private byte[] i;
    private byte[] j;
    private byte[] k;
    private final byte l = (byte)16;
    private final byte m = (byte)12;
    private final byte n;
    private boolean o;
    private int p;
    private byte[] q;
    private int r;
    private int s;
    private final byte[] t;
    private byte[] u;
    private byte[] v;
    private byte[] w;
    private final byte[] x;
    private a y = com.enterprisedt.bouncycastle.crypto.engines.ElephantEngine$a.a;
    private final ByteArrayOutputStream z = new ByteArrayOutputStream();
    private int A;
    private byte[] B;
    private final byte[] C;
    private final byte[] D;
    private final byte[] E = new byte[]{-18, -19, -21, -32, -30, -31, -28, -17, -25, -22, -24, -27, -23, -20, -29, -26, -34, -35, -37, -48, -46, -47, -44, -33, -41, -38, -40, -43, -39, -36, -45, -42, -66, -67, -69, -80, -78, -79, -76, -65, -73, -70, -72, -75, -71, -68, -77, -74, 14, 13, 11, 0, 2, 1, 4, 15, 7, 10, 8, 5, 9, 12, 3, 6, 46, 45, 43, 32, 34, 33, 36, 47, 39, 42, 40, 37, 41, 44, 35, 38, 30, 29, 27, 16, 18, 17, 20, 31, 23, 26, 24, 21, 25, 28, 19, 22, 78, 77, 75, 64, 66, 65, 68, 79, 71, 74, 72, 69, 73, 76, 67, 70, -2, -3, -5, -16, -14, -15, -12, -1, -9, -6, -8, -11, -7, -4, -13, -10, 126, 125, 123, 112, 114, 113, 116, 127, 119, 122, 120, 117, 121, 124, 115, 118, -82, -83, -85, -96, -94, -95, -92, -81, -89, -86, -88, -91, -87, -84, -93, -90, -114, -115, -117, -128, -126, -127, -124, -113, -121, -118, -120, -123, -119, -116, -125, -122, 94, 93, 91, 80, 82, 81, 84, 95, 87, 90, 88, 85, 89, 92, 83, 86, -98, -99, -101, -112, -110, -111, -108, -97, -105, -102, -104, -107, -103, -100, -109, -106, -50, -51, -53, -64, -62, -63, -60, -49, -57, -54, -56, -59, -55, -52, -61, -58, 62, 61, 59, 48, 50, 49, 52, 63, 55, 58, 56, 53, 57, 60, 51, 54, 110, 109, 107, 96, 98, 97, 100, 111, 103, 106, 104, 101, 105, 108, 99, 102};
    private final byte[] F = new byte[]{1, -126, -118, 0, -117, 1, -127, 9, -118, -120, 9, 10, -117, -117, -119, 3, 2, -128};
    private final int[] G = new int[]{0, 1, 6, 4, 3, 4, 4, 6, 7, 4, 3, 2, 3, 1, 7, 1, 5, 7, 5, 0, 2, 2, 5, 0, 6};

    public ElephantEngine(ElephantParameters parameters) {
        switch (parameters) {
            case elephant160: {
                this.d = 20;
                this.e = 160;
                this.f = 20;
                this.g = 80;
                this.h = (byte)117;
                this.n = (byte)8;
                this.b = "Elephant 160 AEAD";
                break;
            }
            case elephant176: {
                this.d = 22;
                this.e = 176;
                this.f = 22;
                this.g = 90;
                this.h = (byte)69;
                this.n = (byte)8;
                this.b = "Elephant 176 AEAD";
                break;
            }
            case elephant200: {
                this.d = 25;
                this.g = 18;
                this.n = (byte)16;
                this.b = "Elephant 200 AEAD";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameter settings for Elephant");
            }
        }
        this.c = parameters;
        this.t = new byte[this.d];
        this.u = new byte[this.d];
        this.v = new byte[this.d];
        this.w = new byte[this.d];
        this.x = new byte[this.d];
        this.C = new byte[this.d];
        this.D = new byte[this.d];
        this.o = false;
        this.a(false);
    }

    private void a(byte[] byArray) {
        switch (this.c) {
            case elephant160: 
            case elephant176: {
                byte by = this.h;
                byte[] byArray2 = new byte[this.f];
                for (int i2 = 0; i2 < this.g; ++i2) {
                    int n2;
                    byArray[0] = (byte)(byArray[0] ^ by);
                    int n3 = this.f - 1;
                    byArray[n3] = (byte)(byArray[n3] ^ (byte)((by & 1) << 7 | (by & 2) << 5 | (by & 4) << 3 | (by & 8) << 1 | (by & 0x10) >>> 1 | (by & 0x20) >>> 3 | (by & 0x40) >>> 5 | (by & 0x80) >>> 7));
                    by = (byte)((by << 1 | (0x40 & by) >>> 6 ^ (0x20 & by) >>> 5) & 0x7F);
                    for (n2 = 0; n2 < this.f; ++n2) {
                        byArray[n2] = this.E[byArray[n2] & 0xFF];
                    }
                    Arrays.fill(byArray2, (byte)0);
                    for (int i3 = 0; i3 < this.f; ++i3) {
                        for (int i4 = 0; i4 < 8; ++i4) {
                            n2 = (i3 << 3) + i4;
                            if (n2 != this.e - 1) {
                                n2 = (n2 * this.e >> 2) % (this.e - 1);
                            }
                            int n4 = n2 >>> 3;
                            byArray2[n4] = (byte)(byArray2[n4] ^ ((byArray[i3] & 0xFF) >>> i4 & 1) << (n2 & 7));
                        }
                    }
                    System.arraycopy(byArray2, 0, byArray, 0, this.f);
                }
                break;
            }
            case elephant200: {
                for (int i5 = 0; i5 < this.g; ++i5) {
                    this.a(byArray, i5);
                }
                break;
            }
        }
    }

    private byte a(byte by) {
        return (byte)((by & 0xFF) << 1 | (by & 0xFF) >>> 7);
    }

    private byte a(byte n2, int n3) {
        return (byte)(n3 != 0 ? (n2 & 0xFF) << n3 ^ (n2 & 0xFF) >>> 8 - n3 : n2);
    }

    private int a(int n2, int n3) {
        return n2 + n3 * 5;
    }

    private void a(byte[] byArray, int n2) {
        int n3;
        int n4;
        byte[] byArray2 = new byte[25];
        for (n4 = 0; n4 < 5; ++n4) {
            for (n3 = 0; n3 < 5; ++n3) {
                int n5 = n4;
                byArray2[n5] = (byte)(byArray2[n5] ^ byArray[this.a(n4, n3)]);
            }
        }
        for (n4 = 0; n4 < 5; ++n4) {
            byArray2[n4 + 5] = (byte)(this.a(byArray2[(n4 + 1) % 5], 1) ^ byArray2[(n4 + 4) % 5]);
        }
        for (n4 = 0; n4 < 5; ++n4) {
            for (n3 = 0; n3 < 5; ++n3) {
                int n6 = this.a(n4, n3);
                byArray[n6] = (byte)(byArray[n6] ^ byArray2[n4 + 5]);
            }
        }
        for (n4 = 0; n4 < 5; ++n4) {
            for (n3 = 0; n3 < 5; ++n3) {
                byArray2[this.a((int)n4, (int)n3)] = this.a(byArray[this.a(n4, n3)], this.G[this.a(n4, n3)]);
            }
        }
        for (n4 = 0; n4 < 5; ++n4) {
            for (n3 = 0; n3 < 5; ++n3) {
                byArray[this.a((int)n3, (int)((2 * n4 + 3 * n3) % 5))] = byArray2[this.a(n4, n3)];
            }
        }
        for (n3 = 0; n3 < 5; ++n3) {
            for (n4 = 0; n4 < 5; ++n4) {
                byArray2[n4] = (byte)(byArray[this.a(n4, n3)] ^ ~byArray[this.a((n4 + 1) % 5, n3)] & byArray[this.a((n4 + 2) % 5, n3)]);
            }
            for (n4 = 0; n4 < 5; ++n4) {
                byArray[this.a((int)n4, (int)n3)] = byArray2[n4];
            }
        }
        byArray[0] = (byte)(byArray[0] ^ this.F[n2]);
    }

    private void a(byte[] byArray, byte[] byArray2) {
        switch (this.c) {
            case elephant160: {
                byArray[this.d - 1] = (byte)(((byArray2[0] & 0xFF) << 3 | (byArray2[0] & 0xFF) >>> 5) ^ (byArray2[3] & 0xFF) << 7 ^ (byArray2[13] & 0xFF) >>> 7);
                break;
            }
            case elephant176: {
                byArray[this.d - 1] = (byte)(this.a(byArray2[0]) ^ (byArray2[3] & 0xFF) << 7 ^ (byArray2[19] & 0xFF) >>> 7);
                break;
            }
            case elephant200: {
                byArray[this.d - 1] = (byte)(this.a(byArray2[0]) ^ this.a(byArray2[2]) ^ byArray2[13] << 1);
            }
        }
        System.arraycopy(byArray2, 1, byArray, 0, this.d - 1);
    }

    private void a(byte[] byArray, byte[] byArray2, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2;
            byArray[n4] = (byte)(byArray[n4] ^ byArray2[i2 + n2]);
        }
    }

    private void a(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = n4 * this.d;
        if (n5 == n3) {
            Arrays.fill(byArray, 0, this.d, (byte)0);
            byArray[0] = 1;
            return;
        }
        int n6 = n3 - n5;
        if (this.d <= n6) {
            System.arraycopy(byArray2, n2, byArray, 0, this.d);
        } else {
            if (n6 > 0) {
                System.arraycopy(byArray2, n2, byArray, 0, n6);
            }
            Arrays.fill(byArray, n6, this.d, (byte)0);
            byArray[n6] = 1;
        }
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.a = forEncryption;
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException(this.b + " init parameters must include an IV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)params;
        this.j = parametersWithIV.getIV();
        if (this.j == null || this.j.length != 12) {
            throw new IllegalArgumentException(this.b + " requires exactly 12 bytes of IV");
        }
        if (!(parametersWithIV.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException(this.b + " init parameters must include a key");
        }
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        byte[] byArray = keyParameter.getKey();
        if (byArray.length != 16) {
            throw new IllegalArgumentException(this.b + " key must be 128 bits long");
        }
        this.k = new byte[this.d];
        System.arraycopy(byArray, 0, this.k, 0, 16);
        this.a(this.k);
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, com.enterprisedt.bouncycastle.crypto.engines.c.a(forEncryption)));
        this.o = true;
        this.y = forEncryption ? com.enterprisedt.bouncycastle.crypto.engines.ElephantEngine$a.b : com.enterprisedt.bouncycastle.crypto.engines.ElephantEngine$a.f;
        this.B = new byte[this.d + (forEncryption ? (byte)0 : this.n)];
        this.a(false);
    }

    @Override
    public String getAlgorithmName() {
        return this.b;
    }

    @Override
    public void processAADByte(byte input) {
        this.z.write(input);
    }

    @Override
    public void processAADBytes(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.z.write(input, inOff, len);
    }

    @Override
    public int processByte(byte input, byte[] output, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{input}, 0, 1, output, outOff);
    }

    @Override
    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        byte[] byArray = this.z.toByteArray();
        if (this.A + len - (this.a ? (byte)0 : this.n) >= this.d) {
            switch (this.y) {
                case b: 
                case f: {
                    this.b(this.t);
                }
            }
            int n2 = this.A + len - (this.a ? (byte)0 : this.n);
            int n3 = byArray.length;
            int n4 = n2 / this.d;
            int n5 = 1 + (n2 % this.d != 0 ? n4 : n4 - 1);
            int n6 = 1 + (12 + n3) / this.d;
            byte[] byArray2 = new byte[Math.max(n4, 1) * this.d];
            System.arraycopy(this.B, 0, byArray2, 0, this.A);
            int n7 = byArray2.length - this.A;
            System.arraycopy(input, inOff, byArray2, this.A, byArray2.length - this.A);
            this.a(byArray2, output, outOff, n4, n5, n4, n2, n6);
            this.A = len - n7;
            System.arraycopy(input, inOff + n7, this.B, 0, this.A);
            this.p += n4;
            return n4 * this.d;
        }
        System.arraycopy(input, inOff, this.B, this.A, len);
        this.A += len;
        return 0;
    }

    @Override
    public int doFinal(byte[] output, int outOff) throws IllegalStateException, InvalidCipherTextException {
        if (!this.o) {
            throw new IllegalArgumentException(this.b + " needs call init function before doFinal");
        }
        int n2 = this.A;
        if (this.a && n2 + outOff + this.n > output.length || !this.a && n2 + outOff - this.n > output.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        byte[] byArray = this.z.toByteArray();
        switch (this.y) {
            case b: 
            case f: {
                this.b(this.t);
            }
        }
        int n3 = n2 + this.p * this.d - (this.a ? (byte)0 : this.n);
        int n4 = byArray.length;
        int n5 = 1 + n3 / this.d;
        int n6 = n3 % this.d != 0 ? n5 : n5 - 1;
        int n7 = 1 + (12 + n4) / this.d;
        int n8 = Math.max(n5 + 1, n7 - 1);
        outOff += this.a(this.B, output, outOff, n8, n6, n5, n3, n7);
        this.i = new byte[this.n];
        this.a(this.t, this.k, 0, this.d);
        this.a(this.t);
        this.a(this.t, this.k, 0, this.d);
        if (this.a) {
            System.arraycopy(this.t, 0, this.i, 0, this.n);
            System.arraycopy(this.i, 0, output, outOff, this.i.length);
            n3 += this.n;
        } else {
            this.A -= this.n;
            for (int i2 = 0; i2 < this.n; ++i2) {
                if (this.t[i2] == this.B[this.A + i2]) continue;
                throw new IllegalArgumentException("Mac does not match");
            }
        }
        this.a(false);
        return n3;
    }

    @Override
    public byte[] getMac() {
        return this.i;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        switch (this.y) {
            case a: {
                throw new IllegalArgumentException(this.b + " needs call init function before getUpdateOutputSize");
            }
            case i: 
            case e: {
                return 0;
            }
            case b: 
            case c: 
            case d: {
                return this.A + len + this.n;
            }
        }
        return Math.max(0, len + this.A - this.n);
    }

    @Override
    public int getOutputSize(int len) {
        switch (this.y) {
            case a: {
                throw new IllegalArgumentException(this.b + " needs call init function before getUpdateOutputSize");
            }
            case i: 
            case e: {
                return 0;
            }
            case b: 
            case c: 
            case d: {
                return len + this.n;
            }
        }
        return Math.max(0, len - this.n);
    }

    @Override
    public void reset() {
        this.a(true);
    }

    private void a(boolean bl) {
        if (bl) {
            this.i = null;
        }
        this.z.reset();
        Arrays.fill(this.t, (byte)0);
        this.A = 0;
        this.p = 0;
        this.r = -1;
    }

    public int getKeyBytesSize() {
        return 16;
    }

    public int getIVBytesSize() {
        return 12;
    }

    public int getBlockSize() {
        return this.n;
    }

    private void a() {
        switch (this.y) {
            case h: {
                throw new IllegalArgumentException(this.b + " cannot process AAD when the length of the plaintext to be processed exceeds the a block size");
            }
            case d: {
                throw new IllegalArgumentException(this.b + " cannot process AAD when the length of the ciphertext to be processed exceeds the a block size");
            }
            case e: {
                throw new IllegalArgumentException(this.b + " cannot be reused for encryption");
            }
        }
    }

    private void b(byte[] byArray) {
        this.a();
        if (this.r == -1) {
            this.s = this.z.size();
            this.q = this.z.toByteArray();
            this.r = 0;
        }
        int n2 = 0;
        switch (this.y) {
            case f: {
                System.arraycopy(this.k, 0, this.v, 0, this.d);
                System.arraycopy(this.j, 0, byArray, 0, 12);
                n2 += 12;
                this.y = com.enterprisedt.bouncycastle.crypto.engines.ElephantEngine$a.g;
                break;
            }
            case b: {
                System.arraycopy(this.k, 0, this.v, 0, this.d);
                System.arraycopy(this.j, 0, byArray, 0, 12);
                n2 += 12;
                this.y = com.enterprisedt.bouncycastle.crypto.engines.ElephantEngine$a.c;
                break;
            }
            case c: 
            case g: {
                if (this.r != this.s) break;
                Arrays.fill(byArray, 0, this.d, (byte)0);
                byArray[0] = 1;
                return;
            }
            case h: {
                throw new IllegalArgumentException(this.b + " cannot process AAD when the length of the plaintext to be processed exceeds the a block size");
            }
            case d: {
                throw new IllegalArgumentException(this.b + " cannot process AAD when the length of the ciphertext to be processed exceeds the a block size");
            }
            case e: {
                throw new IllegalArgumentException(this.b + " cannot be reused for encryption");
            }
        }
        int n3 = this.d - n2;
        int n4 = this.s - this.r;
        if (n3 <= n4) {
            System.arraycopy(this.q, this.r, byArray, n2, n3);
            this.r += n3;
        } else {
            if (n4 > 0) {
                System.arraycopy(this.q, this.r, byArray, n2, n4);
                this.r += n4;
            }
            Arrays.fill(byArray, n2 + n4, n2 + n3, (byte)0);
            byArray[n2 + n4] = 1;
            switch (this.y) {
                case g: {
                    this.y = com.enterprisedt.bouncycastle.crypto.engines.ElephantEngine$a.h;
                    break;
                }
                case c: {
                    this.y = com.enterprisedt.bouncycastle.crypto.engines.ElephantEngine$a.d;
                }
            }
        }
    }

    private int a(byte[] byArray, byte[] byArray2, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 0;
        for (int i2 = this.p; i2 < n3; ++i2) {
            this.a(this.w, this.v);
            if (i2 < n4) {
                System.arraycopy(this.j, 0, this.x, 0, 12);
                Arrays.fill(this.x, 12, this.d, (byte)0);
                this.a(this.x, this.v, 0, this.d);
                this.a(this.x, this.w, 0, this.d);
                this.a(this.x);
                this.a(this.x, this.v, 0, this.d);
                this.a(this.x, this.w, 0, this.d);
                int n9 = i2 == n4 - 1 ? n6 - i2 * this.d : this.d;
                this.a(this.x, byArray, 0, n9);
                System.arraycopy(this.x, 0, byArray2, n2, n9);
                if (this.a) {
                    System.arraycopy(this.x, 0, this.D, 0, n9);
                } else {
                    System.arraycopy(byArray, 0, this.D, 0, n9);
                }
                n8 += n9;
            }
            if (i2 > 0 && i2 <= n5) {
                this.a(this.x, this.C, 0, n6, i2 - 1);
                this.a(this.x, this.u, 0, this.d);
                this.a(this.x, this.w, 0, this.d);
                this.a(this.x);
                this.a(this.x, this.u, 0, this.d);
                this.a(this.x, this.w, 0, this.d);
                this.a(this.t, this.x, 0, this.d);
            }
            if (i2 + 1 < n7) {
                this.b(this.x);
                this.a(this.x, this.w, 0, this.d);
                this.a(this.x);
                this.a(this.x, this.w, 0, this.d);
                this.a(this.t, this.x, 0, this.d);
            }
            byte[] byArray3 = this.u;
            this.u = this.v;
            this.v = this.w;
            this.w = byArray3;
            System.arraycopy(this.D, 0, this.C, 0, this.d);
        }
        return n8;
    }

    private static enum a {
        a,
        b,
        c,
        d,
        e,
        f,
        g,
        h,
        i;

    }

    public static enum ElephantParameters {
        elephant160,
        elephant176,
        elephant200;

    }
}

