/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.engines.c;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;

public class IDEAEngine
implements BlockCipher {
    protected static final int BLOCK_SIZE = 8;
    private int[] a = null;
    private boolean b;

    public IDEAEngine() {
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128));
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        if (params instanceof KeyParameter) {
            byte[] byArray = ((KeyParameter)params).getKey();
            this.a = this.a(forEncryption, byArray);
            this.b = forEncryption;
            CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), byArray.length * 8, params, c.a(forEncryption)));
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to IDEA init - " + params.getClass().getName());
    }

    @Override
    public String getAlgorithmName() {
        return "IDEA";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (this.a == null) {
            throw new IllegalStateException("IDEA engine not initialised");
        }
        if (inOff + 8 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 8 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        this.a(this.a, in, inOff, out, outOff);
        return 8;
    }

    @Override
    public void reset() {
    }

    private int a(byte[] byArray, int n2) {
        return (byArray[n2] << 8 & 0xFF00) + (byArray[n2 + 1] & 0xFF);
    }

    private void a(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >>> 8);
        byArray[n3 + 1] = (byte)n2;
    }

    private int a(int n2, int n3) {
        int n4;
        n2 = n2 == 0 ? 65537 - n3 : (n3 == 0 ? 65537 - n2 : n3 - n2 + ((n3 = (n4 = n2 * n3) & 0xFFFF) < (n2 = n4 >>> 16) ? 1 : 0));
        return n2 & 0xFFFF;
    }

    private void a(int[] nArray, byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = 0;
        int n5 = this.a(byArray, n2);
        int n6 = this.a(byArray, n2 + 2);
        int n7 = this.a(byArray, n2 + 4);
        int n8 = this.a(byArray, n2 + 6);
        for (int i2 = 0; i2 < 8; ++i2) {
            n5 = this.a(n5, nArray[n4++]);
            n6 += nArray[n4++];
            n7 += nArray[n4++];
            n8 = this.a(n8, nArray[n4++]);
            int n9 = n6 &= 0xFFFF;
            int n10 = n7 &= 0xFFFF;
            n7 ^= n5;
            n6 ^= n8;
            n7 = this.a(n7, nArray[n4++]);
            n6 += n7;
            n6 &= 0xFFFF;
            n6 = this.a(n6, nArray[n4++]);
            n7 += n6;
            n5 ^= n6;
            n8 ^= (n7 &= 0xFFFF);
            n6 ^= n10;
            n7 ^= n9;
        }
        this.a(this.a(n5, nArray[n4++]), byArray2, n3);
        this.a(n7 + nArray[n4++], byArray2, n3 + 2);
        this.a(n6 + nArray[n4++], byArray2, n3 + 4);
        this.a(this.a(n8, nArray[n4]), byArray2, n3 + 6);
    }

    private int[] a(byte[] byArray) {
        int n2;
        int[] nArray = new int[52];
        if (byArray.length < 16) {
            byte[] byArray2 = new byte[16];
            System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
            byArray = byArray2;
        }
        for (n2 = 0; n2 < 8; ++n2) {
            nArray[n2] = this.a(byArray, n2 * 2);
        }
        for (n2 = 8; n2 < 52; ++n2) {
            nArray[n2] = (n2 & 7) < 6 ? ((nArray[n2 - 7] & 0x7F) << 9 | nArray[n2 - 6] >> 7) & 0xFFFF : ((n2 & 7) == 6 ? ((nArray[n2 - 7] & 0x7F) << 9 | nArray[n2 - 14] >> 7) & 0xFFFF : ((nArray[n2 - 15] & 0x7F) << 9 | nArray[n2 - 14] >> 7) & 0xFFFF);
        }
        return nArray;
    }

    private int b(int n2) {
        if (n2 < 2) {
            return n2;
        }
        int n3 = 1;
        int n4 = 65537 / n2;
        for (int i2 = 65537 % n2; i2 != 1; i2 %= n2) {
            int n5 = n2 / i2;
            n3 = n3 + n4 * n5 & 0xFFFF;
            if ((n2 %= i2) == 1) {
                return n3;
            }
            n5 = i2 / n2;
            n4 = n4 + n3 * n5 & 0xFFFF;
        }
        return 1 - n4 & 0xFFFF;
    }

    int a(int n2) {
        return 0 - n2 & 0xFFFF;
    }

    private int[] a(int[] nArray) {
        int n2 = 52;
        int[] nArray2 = new int[52];
        int n3 = 0;
        int n4 = this.b(nArray[n3++]);
        int n5 = this.a(nArray[n3++]);
        int n6 = this.a(nArray[n3++]);
        int n7 = this.b(nArray[n3++]);
        nArray2[--n2] = n7;
        nArray2[--n2] = n6;
        nArray2[--n2] = n5;
        nArray2[--n2] = n4;
        for (int i2 = 1; i2 < 8; ++i2) {
            n4 = nArray[n3++];
            n5 = nArray[n3++];
            nArray2[--n2] = n5;
            nArray2[--n2] = n4;
            n4 = this.b(nArray[n3++]);
            n5 = this.a(nArray[n3++]);
            n6 = this.a(nArray[n3++]);
            n7 = this.b(nArray[n3++]);
            nArray2[--n2] = n7;
            nArray2[--n2] = n5;
            nArray2[--n2] = n6;
            nArray2[--n2] = n4;
        }
        n4 = nArray[n3++];
        n5 = nArray[n3++];
        nArray2[--n2] = n5;
        nArray2[--n2] = n4;
        n4 = this.b(nArray[n3++]);
        n5 = this.a(nArray[n3++]);
        n6 = this.a(nArray[n3++]);
        n7 = this.b(nArray[n3]);
        nArray2[--n2] = n7;
        nArray2[--n2] = n6;
        nArray2[--n2] = n5;
        nArray2[--n2] = n4;
        return nArray2;
    }

    private int[] a(boolean bl, byte[] byArray) {
        if (bl) {
            return this.a(byArray);
        }
        return this.a(this.a(byArray));
    }
}

