/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BasicAgreement;
import com.enterprisedt.bouncycastle.crypto.BufferedBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DerivationFunction;
import com.enterprisedt.bouncycastle.crypto.DerivationParameters;
import com.enterprisedt.bouncycastle.crypto.EphemeralKeyPair;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.KeyParser;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.IESParameters;
import com.enterprisedt.bouncycastle.crypto.params.IESWithCipherParameters;
import com.enterprisedt.bouncycastle.crypto.params.KDFParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class IESEngine {
    BasicAgreement a;
    DerivationFunction b;
    Mac c;
    BufferedBlockCipher d;
    byte[] e;
    boolean f;
    CipherParameters g;
    CipherParameters h;
    IESParameters i;
    byte[] j;
    private EphemeralKeyPairGenerator k;
    private KeyParser l;
    private byte[] m;

    public IESEngine(BasicAgreement agree, DerivationFunction kdf, Mac mac) {
        this.a = agree;
        this.b = kdf;
        this.c = mac;
        this.e = new byte[mac.getMacSize()];
        this.d = null;
    }

    public IESEngine(BasicAgreement agree, DerivationFunction kdf, Mac mac, BufferedBlockCipher cipher) {
        this.a = agree;
        this.b = kdf;
        this.c = mac;
        this.e = new byte[mac.getMacSize()];
        this.d = cipher;
    }

    public void init(boolean forEncryption, CipherParameters privParam, CipherParameters pubParam, CipherParameters params) {
        this.f = forEncryption;
        this.g = privParam;
        this.h = pubParam;
        this.j = new byte[0];
        this.a(params);
    }

    public void init(AsymmetricKeyParameter publicKey, CipherParameters params, EphemeralKeyPairGenerator ephemeralKeyPairGenerator) {
        this.f = true;
        this.h = publicKey;
        this.k = ephemeralKeyPairGenerator;
        this.a(params);
    }

    public void init(AsymmetricKeyParameter privateKey, CipherParameters params, KeyParser publicKeyParser) {
        this.f = false;
        this.g = privateKey;
        this.l = publicKeyParser;
        this.a(params);
    }

    private void a(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithIV) {
            this.m = ((ParametersWithIV)cipherParameters).getIV();
            this.i = (IESParameters)((ParametersWithIV)cipherParameters).getParameters();
        } else {
            this.m = null;
            this.i = (IESParameters)cipherParameters;
        }
    }

    public BufferedBlockCipher getCipher() {
        return this.d;
    }

    public Mac getMac() {
        return this.c;
    }

    private byte[] a(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        int n4;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        if (this.d == null) {
            byArray4 = new byte[n3];
            byArray5 = new byte[this.i.getMacKeySize() / 8];
            byArray3 = new byte[byArray4.length + byArray5.length];
            this.b.generateBytes(byArray3, 0, byArray3.length);
            if (this.j.length != 0) {
                System.arraycopy(byArray3, 0, byArray5, 0, byArray5.length);
                System.arraycopy(byArray3, byArray5.length, byArray4, 0, byArray4.length);
            } else {
                System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
                System.arraycopy(byArray3, n3, byArray5, 0, byArray5.length);
            }
            byArray2 = new byte[n3];
            for (int i2 = 0; i2 != n3; ++i2) {
                byArray2[i2] = (byte)(byArray[n2 + i2] ^ byArray4[i2]);
            }
            n4 = n3;
        } else {
            byArray4 = new byte[((IESWithCipherParameters)this.i).getCipherKeySize() / 8];
            byArray5 = new byte[this.i.getMacKeySize() / 8];
            byArray3 = new byte[byArray4.length + byArray5.length];
            this.b.generateBytes(byArray3, 0, byArray3.length);
            System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
            System.arraycopy(byArray3, byArray4.length, byArray5, 0, byArray5.length);
            if (this.m != null) {
                this.d.init(true, new ParametersWithIV(new KeyParameter(byArray4), this.m));
            } else {
                this.d.init(true, new KeyParameter(byArray4));
            }
            byArray2 = new byte[this.d.getOutputSize(n3)];
            n4 = this.d.processBytes(byArray, n2, n3, byArray2, 0);
            n4 += this.d.doFinal(byArray2, n4);
        }
        byte[] byArray6 = this.i.getEncodingV();
        byte[] byArray7 = null;
        if (this.j.length != 0) {
            byArray7 = this.getLengthTag(byArray6);
        }
        byte[] byArray8 = new byte[this.c.getMacSize()];
        this.c.init(new KeyParameter(byArray5));
        this.c.update(byArray2, 0, byArray2.length);
        if (byArray6 != null) {
            this.c.update(byArray6, 0, byArray6.length);
        }
        if (this.j.length != 0) {
            this.c.update(byArray7, 0, byArray7.length);
        }
        this.c.doFinal(byArray8, 0);
        byte[] byArray9 = new byte[this.j.length + n4 + byArray8.length];
        System.arraycopy(this.j, 0, byArray9, 0, this.j.length);
        System.arraycopy(byArray2, 0, byArray9, this.j.length, n4);
        System.arraycopy(byArray8, 0, byArray9, this.j.length + n4, byArray8.length);
        return byArray9;
    }

    private byte[] b(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte[] byArray2;
        byte[] byArray3;
        int n4 = 0;
        if (n3 < this.j.length + this.c.getMacSize()) {
            throw new InvalidCipherTextException("Length of input must be greater than the MAC and V combined");
        }
        if (this.d == null) {
            byte[] byArray4 = new byte[n3 - this.j.length - this.c.getMacSize()];
            byArray3 = new byte[this.i.getMacKeySize() / 8];
            byte[] byArray5 = new byte[byArray4.length + byArray3.length];
            this.b.generateBytes(byArray5, 0, byArray5.length);
            if (this.j.length != 0) {
                System.arraycopy(byArray5, 0, byArray3, 0, byArray3.length);
                System.arraycopy(byArray5, byArray3.length, byArray4, 0, byArray4.length);
            } else {
                System.arraycopy(byArray5, 0, byArray4, 0, byArray4.length);
                System.arraycopy(byArray5, byArray4.length, byArray3, 0, byArray3.length);
            }
            byArray2 = new byte[byArray4.length];
            for (int i2 = 0; i2 != byArray4.length; ++i2) {
                byArray2[i2] = (byte)(byArray[n2 + this.j.length + i2] ^ byArray4[i2]);
            }
        } else {
            byte[] byArray6 = new byte[((IESWithCipherParameters)this.i).getCipherKeySize() / 8];
            byArray3 = new byte[this.i.getMacKeySize() / 8];
            byte[] byArray7 = new byte[byArray6.length + byArray3.length];
            this.b.generateBytes(byArray7, 0, byArray7.length);
            System.arraycopy(byArray7, 0, byArray6, 0, byArray6.length);
            System.arraycopy(byArray7, byArray6.length, byArray3, 0, byArray3.length);
            CipherParameters cipherParameters = new KeyParameter(byArray6);
            if (this.m != null) {
                cipherParameters = new ParametersWithIV(cipherParameters, this.m);
            }
            this.d.init(false, cipherParameters);
            byArray2 = new byte[this.d.getOutputSize(n3 - this.j.length - this.c.getMacSize())];
            n4 = this.d.processBytes(byArray, n2 + this.j.length, n3 - this.j.length - this.c.getMacSize(), byArray2, 0);
        }
        byte[] byArray8 = this.i.getEncodingV();
        byte[] byArray9 = null;
        if (this.j.length != 0) {
            byArray9 = this.getLengthTag(byArray8);
        }
        int n5 = n2 + n3;
        byte[] byArray10 = Arrays.copyOfRange(byArray, n5 - this.c.getMacSize(), n5);
        byte[] byArray11 = new byte[byArray10.length];
        this.c.init(new KeyParameter(byArray3));
        this.c.update(byArray, n2 + this.j.length, n3 - this.j.length - byArray11.length);
        if (byArray8 != null) {
            this.c.update(byArray8, 0, byArray8.length);
        }
        if (this.j.length != 0) {
            this.c.update(byArray9, 0, byArray9.length);
        }
        this.c.doFinal(byArray11, 0);
        if (!Arrays.constantTimeAreEqual(byArray10, byArray11)) {
            throw new InvalidCipherTextException("invalid MAC");
        }
        if (this.d == null) {
            return byArray2;
        }
        n4 += this.d.doFinal(byArray2, n4);
        return Arrays.copyOfRange(byArray2, 0, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        Object object;
        Object object2;
        if (this.f) {
            if (this.k != null) {
                object2 = this.k.generate();
                this.g = ((EphemeralKeyPair)object2).getKeyPair().getPrivate();
                this.j = ((EphemeralKeyPair)object2).getEncodedPublicKey();
            }
        } else if (this.l != null) {
            object2 = new ByteArrayInputStream(in, inOff, inLen);
            try {
                this.h = this.l.readKey((InputStream)object2);
            }
            catch (IOException iOException) {
                throw new InvalidCipherTextException("unable to recover ephemeral public key: " + iOException.getMessage(), iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidCipherTextException("unable to recover ephemeral public key: " + illegalArgumentException.getMessage(), illegalArgumentException);
            }
            int n2 = inLen - ((ByteArrayInputStream)object2).available();
            this.j = Arrays.copyOfRange(in, inOff, inOff + n2);
        }
        this.a.init(this.g);
        object2 = this.a.calculateAgreement(this.h);
        byte[] byArray = BigIntegers.asUnsignedByteArray(this.a.getFieldSize(), (BigInteger)object2);
        if (this.j.length != 0) {
            object = Arrays.concatenate(this.j, byArray);
            Arrays.fill(byArray, (byte)0);
            byArray = object;
        }
        try {
            object = new KDFParameters(byArray, this.i.getDerivationV());
            this.b.init((DerivationParameters)object);
            byte[] byArray2 = this.f ? this.a(in, inOff, inLen) : this.b(in, inOff, inLen);
            return byArray2;
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
    }

    protected byte[] getLengthTag(byte[] p2) {
        byte[] byArray = new byte[8];
        if (p2 != null) {
            Pack.longToBigEndian((long)p2.length * 8L, byArray, 0);
        }
        return byArray;
    }
}

