/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.engines.c;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.util.Pack;

public class LEAEngine
implements BlockCipher {
    private static final int[] a = new int[]{-1007687205, 1147300610, 2044886154, 2027892972, 1902027934, -947529206, -531697110, -440137385};
    private final int[] b = new int[4];
    private int c;
    private int[][] d;
    private boolean e;

    @Override
    public void init(boolean pEncrypt, CipherParameters pParams) {
        if (!(pParams instanceof KeyParameter)) {
            throw new IllegalArgumentException("Invalid parameter passed to LEA init - " + pParams.getClass().getName());
        }
        byte[] byArray = ((KeyParameter)pParams).getKey();
        int n2 = byArray.length;
        if ((n2 << 1) % 16 != 0 || n2 < 16 || n2 > 32) {
            throw new IllegalArgumentException("KeyBitSize must be 128, 192 or 256");
        }
        this.e = pEncrypt;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), n2 * 8, pParams, com.enterprisedt.bouncycastle.crypto.engines.c.a(this.e)));
        this.b(byArray);
    }

    @Override
    public void reset() {
    }

    @Override
    public String getAlgorithmName() {
        return "LEA";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int processBlock(byte[] pInput, int pInOff, byte[] pOutput, int pOutOff) {
        LEAEngine.a(pInput, pInOff, false);
        LEAEngine.a(pOutput, pOutOff, true);
        return this.e ? this.a(pInput, pInOff, pOutput, pOutOff) : this.b(pInput, pInOff, pOutput, pOutOff);
    }

    private static int a(byte[] byArray) {
        return byArray == null ? 0 : byArray.length;
    }

    private static void a(byte[] byArray, int n2, boolean bl) {
        boolean bl2;
        int n3 = LEAEngine.a(byArray);
        int n4 = n2 + 16;
        boolean bl3 = bl2 = n2 < 0 || n4 < 0;
        if (bl2 || n4 > n3) {
            throw bl ? new OutputLengthException("Output buffer too short.") : new DataLengthException("Input buffer too short.");
        }
    }

    private int a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        Pack.littleEndianToInt(byArray, n2, this.b, 0, 4);
        for (int i2 = 0; i2 < this.c; ++i2) {
            this.a(i2);
        }
        Pack.intToLittleEndian(this.b, byArray2, n3);
        return 16;
    }

    private void a(int n2) {
        int[] nArray = this.d[n2];
        int n3 = (3 + n2) % 4;
        int n4 = LEAEngine.b(n3);
        this.b[n3] = LEAEngine.b((this.b[n4] ^ nArray[4]) + (this.b[n3] ^ nArray[5]), 3);
        n3 = n4;
        n4 = LEAEngine.b(n3);
        this.b[n3] = LEAEngine.b((this.b[n4] ^ nArray[2]) + (this.b[n3] ^ nArray[3]), 5);
        n3 = n4;
        n4 = LEAEngine.b(n3);
        this.b[n3] = LEAEngine.a((this.b[n4] ^ nArray[0]) + (this.b[n3] ^ nArray[1]), 9);
    }

    private static int b(int n2) {
        return n2 == 0 ? 3 : n2 - 1;
    }

    private int b(byte[] byArray, int n2, byte[] byArray2, int n3) {
        Pack.littleEndianToInt(byArray, n2, this.b, 0, 4);
        for (int i2 = this.c - 1; i2 >= 0; --i2) {
            this.c(i2);
        }
        Pack.intToLittleEndian(this.b, byArray2, n3);
        return 16;
    }

    private void c(int n2) {
        int[] nArray = this.d[n2];
        int n3 = n2 % 4;
        int n4 = LEAEngine.d(n3);
        this.b[n4] = LEAEngine.b(this.b[n4], 9) - (this.b[n3] ^ nArray[0]) ^ nArray[1];
        n3 = n4;
        n4 = LEAEngine.d(n4);
        this.b[n4] = LEAEngine.a(this.b[n4], 5) - (this.b[n3] ^ nArray[2]) ^ nArray[3];
        n3 = n4;
        n4 = LEAEngine.d(n4);
        this.b[n4] = LEAEngine.a(this.b[n4], 3) - (this.b[n3] ^ nArray[4]) ^ nArray[5];
    }

    private static int d(int n2) {
        return n2 == 3 ? 0 : n2 + 1;
    }

    private void b(byte[] byArray) {
        this.c = (byArray.length >> 1) + 16;
        this.d = new int[this.c][6];
        int n2 = byArray.length / 4;
        int[] nArray = new int[n2];
        Pack.littleEndianToInt(byArray, 0, nArray, 0, n2);
        switch (n2) {
            case 4: {
                this.a(nArray);
                break;
            }
            case 6: {
                this.b(nArray);
                break;
            }
            default: {
                this.c(nArray);
            }
        }
    }

    private void a(int[] nArray) {
        for (int i2 = 0; i2 < this.c; ++i2) {
            int n2;
            int n3 = LEAEngine.a(a[i2 & 3], i2);
            nArray[n2 = 0] = LEAEngine.a(nArray[n2++] + n3, 1);
            nArray[n2] = LEAEngine.a(nArray[n2] + LEAEngine.a(n3, n2++), 3);
            nArray[n2] = LEAEngine.a(nArray[n2] + LEAEngine.a(n3, n2++), 6);
            nArray[n2] = LEAEngine.a(nArray[n2] + LEAEngine.a(n3, n2), 11);
            int[] nArray2 = this.d[i2];
            nArray2[0] = nArray[0];
            nArray2[1] = nArray[1];
            nArray2[2] = nArray[2];
            nArray2[3] = nArray[1];
            nArray2[4] = nArray[3];
            nArray2[5] = nArray[1];
        }
    }

    private void b(int[] nArray) {
        for (int i2 = 0; i2 < this.c; ++i2) {
            int n2;
            int n3 = LEAEngine.a(a[i2 % 6], i2);
            nArray[n2 = 0] = LEAEngine.a(nArray[n2] + LEAEngine.a(n3, n2++), 1);
            nArray[n2] = LEAEngine.a(nArray[n2] + LEAEngine.a(n3, n2++), 3);
            nArray[n2] = LEAEngine.a(nArray[n2] + LEAEngine.a(n3, n2++), 6);
            nArray[n2] = LEAEngine.a(nArray[n2] + LEAEngine.a(n3, n2++), 11);
            nArray[n2] = LEAEngine.a(nArray[n2] + LEAEngine.a(n3, n2++), 13);
            nArray[n2] = LEAEngine.a(nArray[n2] + LEAEngine.a(n3, n2++), 17);
            System.arraycopy(nArray, 0, this.d[i2], 0, n2);
        }
    }

    private void c(int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.c; ++i2) {
            int n3 = LEAEngine.a(a[i2 & 7], i2);
            int[] nArray2 = this.d[i2];
            int n4 = 0;
            nArray2[n4] = LEAEngine.a(nArray[n2 & 7] + n3, 1);
            nArray[n2++ & 7] = nArray2[n4++];
            nArray2[n4] = LEAEngine.a(nArray[n2 & 7] + LEAEngine.a(n3, n4), 3);
            nArray[n2++ & 7] = nArray2[n4++];
            nArray2[n4] = LEAEngine.a(nArray[n2 & 7] + LEAEngine.a(n3, n4), 6);
            nArray[n2++ & 7] = nArray2[n4++];
            nArray2[n4] = LEAEngine.a(nArray[n2 & 7] + LEAEngine.a(n3, n4), 11);
            nArray[n2++ & 7] = nArray2[n4++];
            nArray2[n4] = LEAEngine.a(nArray[n2 & 7] + LEAEngine.a(n3, n4), 13);
            nArray[n2++ & 7] = nArray2[n4++];
            nArray2[n4] = LEAEngine.a(nArray[n2 & 7] + LEAEngine.a(n3, n4), 17);
            nArray[n2++ & 7] = nArray2[n4];
        }
    }

    private static int a(int n2, int n3) {
        return n2 << n3 | n2 >>> 32 - n3;
    }

    private static int b(int n2, int n3) {
        return n2 >>> n3 | n2 << 32 - n3;
    }
}

