/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;

public class NullEngine
implements BlockCipher {
    private boolean a;
    protected static final int DEFAULT_BLOCK_SIZE = 1;
    private final int b;

    public NullEngine() {
        this(1);
    }

    public NullEngine(int blockSize) {
        this.b = blockSize;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.a = true;
    }

    @Override
    public String getAlgorithmName() {
        return "Null";
    }

    @Override
    public int getBlockSize() {
        return this.b;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (!this.a) {
            throw new IllegalStateException("Null engine not initialised");
        }
        if (inOff + this.b > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + this.b > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 < this.b; ++i2) {
            out[outOff + i2] = in[inOff + i2];
        }
        return this.b;
    }

    @Override
    public void reset() {
    }
}

