/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.engines.c;
import com.enterprisedt.bouncycastle.crypto.modes.AEADCipher;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import java.io.ByteArrayOutputStream;

public class PhotonBeetleEngine
implements AEADCipher {
    private boolean a;
    private boolean b;
    private byte[] c;
    private byte[] d;
    private byte[] e;
    private byte[][] f;
    private byte[] g;
    private byte[] h;
    private boolean i;
    private boolean j;
    private final ByteArrayOutputStream k = new ByteArrayOutputStream();
    private final ByteArrayOutputStream l = new ByteArrayOutputStream();
    private final int m = 16;
    private final int n = 16;
    private final int o;
    private final int p;
    private final int q;
    private final int r = 16;
    private final int s;
    private final int t = 12;
    private final int u = 8;
    private final int v = 3;
    private final int w = 7;
    private final int x = 64;
    private final int y = 4;
    private final int z = 3;
    private final byte[][] A = new byte[][]{{1, 3, 7, 14, 13, 11, 6, 12, 9, 2, 5, 10}, {0, 2, 6, 15, 12, 10, 7, 13, 8, 3, 4, 11}, {2, 0, 4, 13, 14, 8, 5, 15, 10, 1, 6, 9}, {6, 4, 0, 9, 10, 12, 1, 11, 14, 5, 2, 13}, {14, 12, 8, 1, 2, 4, 9, 3, 6, 13, 10, 5}, {15, 13, 9, 0, 3, 5, 8, 2, 7, 12, 11, 4}, {13, 15, 11, 2, 1, 7, 10, 0, 5, 14, 9, 6}, {9, 11, 15, 6, 5, 3, 14, 4, 1, 10, 13, 2}};
    private final byte[][] B = new byte[][]{{2, 4, 2, 11, 2, 8, 5, 6}, {12, 9, 8, 13, 7, 7, 5, 2}, {4, 4, 13, 13, 9, 4, 13, 9}, {1, 6, 5, 1, 12, 13, 15, 14}, {15, 12, 9, 13, 14, 5, 14, 13}, {9, 14, 5, 15, 4, 12, 9, 6}, {12, 2, 2, 10, 3, 1, 1, 14}, {15, 1, 13, 10, 5, 10, 2, 3}};
    private final byte[] C = new byte[]{12, 5, 6, 11, 9, 0, 10, 13, 3, 14, 15, 8, 4, 7, 1, 2};

    public PhotonBeetleEngine(PhotonBeetleParameters pbp) {
        int n2 = 0;
        int n3 = 0;
        switch (pbp) {
            case pb32: {
                n3 = 32;
                n2 = 224;
                break;
            }
            case pb128: {
                n3 = 128;
                n2 = 128;
            }
        }
        this.o = n3 + 7 >>> 3;
        this.p = this.o >>> 1;
        int n4 = n3 + n2;
        this.q = n4 + 7 >>> 3;
        this.s = n4 - (this.q - 1 << 3) - 3;
        this.j = false;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.b = forEncryption;
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("Photon-Beetle AEAD init parameters must include an IV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)params;
        this.d = parametersWithIV.getIV();
        if (this.d == null || this.d.length != 16) {
            throw new IllegalArgumentException("Photon-Beetle AEAD requires exactly 16 bytes of IV");
        }
        if (!(parametersWithIV.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException("Photon-Beetle AEAD init parameters must include a key");
        }
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        this.c = keyParameter.getKey();
        if (this.c.length != 16) {
            throw new IllegalArgumentException("Photon-Beetle AEAD key must be 128 bits long");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, com.enterprisedt.bouncycastle.crypto.engines.c.a(forEncryption)));
        this.e = new byte[this.q];
        this.f = new byte[8][8];
        this.h = new byte[16];
        this.j = true;
        this.a(false);
    }

    @Override
    public String getAlgorithmName() {
        return "Photon-Beetle AEAD";
    }

    @Override
    public void processAADByte(byte input) {
        this.k.write(input);
    }

    @Override
    public void processAADBytes(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.k.write(input, inOff, len);
    }

    @Override
    public int processByte(byte input, byte[] output, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{input}, 0, 1, output, outOff);
    }

    @Override
    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.l.write(input, inOff, len);
        return 0;
    }

    @Override
    public int doFinal(byte[] output, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int n2;
        int n3;
        int n4;
        if (!this.j) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        int n5 = this.l.size() - (this.b ? 0 : 16);
        if (this.b && n5 + 16 + outOff > output.length || !this.b && n5 + outOff > output.length) {
            throw new OutputLengthException("output buffer too short");
        }
        byte[] byArray = this.l.toByteArray();
        int n6 = 0;
        this.g = this.k.toByteArray();
        int n7 = this.g.length;
        if (n7 != 0 || n5 != 0) {
            this.a = false;
        }
        byte by = this.a(n5 != 0, n7 % this.o == 0, (byte)3, (byte)4);
        byte by2 = this.a(n7 != 0, n5 % this.o == 0, (byte)5, (byte)6);
        if (n7 != 0) {
            n4 = (n7 + this.o - 1) / this.o;
            for (n3 = 0; n3 < n4 - 1; ++n3) {
                this.a();
                this.a(this.g, n3 * this.o, this.o);
            }
            this.a();
            n2 = n7 - n3 * this.o;
            this.a(this.g, n3 * this.o, n2);
            if (n2 < this.o) {
                int n8 = n2;
                this.e[n8] = (byte)(this.e[n8] ^ 1);
            }
            int n9 = this.q - 1;
            this.e[n9] = (byte)(this.e[n9] ^ by << this.s);
        }
        if (n5 != 0) {
            n4 = (n5 + this.o - 1) / this.o;
            for (n3 = 0; n3 < n4 - 1; ++n3) {
                this.a();
                this.a(output, outOff + n3 * this.o, byArray, n6 + n3 * this.o, this.o);
            }
            this.a();
            n2 = n5 - n3 * this.o;
            this.a(output, outOff + n3 * this.o, byArray, n6 + n3 * this.o, n2);
            if (n2 < this.o) {
                int n10 = n2;
                this.e[n10] = (byte)(this.e[n10] ^ 1);
            }
            int n11 = this.q - 1;
            this.e[n11] = (byte)(this.e[n11] ^ by2 << this.s);
        }
        outOff += n5;
        if (this.a) {
            int n12 = this.q - 1;
            this.e[n12] = (byte)(this.e[n12] ^ 1 << this.s);
        }
        this.a();
        this.h = new byte[16];
        System.arraycopy(this.e, 0, this.h, 0, 16);
        if (this.b) {
            System.arraycopy(this.h, 0, output, outOff, 16);
            n5 += 16;
        } else {
            for (n3 = 0; n3 < 16; ++n3) {
                if (this.h[n3] == byArray[n5 + n3]) continue;
                throw new IllegalArgumentException("Mac does not match");
            }
        }
        this.a(false);
        return n5;
    }

    @Override
    public byte[] getMac() {
        return this.h;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        return len;
    }

    @Override
    public int getOutputSize(int len) {
        return len + 16;
    }

    @Override
    public void reset() {
        if (!this.j) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        this.a(true);
    }

    private void a(boolean bl) {
        if (bl) {
            this.h = null;
        }
        this.a = true;
        this.k.reset();
        this.l.reset();
        System.arraycopy(this.c, 0, this.e, 0, this.c.length);
        System.arraycopy(this.d, 0, this.e, this.c.length, this.d.length);
        this.i = false;
    }

    private void a() {
        int n2;
        for (n2 = 0; n2 < 64; ++n2) {
            this.f[n2 >>> 3][n2 & 7] = (byte)((this.e[n2 >> 1] & 0xFF) >>> 4 * (n2 & 1) & 0xF);
        }
        for (int i2 = 0; i2 < 12; ++i2) {
            int n3;
            for (n2 = 0; n2 < 8; ++n2) {
                byte[] byArray = this.f[n2];
                byArray[0] = (byte)(byArray[0] ^ this.A[n2][i2]);
            }
            for (n2 = 0; n2 < 8; ++n2) {
                for (n3 = 0; n3 < 8; ++n3) {
                    this.f[n2][n3] = this.C[this.f[n2][n3]];
                }
            }
            for (n2 = 1; n2 < 8; ++n2) {
                System.arraycopy(this.f[n2], 0, this.e, 0, 8);
                System.arraycopy(this.e, n2, this.f[n2], 0, 8 - n2);
                System.arraycopy(this.e, 0, this.f[n2], 8 - n2, n2);
            }
            for (n3 = 0; n3 < 8; ++n3) {
                for (n2 = 0; n2 < 8; ++n2) {
                    byte by = 0;
                    for (int i3 = 0; i3 < 8; ++i3) {
                        int n4 = this.B[n2][i3];
                        int n5 = 0;
                        byte by2 = this.f[i3][n3];
                        for (int i4 = 0; i4 < 4; ++i4) {
                            if ((by2 >>> i4 & 1) != 0) {
                                n5 ^= n4;
                            }
                            if ((n4 >>> 3 & 1) != 0) {
                                n4 <<= 1;
                                n4 ^= 3;
                                continue;
                            }
                            n4 <<= 1;
                        }
                        by = (byte)(by ^ n5 & 0xF);
                    }
                    this.e[n2] = by;
                }
                for (n2 = 0; n2 < 8; ++n2) {
                    this.f[n2][n3] = this.e[n2];
                }
            }
        }
        for (n2 = 0; n2 < 64; n2 += 2) {
            this.e[n2 >>> 1] = (byte)(this.f[n2 >>> 3][n2 & 7] & 0xF | (this.f[n2 >>> 3][n2 + 1 & 7] & 0xF) << 4);
        }
    }

    private byte a(boolean bl, boolean bl2, byte by, byte by2) {
        if (bl && bl2) {
            return 1;
        }
        if (bl) {
            return 2;
        }
        if (bl2) {
            return by;
        }
        return by2;
    }

    private void a(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5;
        byte[] byArray3 = this.f[0];
        int n6 = Math.min(n4, this.p);
        for (n5 = 0; n5 < this.p - 1; ++n5) {
            byArray3[n5] = (byte)((this.e[n5] & 0xFF) >>> 1 | (this.e[n5 + 1] & 1) << 7);
        }
        byArray3[this.p - 1] = (byte)((this.e[n5] & 0xFF) >>> 1 | (this.e[0] & 1) << 7);
        n5 = 0;
        while (n5 < n6) {
            byArray[n5 + n2] = (byte)(this.e[n5 + this.p] ^ byArray2[n5++ + n3]);
        }
        while (n5 < n4) {
            byArray[n5 + n2] = (byte)(byArray3[n5 - this.p] ^ byArray2[n5++ + n3]);
        }
        if (this.b) {
            this.a(byArray2, n3, n4);
        } else {
            this.a(byArray, n3, n4);
        }
    }

    private void a(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n4++;
            this.e[n5] = (byte)(this.e[n5] ^ byArray[n2++]);
        }
    }

    public int getBlockSize() {
        return this.o;
    }

    public int getKeyBytesSize() {
        return 16;
    }

    public int getIVBytesSize() {
        return 16;
    }

    public static enum PhotonBeetleParameters {
        pb32,
        pb128;

    }
}

