/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.Wrapper;
import com.enterprisedt.bouncycastle.crypto.engines.RC2Engine;
import com.enterprisedt.bouncycastle.crypto.modes.CBCBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.util.DigestFactory;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class RC2WrapEngine
implements Wrapper {
    private CBCBlockCipher c;
    private CipherParameters d;
    private ParametersWithIV e;
    private byte[] f;
    private boolean g;
    private SecureRandom h;
    private static final byte[] i = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    Digest a = DigestFactory.createSHA1();
    byte[] b = new byte[20];

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        this.g = forWrapping;
        this.c = new CBCBlockCipher(new RC2Engine());
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
            this.h = parametersWithRandom.getRandom();
            param = parametersWithRandom.getParameters();
        } else {
            this.h = CryptoServicesRegistrar.getSecureRandom();
        }
        if (param instanceof ParametersWithIV) {
            this.e = (ParametersWithIV)param;
            this.f = this.e.getIV();
            this.d = this.e.getParameters();
            if (!this.g) throw new IllegalArgumentException("You should not supply an IV for unwrapping");
            if (this.f != null && this.f.length == 8) return;
            throw new IllegalArgumentException("IV is not 8 octets");
        }
        this.d = param;
        if (!this.g) return;
        this.f = new byte[8];
        this.h.nextBytes(this.f);
        this.e = new ParametersWithIV(this.d, this.f);
    }

    @Override
    public String getAlgorithmName() {
        return "RC2";
    }

    @Override
    public byte[] wrap(byte[] in, int inOff, int inLen) {
        if (!this.g) {
            throw new IllegalStateException("Not initialized for wrapping");
        }
        int n2 = inLen + 1;
        if (n2 % 8 != 0) {
            n2 += 8 - n2 % 8;
        }
        byte[] byArray = new byte[n2];
        byArray[0] = (byte)inLen;
        System.arraycopy(in, inOff, byArray, 1, inLen);
        byte[] byArray2 = new byte[byArray.length - inLen - 1];
        if (byArray2.length > 0) {
            this.h.nextBytes(byArray2);
            System.arraycopy(byArray2, 0, byArray, inLen + 1, byArray2.length);
        }
        byte[] byArray3 = this.a(byArray);
        byte[] byArray4 = new byte[byArray.length + byArray3.length];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        System.arraycopy(byArray3, 0, byArray4, byArray.length, byArray3.length);
        byte[] byArray5 = new byte[byArray4.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        int n3 = byArray4.length / this.c.getBlockSize();
        int n4 = byArray4.length % this.c.getBlockSize();
        if (n4 != 0) {
            throw new IllegalStateException("Not multiple of block length");
        }
        this.c.init(true, this.e);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = i2 * this.c.getBlockSize();
            this.c.processBlock(byArray5, n5, byArray5, n5);
        }
        byte[] byArray6 = new byte[this.f.length + byArray5.length];
        System.arraycopy(this.f, 0, byArray6, 0, this.f.length);
        System.arraycopy(byArray5, 0, byArray6, this.f.length, byArray5.length);
        byte[] byArray7 = new byte[byArray6.length];
        for (int i3 = 0; i3 < byArray6.length; ++i3) {
            byArray7[i3] = byArray6[byArray6.length - (i3 + 1)];
        }
        ParametersWithIV parametersWithIV = new ParametersWithIV(this.d, i);
        this.c.init(true, parametersWithIV);
        for (int i4 = 0; i4 < n3 + 1; ++i4) {
            int n6 = i4 * this.c.getBlockSize();
            this.c.processBlock(byArray7, n6, byArray7, n6);
        }
        return byArray7;
    }

    @Override
    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int n2;
        if (this.g) {
            throw new IllegalStateException("Not set for unwrapping");
        }
        if (in == null) {
            throw new InvalidCipherTextException("Null pointer as ciphertext");
        }
        if (inLen % this.c.getBlockSize() != 0) {
            throw new InvalidCipherTextException("Ciphertext not multiple of " + this.c.getBlockSize());
        }
        ParametersWithIV parametersWithIV = new ParametersWithIV(this.d, i);
        this.c.init(false, parametersWithIV);
        byte[] byArray = new byte[inLen];
        System.arraycopy(in, inOff, byArray, 0, inLen);
        for (int i2 = 0; i2 < byArray.length / this.c.getBlockSize(); ++i2) {
            n2 = i2 * this.c.getBlockSize();
            this.c.processBlock(byArray, n2, byArray, n2);
        }
        byte[] byArray2 = new byte[byArray.length];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            byArray2[n2] = byArray[byArray.length - (n2 + 1)];
        }
        this.f = new byte[8];
        byte[] byArray3 = new byte[byArray2.length - 8];
        System.arraycopy(byArray2, 0, this.f, 0, 8);
        System.arraycopy(byArray2, 8, byArray3, 0, byArray2.length - 8);
        this.e = new ParametersWithIV(this.d, this.f);
        this.c.init(false, this.e);
        byte[] byArray4 = new byte[byArray3.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        for (int i3 = 0; i3 < byArray4.length / this.c.getBlockSize(); ++i3) {
            int n3 = i3 * this.c.getBlockSize();
            this.c.processBlock(byArray4, n3, byArray4, n3);
        }
        byte[] byArray5 = new byte[byArray4.length - 8];
        byte[] byArray6 = new byte[8];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length - 8);
        System.arraycopy(byArray4, byArray4.length - 8, byArray6, 0, 8);
        if (!this.a(byArray5, byArray6)) {
            throw new InvalidCipherTextException("Checksum inside ciphertext is corrupted");
        }
        if (byArray5.length - ((byArray5[0] & 0xFF) + 1) > 7) {
            throw new InvalidCipherTextException("too many pad bytes (" + (byArray5.length - ((byArray5[0] & 0xFF) + 1)) + ")");
        }
        byte[] byArray7 = new byte[byArray5[0]];
        System.arraycopy(byArray5, 1, byArray7, 0, byArray7.length);
        return byArray7;
    }

    private byte[] a(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        this.a.update(byArray, 0, byArray.length);
        this.a.doFinal(this.b, 0);
        System.arraycopy(this.b, 0, byArray2, 0, 8);
        return byArray2;
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        return Arrays.constantTimeAreEqual(this.a(byArray), byArray2);
    }
}

