/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.Wrapper;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.util.Arrays;

public class RFC3394WrapEngine
implements Wrapper {
    private static final byte[] a = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
    private final BlockCipher b;
    private final boolean c;
    private final byte[] d = new byte[8];
    private KeyParameter e = null;
    private boolean f = true;

    public RFC3394WrapEngine(BlockCipher engine) {
        this(engine, false);
    }

    public RFC3394WrapEngine(BlockCipher engine, boolean useReverseDirection) {
        this.b = engine;
        this.c = !useReverseDirection;
    }

    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        this.f = forWrapping;
        if (param instanceof ParametersWithRandom) {
            param = ((ParametersWithRandom)param).getParameters();
        }
        if (param instanceof KeyParameter) {
            this.e = (KeyParameter)param;
            System.arraycopy(a, 0, this.d, 0, 8);
        } else if (param instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)param;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length != 8) {
                throw new IllegalArgumentException("IV not equal to 8");
            }
            this.e = (KeyParameter)parametersWithIV.getParameters();
            System.arraycopy(byArray, 0, this.d, 0, 8);
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.b.getAlgorithmName();
    }

    @Override
    public byte[] wrap(byte[] in, int inOff, int inLen) {
        if (!this.f) {
            throw new IllegalStateException("not set for wrapping");
        }
        if (inLen < 8) {
            throw new DataLengthException("wrap data must be at least 8 bytes");
        }
        int n2 = inLen / 8;
        if (n2 * 8 != inLen) {
            throw new DataLengthException("wrap data must be a multiple of 8 bytes");
        }
        this.b.init(this.c, this.e);
        byte[] byArray = new byte[inLen + this.d.length];
        System.arraycopy(this.d, 0, byArray, 0, this.d.length);
        System.arraycopy(in, inOff, byArray, this.d.length, inLen);
        if (n2 == 1) {
            this.b.processBlock(byArray, 0, byArray, 0);
        } else {
            byte[] byArray2 = new byte[8 + this.d.length];
            for (int i2 = 0; i2 != 6; ++i2) {
                for (int i3 = 1; i3 <= n2; ++i3) {
                    System.arraycopy(byArray, 0, byArray2, 0, this.d.length);
                    System.arraycopy(byArray, 8 * i3, byArray2, this.d.length, 8);
                    this.b.processBlock(byArray2, 0, byArray2, 0);
                    int n3 = n2 * i2 + i3;
                    int n4 = 1;
                    while (n3 != 0) {
                        byte by = (byte)n3;
                        int n5 = this.d.length - n4;
                        byArray2[n5] = (byte)(byArray2[n5] ^ by);
                        n3 >>>= 8;
                        ++n4;
                    }
                    System.arraycopy(byArray2, 0, byArray, 0, 8);
                    System.arraycopy(byArray2, 8, byArray, 8 * i3, 8);
                }
            }
        }
        return byArray;
    }

    @Override
    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.f) {
            throw new IllegalStateException("not set for unwrapping");
        }
        if (inLen < 16) {
            throw new InvalidCipherTextException("unwrap data too short");
        }
        int n6 = inLen / 8;
        if (n6 * 8 != inLen) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        this.b.init(!this.c, this.e);
        byte[] byArray = new byte[inLen - this.d.length];
        byte[] byArray2 = new byte[this.d.length];
        byte[] byArray3 = new byte[8 + this.d.length];
        if (--n6 == 1) {
            this.b.processBlock(in, inOff, byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, 0, this.d.length);
            System.arraycopy(byArray3, this.d.length, byArray, 0, 8);
        } else {
            System.arraycopy(in, inOff, byArray2, 0, this.d.length);
            System.arraycopy(in, inOff + this.d.length, byArray, 0, inLen - this.d.length);
            for (n5 = 5; n5 >= 0; --n5) {
                for (n4 = n6; n4 >= 1; --n4) {
                    System.arraycopy(byArray2, 0, byArray3, 0, this.d.length);
                    System.arraycopy(byArray, 8 * (n4 - 1), byArray3, this.d.length, 8);
                    n3 = n6 * n5 + n4;
                    n2 = 1;
                    while (n3 != 0) {
                        byte by = (byte)n3;
                        int n7 = this.d.length - n2;
                        byArray3[n7] = (byte)(byArray3[n7] ^ by);
                        n3 >>>= 8;
                        ++n2;
                    }
                    this.b.processBlock(byArray3, 0, byArray3, 0);
                    System.arraycopy(byArray3, 0, byArray2, 0, 8);
                    System.arraycopy(byArray3, 8, byArray, 8 * (n4 - 1), 8);
                }
            }
        }
        if (n6 != 1) {
            if (!Arrays.constantTimeAreEqual(byArray2, this.d)) {
                throw new InvalidCipherTextException("checksum failed");
            }
        } else if (!Arrays.constantTimeAreEqual(byArray2, this.d)) {
            System.arraycopy(in, inOff, byArray2, 0, this.d.length);
            System.arraycopy(in, inOff + this.d.length, byArray, 0, inLen - this.d.length);
            for (n5 = 5; n5 >= 0; --n5) {
                System.arraycopy(byArray2, 0, byArray3, 0, this.d.length);
                System.arraycopy(byArray, 0, byArray3, this.d.length, 8);
                n4 = n6 * n5 + 1;
                n3 = 1;
                while (n4 != 0) {
                    n2 = (byte)n4;
                    int n8 = this.d.length - n3;
                    byArray3[n8] = (byte)(byArray3[n8] ^ n2);
                    n4 >>>= 8;
                    ++n3;
                }
                this.b.processBlock(byArray3, 0, byArray3, 0);
                System.arraycopy(byArray3, 0, byArray2, 0, 8);
                System.arraycopy(byArray3, 8, byArray, 0, 8);
            }
            if (!Arrays.constantTimeAreEqual(byArray2, this.d)) {
                throw new InvalidCipherTextException("checksum failed");
            }
        }
        return byArray;
    }
}

