/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.engines.b;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSABlindedEngine
implements AsymmetricBlockCipher {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private b b = new b();
    private RSAKeyParameters c;
    private SecureRandom d;

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        this.b.a(forEncryption, param);
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
            this.c = (RSAKeyParameters)parametersWithRandom.getParameters();
            this.d = this.c instanceof RSAPrivateCrtKeyParameters ? parametersWithRandom.getRandom() : null;
        } else {
            this.c = (RSAKeyParameters)param;
            this.d = this.c instanceof RSAPrivateCrtKeyParameters ? CryptoServicesRegistrar.getSecureRandom() : null;
        }
    }

    @Override
    public int getInputBlockSize() {
        return this.b.a();
    }

    @Override
    public int getOutputBlockSize() {
        return this.b.b();
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        if (this.c == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        BigInteger bigInteger = this.b.a(in, inOff, inLen);
        BigInteger bigInteger2 = this.a(bigInteger);
        return this.b.a(bigInteger2);
    }

    private BigInteger a(BigInteger bigInteger) {
        RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters;
        BigInteger bigInteger2;
        if (this.c instanceof RSAPrivateCrtKeyParameters && (bigInteger2 = (rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)this.c).getPublicExponent()) != null) {
            BigInteger bigInteger3 = rSAPrivateCrtKeyParameters.getModulus();
            BigInteger bigInteger4 = BigIntegers.createRandomInRange(a, bigInteger3.subtract(a), this.d);
            BigInteger bigInteger5 = bigInteger4.modPow(bigInteger2, bigInteger3);
            BigInteger bigInteger6 = BigIntegers.modOddInverse(bigInteger3, bigInteger4);
            BigInteger bigInteger7 = bigInteger5.multiply(bigInteger).mod(bigInteger3);
            BigInteger bigInteger8 = this.b.b(bigInteger7);
            return bigInteger6.multiply(bigInteger8).mod(bigInteger3);
        }
        return this.b.b(bigInteger);
    }
}

