/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.constraints.ConstraintUtils;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.digests.SM3Digest;
import com.enterprisedt.bouncycastle.crypto.engines.c;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import com.enterprisedt.bouncycastle.util.Bytes;
import com.enterprisedt.bouncycastle.util.Memoable;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SM2Engine {
    private final Digest a;
    private final Mode b;
    private boolean c;
    private ECKeyParameters d;
    private ECDomainParameters e;
    private int f;
    private SecureRandom g;

    public SM2Engine() {
        this(new SM3Digest());
    }

    public SM2Engine(Mode mode) {
        this(new SM3Digest(), mode);
    }

    public SM2Engine(Digest digest) {
        this(digest, Mode.C1C2C3);
    }

    public SM2Engine(Digest digest, Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode cannot be NULL");
        }
        this.a = digest;
        this.b = mode;
    }

    public void init(boolean forEncryption, CipherParameters param) {
        this.c = forEncryption;
        if (forEncryption) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
            this.d = (ECKeyParameters)parametersWithRandom.getParameters();
            this.e = this.d.getParameters();
            ECPoint eCPoint = ((ECPublicKeyParameters)this.d).getQ().multiply(this.e.getH());
            if (eCPoint.isInfinity()) {
                throw new IllegalArgumentException("invalid key: [h]Q at infinity");
            }
            this.g = parametersWithRandom.getRandom();
        } else {
            this.d = (ECKeyParameters)param;
            this.e = this.d.getParameters();
        }
        this.f = (this.e.getCurve().getFieldSize() + 7) / 8;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("SM2", ConstraintUtils.bitsOfSecurityFor(this.e.getCurve()), this.d, com.enterprisedt.bouncycastle.crypto.engines.c.a(forEncryption)));
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (inOff + inLen > in.length || inLen == 0) {
            throw new DataLengthException("input buffer too short");
        }
        if (this.c) {
            return this.a(in, inOff, inLen);
        }
        return this.b(in, inOff, inLen);
    }

    public int getOutputSize(int inputLen) {
        return 1 + 2 * this.f + inputLen + this.a.getDigestSize();
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    private byte[] a(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        ECPoint eCPoint;
        byte[] byArray2;
        Object object;
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n2, byArray3, 0, byArray3.length);
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        do {
            object = this.a();
            ECPoint eCPoint2 = eCMultiplier.multiply(this.e.getG(), (BigInteger)object).normalize();
            byArray2 = eCPoint2.getEncoded(false);
            eCPoint = ((ECPublicKeyParameters)this.d).getQ().multiply((BigInteger)object).normalize();
            this.a(this.a, eCPoint, byArray3);
        } while (this.a(byArray3, byArray, n2));
        object = new byte[this.a.getDigestSize()];
        this.a(this.a, eCPoint.getAffineXCoord());
        this.a.update(byArray, n2, n3);
        this.a(this.a, eCPoint.getAffineYCoord());
        this.a.doFinal((byte[])object, 0);
        switch (this.b) {
            case C1C3C2: {
                return Arrays.concatenate(byArray2, (byte[])object, byArray3);
            }
        }
        return Arrays.concatenate(byArray2, byArray3, (byte[])object);
    }

    private byte[] b(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte[] byArray2 = new byte[this.f * 2 + 1];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        ECPoint eCPoint = this.e.getCurve().decodePoint(byArray2);
        ECPoint eCPoint2 = eCPoint.multiply(this.e.getH());
        if (eCPoint2.isInfinity()) {
            throw new InvalidCipherTextException("[h]C1 at infinity");
        }
        eCPoint = eCPoint.multiply(((ECPrivateKeyParameters)this.d).getD()).normalize();
        int n4 = this.a.getDigestSize();
        byte[] byArray3 = new byte[n3 - byArray2.length - n4];
        if (this.b == Mode.C1C3C2) {
            System.arraycopy(byArray, n2 + byArray2.length + n4, byArray3, 0, byArray3.length);
        } else {
            System.arraycopy(byArray, n2 + byArray2.length, byArray3, 0, byArray3.length);
        }
        this.a(this.a, eCPoint, byArray3);
        byte[] byArray4 = new byte[this.a.getDigestSize()];
        this.a(this.a, eCPoint.getAffineXCoord());
        this.a.update(byArray3, 0, byArray3.length);
        this.a(this.a, eCPoint.getAffineYCoord());
        this.a.doFinal(byArray4, 0);
        int n5 = 0;
        if (this.b == Mode.C1C3C2) {
            for (int i2 = 0; i2 != byArray4.length; ++i2) {
                n5 |= byArray4[i2] ^ byArray[n2 + byArray2.length + i2];
            }
        } else {
            for (int i3 = 0; i3 != byArray4.length; ++i3) {
                n5 |= byArray4[i3] ^ byArray[n2 + byArray2.length + byArray3.length + i3];
            }
        }
        Arrays.fill(byArray2, (byte)0);
        Arrays.fill(byArray4, (byte)0);
        if (n5 != 0) {
            Arrays.fill(byArray3, (byte)0);
            throw new InvalidCipherTextException("invalid cipher text");
        }
        return byArray3;
    }

    private boolean a(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            if (byArray[i2] == byArray2[n2 + i2]) continue;
            return false;
        }
        return true;
    }

    private void a(Digest digest, ECPoint eCPoint, byte[] byArray) {
        int n2 = digest.getDigestSize();
        byte[] byArray2 = new byte[Math.max(4, n2)];
        int n3 = 0;
        Memoable memoable = null;
        Memoable memoable2 = null;
        if (digest instanceof Memoable) {
            this.a(digest, eCPoint.getAffineXCoord());
            this.a(digest, eCPoint.getAffineYCoord());
            memoable = (Memoable)((Object)digest);
            memoable2 = memoable.copy();
        }
        int n4 = 0;
        while (n3 < byArray.length) {
            if (memoable != null) {
                memoable.reset(memoable2);
            } else {
                this.a(digest, eCPoint.getAffineXCoord());
                this.a(digest, eCPoint.getAffineYCoord());
            }
            Pack.intToBigEndian(++n4, byArray2, 0);
            digest.update(byArray2, 0, 4);
            digest.doFinal(byArray2, 0);
            int n5 = Math.min(n2, byArray.length - n3);
            Bytes.xorTo(n5, byArray2, 0, byArray, n3);
            n3 += n5;
        }
    }

    private BigInteger a() {
        BigInteger bigInteger;
        int n2 = this.e.getN().bitLength();
        while ((bigInteger = BigIntegers.createRandomBigInteger(n2, this.g)).equals(BigIntegers.ZERO) || bigInteger.compareTo(this.e.getN()) >= 0) {
        }
        return bigInteger;
    }

    private void a(Digest digest, ECFieldElement eCFieldElement) {
        byte[] byArray = BigIntegers.asUnsignedByteArray(this.f, eCFieldElement.toBigInteger());
        digest.update(byArray, 0, byArray.length);
    }

    public static enum Mode {
        C1C2C3,
        C1C3C2;

    }
}

