/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;

public abstract class SerpentEngineBase
implements BlockCipher {
    protected static final int BLOCK_SIZE = 16;
    protected boolean encrypting;
    protected int[] wKey;
    protected int keyBits;

    SerpentEngineBase() {
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 256));
    }

    @Override
    public void init(boolean encrypting, CipherParameters params) {
        if (params instanceof KeyParameter) {
            this.encrypting = encrypting;
            byte[] byArray = ((KeyParameter)params).getKey();
            this.wKey = this.makeWorkingKey(byArray);
            CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), byArray.length * 8, params, this.a()));
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to " + this.getAlgorithmName() + " init - " + params.getClass().getName());
    }

    @Override
    public String getAlgorithmName() {
        return "Serpent";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public final int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (this.wKey == null) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + 16 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 16 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.encrypting) {
            this.encryptBlock(in, inOff, out, outOff);
        } else {
            this.decryptBlock(in, inOff, out, outOff);
        }
        return 16;
    }

    @Override
    public void reset() {
    }

    protected static int rotateLeft(int x, int bits) {
        return x << bits | x >>> -bits;
    }

    protected static int rotateRight(int x, int bits) {
        return x >>> bits | x << -bits;
    }

    protected final void sb0(int[] X, int a2, int b2, int c2, int d2) {
        int n2 = a2 ^ d2;
        int n3 = c2 ^ n2;
        int n4 = b2 ^ n3;
        X[3] = a2 & d2 ^ n4;
        int n5 = a2 ^ b2 & n2;
        X[2] = n4 ^ (c2 | n5);
        int n6 = X[3] & (n3 ^ n5);
        X[1] = ~n3 ^ n6;
        X[0] = n6 ^ ~n5;
    }

    protected final void ib0(int[] X, int a2, int b2, int c2, int d2) {
        int n2 = ~a2;
        int n3 = a2 ^ b2;
        int n4 = d2 ^ (n2 | n3);
        int n5 = c2 ^ n4;
        X[2] = n3 ^ n5;
        int n6 = n2 ^ d2 & n3;
        X[1] = n4 ^ X[2] & n6;
        X[3] = a2 & n4 ^ (n5 | X[1]);
        X[0] = X[3] ^ (n5 ^ n6);
    }

    protected final void sb1(int[] X, int a2, int b2, int c2, int d2) {
        int n2 = b2 ^ ~a2;
        int n3 = c2 ^ (a2 | n2);
        X[2] = d2 ^ n3;
        int n4 = b2 ^ (d2 | n2);
        int n5 = n2 ^ X[2];
        X[3] = n5 ^ n3 & n4;
        int n6 = n3 ^ n4;
        X[1] = X[3] ^ n6;
        X[0] = n3 ^ n5 & n6;
    }

    protected final void ib1(int[] X, int a2, int b2, int c2, int d2) {
        int n2 = b2 ^ d2;
        int n3 = a2 ^ b2 & n2;
        int n4 = n2 ^ n3;
        X[3] = c2 ^ n4;
        int n5 = b2 ^ n2 & n3;
        int n6 = X[3] | n5;
        X[1] = n3 ^ n6;
        int n7 = ~X[1];
        int n8 = X[3] ^ n5;
        X[0] = n7 ^ n8;
        X[2] = n4 ^ (n7 | n8);
    }

    protected final void sb2(int[] X, int a2, int b2, int c2, int d2) {
        int n2 = ~a2;
        int n3 = b2 ^ d2;
        int n4 = c2 & n2;
        X[0] = n3 ^ n4;
        int n5 = c2 ^ n2;
        int n6 = c2 ^ X[0];
        int n7 = b2 & n6;
        X[3] = n5 ^ n7;
        X[2] = a2 ^ (d2 | n7) & (X[0] | n5);
        X[1] = n3 ^ X[3] ^ (X[2] ^ (d2 | n2));
    }

    protected final void ib2(int[] X, int a2, int b2, int c2, int d2) {
        int n2 = b2 ^ d2;
        int n3 = ~n2;
        int n4 = a2 ^ c2;
        int n5 = c2 ^ n2;
        int n6 = b2 & n5;
        X[0] = n4 ^ n6;
        int n7 = a2 | n3;
        int n8 = d2 ^ n7;
        int n9 = n4 | n8;
        X[3] = n2 ^ n9;
        int n10 = ~n5;
        int n11 = X[0] | X[3];
        X[1] = n10 ^ n11;
        X[2] = d2 & n10 ^ (n4 ^ n11);
    }

    protected final void sb3(int[] X, int a2, int b2, int c2, int d2) {
        int n2 = a2 ^ b2;
        int n3 = a2 & c2;
        int n4 = a2 | d2;
        int n5 = c2 ^ d2;
        int n6 = n2 & n4;
        int n7 = n3 | n6;
        X[2] = n5 ^ n7;
        int n8 = b2 ^ n4;
        int n9 = n7 ^ n8;
        int n10 = n5 & n9;
        X[0] = n2 ^ n10;
        int n11 = X[2] & X[0];
        X[1] = n9 ^ n11;
        X[3] = (b2 | d2) ^ (n5 ^ n11);
    }

    protected final void ib3(int[] X, int a2, int b2, int c2, int d2) {
        int n2 = a2 | b2;
        int n3 = b2 ^ c2;
        int n4 = b2 & n3;
        int n5 = a2 ^ n4;
        int n6 = c2 ^ n5;
        int n7 = d2 | n5;
        X[0] = n3 ^ n7;
        int n8 = n3 | n7;
        int n9 = d2 ^ n8;
        X[2] = n6 ^ n9;
        int n10 = n2 ^ n9;
        int n11 = X[0] & n10;
        X[3] = n5 ^ n11;
        X[1] = X[3] ^ (X[0] ^ n10);
    }

    protected final void sb4(int[] X, int a2, int b2, int c2, int d2) {
        int n2 = a2 ^ d2;
        int n3 = d2 & n2;
        int n4 = c2 ^ n3;
        int n5 = b2 | n4;
        X[3] = n2 ^ n5;
        int n6 = ~b2;
        int n7 = n2 | n6;
        X[0] = n4 ^ n7;
        int n8 = a2 & X[0];
        int n9 = n2 ^ n6;
        int n10 = n5 & n9;
        X[2] = n8 ^ n10;
        X[1] = a2 ^ n4 ^ n9 & X[2];
    }

    protected final void ib4(int[] X, int a2, int b2, int c2, int d2) {
        int n2 = c2 | d2;
        int n3 = a2 & n2;
        int n4 = b2 ^ n3;
        int n5 = a2 & n4;
        int n6 = c2 ^ n5;
        X[1] = d2 ^ n6;
        int n7 = ~a2;
        int n8 = n6 & X[1];
        X[3] = n4 ^ n8;
        int n9 = X[1] | n7;
        int n10 = d2 ^ n9;
        X[0] = X[3] ^ n10;
        X[2] = n4 & n10 ^ (X[1] ^ n7);
    }

    protected final void sb5(int[] X, int a2, int b2, int c2, int d2) {
        int n2 = ~a2;
        int n3 = a2 ^ b2;
        int n4 = a2 ^ d2;
        int n5 = c2 ^ n2;
        int n6 = n3 | n4;
        X[0] = n5 ^ n6;
        int n7 = d2 & X[0];
        int n8 = n3 ^ X[0];
        X[1] = n7 ^ n8;
        int n9 = n2 | X[0];
        int n10 = n3 | n7;
        int n11 = n4 ^ n9;
        X[2] = n10 ^ n11;
        X[3] = b2 ^ n7 ^ X[1] & n11;
    }

    protected final void ib5(int[] X, int a2, int b2, int c2, int d2) {
        int n2 = ~c2;
        int n3 = b2 & n2;
        int n4 = d2 ^ n3;
        int n5 = a2 & n4;
        int n6 = b2 ^ n2;
        X[3] = n5 ^ n6;
        int n7 = b2 | X[3];
        int n8 = a2 & n7;
        X[1] = n4 ^ n8;
        int n9 = a2 | d2;
        int n10 = n2 ^ n7;
        X[0] = n9 ^ n10;
        X[2] = b2 & n9 ^ (n5 | a2 ^ c2);
    }

    protected final void sb6(int[] X, int a2, int b2, int c2, int d2) {
        int n2 = ~a2;
        int n3 = a2 ^ d2;
        int n4 = b2 ^ n3;
        int n5 = n2 | n3;
        int n6 = c2 ^ n5;
        X[1] = b2 ^ n6;
        int n7 = n3 | X[1];
        int n8 = d2 ^ n7;
        int n9 = n6 & n8;
        X[2] = n4 ^ n9;
        int n10 = n6 ^ n8;
        X[0] = X[2] ^ n10;
        X[3] = ~n6 ^ n4 & n10;
    }

    protected final void ib6(int[] X, int a2, int b2, int c2, int d2) {
        int n2 = ~a2;
        int n3 = a2 ^ b2;
        int n4 = c2 ^ n3;
        int n5 = c2 | n2;
        int n6 = d2 ^ n5;
        X[1] = n4 ^ n6;
        int n7 = n4 & n6;
        int n8 = n3 ^ n7;
        int n9 = b2 | n8;
        X[3] = n6 ^ n9;
        int n10 = b2 | X[3];
        X[0] = n8 ^ n10;
        X[2] = d2 & n2 ^ (n4 ^ n10);
    }

    protected final void sb7(int[] X, int a2, int b2, int c2, int d2) {
        int n2 = b2 ^ c2;
        int n3 = c2 & n2;
        int n4 = d2 ^ n3;
        int n5 = a2 ^ n4;
        int n6 = d2 | n2;
        int n7 = n5 & n6;
        X[1] = b2 ^ n7;
        int n8 = n4 | X[1];
        int n9 = a2 & n5;
        X[3] = n2 ^ n9;
        int n10 = n5 ^ n8;
        int n11 = X[3] & n10;
        X[2] = n4 ^ n11;
        X[0] = ~n10 ^ X[3] & X[2];
    }

    protected final void ib7(int[] X, int a2, int b2, int c2, int d2) {
        int n2 = c2 | a2 & b2;
        int n3 = d2 & (a2 | b2);
        X[3] = n2 ^ n3;
        int n4 = ~d2;
        int n5 = b2 ^ n3;
        int n6 = n5 | X[3] ^ n4;
        X[1] = a2 ^ n6;
        X[0] = c2 ^ n5 ^ (d2 | X[1]);
        X[2] = n2 ^ X[1] ^ (X[0] ^ a2 & X[3]);
    }

    protected final void LT(int[] X) {
        int n2 = SerpentEngineBase.rotateLeft(X[0], 13);
        int n3 = SerpentEngineBase.rotateLeft(X[2], 3);
        int n4 = X[1] ^ n2 ^ n3;
        int n5 = X[3] ^ n3 ^ n2 << 3;
        X[1] = SerpentEngineBase.rotateLeft(n4, 1);
        X[3] = SerpentEngineBase.rotateLeft(n5, 7);
        X[0] = SerpentEngineBase.rotateLeft(n2 ^ X[1] ^ X[3], 5);
        X[2] = SerpentEngineBase.rotateLeft(n3 ^ X[3] ^ X[1] << 7, 22);
    }

    protected final void inverseLT(int[] X) {
        int n2 = SerpentEngineBase.rotateRight(X[2], 22) ^ X[3] ^ X[1] << 7;
        int n3 = SerpentEngineBase.rotateRight(X[0], 5) ^ X[1] ^ X[3];
        int n4 = SerpentEngineBase.rotateRight(X[3], 7);
        int n5 = SerpentEngineBase.rotateRight(X[1], 1);
        X[3] = n4 ^ n2 ^ n3 << 3;
        X[1] = n5 ^ n3 ^ n2;
        X[2] = SerpentEngineBase.rotateRight(n2, 3);
        X[0] = SerpentEngineBase.rotateRight(n3, 13);
    }

    protected abstract int[] makeWorkingKey(byte[] var1);

    protected abstract void encryptBlock(byte[] var1, int var2, byte[] var3, int var4);

    protected abstract void decryptBlock(byte[] var1, int var2, byte[] var3, int var4);

    private CryptoServicePurpose a() {
        if (this.wKey == null) {
            return CryptoServicePurpose.ANY;
        }
        return this.encrypting ? CryptoServicePurpose.ENCRYPTION : CryptoServicePurpose.DECRYPTION;
    }
}

