/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;

public class SkipjackEngine
implements BlockCipher {
    static short[] a = new short[]{163, 215, 9, 131, 248, 72, 246, 244, 179, 33, 21, 120, 153, 177, 175, 249, 231, 45, 77, 138, 206, 76, 202, 46, 82, 149, 217, 30, 78, 56, 68, 40, 10, 223, 2, 160, 23, 241, 96, 104, 18, 183, 122, 195, 233, 250, 61, 83, 150, 132, 107, 186, 242, 99, 154, 25, 124, 174, 229, 245, 247, 22, 106, 162, 57, 182, 123, 15, 193, 147, 129, 27, 238, 180, 26, 234, 208, 145, 47, 184, 85, 185, 218, 133, 63, 65, 191, 224, 90, 88, 128, 95, 102, 11, 216, 144, 53, 213, 192, 167, 51, 6, 101, 105, 69, 0, 148, 86, 109, 152, 155, 118, 151, 252, 178, 194, 176, 254, 219, 32, 225, 235, 214, 228, 221, 71, 74, 29, 66, 237, 158, 110, 73, 60, 205, 67, 39, 210, 7, 212, 222, 199, 103, 24, 137, 203, 48, 31, 141, 198, 143, 170, 200, 116, 220, 201, 93, 92, 49, 164, 112, 136, 97, 44, 159, 13, 43, 135, 80, 130, 84, 100, 38, 125, 3, 64, 52, 75, 28, 115, 209, 196, 253, 59, 204, 251, 127, 171, 230, 62, 91, 165, 173, 4, 35, 156, 20, 81, 34, 240, 41, 121, 113, 126, 255, 140, 14, 226, 12, 239, 188, 114, 117, 111, 55, 161, 236, 211, 142, 98, 139, 134, 16, 232, 8, 119, 17, 190, 146, 79, 36, 197, 50, 54, 157, 207, 243, 166, 187, 172, 94, 108, 169, 19, 87, 37, 181, 227, 189, 168, 58, 1, 5, 89, 42, 70};
    private int[] b;
    private int[] c;
    private int[] d;
    private int[] e;
    private boolean f;

    public SkipjackEngine() {
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 80));
    }

    @Override
    public void init(boolean encrypting, CipherParameters params) {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to SKIPJACK init - " + params.getClass().getName());
        }
        byte[] byArray = ((KeyParameter)params).getKey();
        this.f = encrypting;
        this.b = new int[32];
        this.c = new int[32];
        this.d = new int[32];
        this.e = new int[32];
        for (int i2 = 0; i2 < 32; ++i2) {
            this.b[i2] = byArray[i2 * 4 % 10] & 0xFF;
            this.c[i2] = byArray[(i2 * 4 + 1) % 10] & 0xFF;
            this.d[i2] = byArray[(i2 * 4 + 2) % 10] & 0xFF;
            this.e[i2] = byArray[(i2 * 4 + 3) % 10] & 0xFF;
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 80, params, this.a()));
    }

    @Override
    public String getAlgorithmName() {
        return "SKIPJACK";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (this.c == null) {
            throw new IllegalStateException("SKIPJACK engine not initialised");
        }
        if (inOff + 8 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 8 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.f) {
            this.encryptBlock(in, inOff, out, outOff);
        } else {
            this.decryptBlock(in, inOff, out, outOff);
        }
        return 8;
    }

    @Override
    public void reset() {
    }

    private int a(int n2, int n3) {
        int n4 = n3 >> 8 & 0xFF;
        int n5 = n3 & 0xFF;
        int n6 = a[n5 ^ this.b[n2]] ^ n4;
        int n7 = a[n6 ^ this.c[n2]] ^ n5;
        int n8 = a[n7 ^ this.d[n2]] ^ n6;
        int n9 = a[n8 ^ this.e[n2]] ^ n7;
        return (n8 << 8) + n9;
    }

    public int encryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        int n2 = (in[inOff + 0] << 8) + (in[inOff + 1] & 0xFF);
        int n3 = (in[inOff + 2] << 8) + (in[inOff + 3] & 0xFF);
        int n4 = (in[inOff + 4] << 8) + (in[inOff + 5] & 0xFF);
        int n5 = (in[inOff + 6] << 8) + (in[inOff + 7] & 0xFF);
        int n6 = 0;
        for (int i2 = 0; i2 < 2; ++i2) {
            int n7;
            int n8;
            for (n8 = 0; n8 < 8; ++n8) {
                n7 = n5;
                n5 = n4;
                n4 = n3;
                n3 = this.a(n6, n2);
                n2 = n3 ^ n7 ^ n6 + 1;
                ++n6;
            }
            for (n8 = 0; n8 < 8; ++n8) {
                n7 = n5;
                n5 = n4;
                n4 = n2 ^ n3 ^ n6 + 1;
                n3 = this.a(n6, n2);
                n2 = n7;
                ++n6;
            }
        }
        out[outOff + 0] = (byte)(n2 >> 8);
        out[outOff + 1] = (byte)n2;
        out[outOff + 2] = (byte)(n3 >> 8);
        out[outOff + 3] = (byte)n3;
        out[outOff + 4] = (byte)(n4 >> 8);
        out[outOff + 5] = (byte)n4;
        out[outOff + 6] = (byte)(n5 >> 8);
        out[outOff + 7] = (byte)n5;
        return 8;
    }

    private int b(int n2, int n3) {
        int n4 = n3 & 0xFF;
        int n5 = n3 >> 8 & 0xFF;
        int n6 = a[n5 ^ this.e[n2]] ^ n4;
        int n7 = a[n6 ^ this.d[n2]] ^ n5;
        int n8 = a[n7 ^ this.c[n2]] ^ n6;
        int n9 = a[n8 ^ this.b[n2]] ^ n7;
        return (n9 << 8) + n8;
    }

    public int decryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        int n2 = (in[inOff + 0] << 8) + (in[inOff + 1] & 0xFF);
        int n3 = (in[inOff + 2] << 8) + (in[inOff + 3] & 0xFF);
        int n4 = (in[inOff + 4] << 8) + (in[inOff + 5] & 0xFF);
        int n5 = (in[inOff + 6] << 8) + (in[inOff + 7] & 0xFF);
        int n6 = 31;
        for (int i2 = 0; i2 < 2; ++i2) {
            int n7;
            int n8;
            for (n8 = 0; n8 < 8; ++n8) {
                n7 = n4;
                n4 = n5;
                n5 = n2;
                n2 = this.b(n6, n3);
                n3 = n2 ^ n7 ^ n6 + 1;
                --n6;
            }
            for (n8 = 0; n8 < 8; ++n8) {
                n7 = n4;
                n4 = n5;
                n5 = n3 ^ n2 ^ n6 + 1;
                n2 = this.b(n6, n3);
                n3 = n7;
                --n6;
            }
        }
        out[outOff + 0] = (byte)(n2 >> 8);
        out[outOff + 1] = (byte)n2;
        out[outOff + 2] = (byte)(n3 >> 8);
        out[outOff + 3] = (byte)n3;
        out[outOff + 4] = (byte)(n4 >> 8);
        out[outOff + 5] = (byte)n4;
        out[outOff + 6] = (byte)(n5 >> 8);
        out[outOff + 7] = (byte)n5;
        return 8;
    }

    private CryptoServicePurpose a() {
        if (this.b == null) {
            return CryptoServicePurpose.ANY;
        }
        return this.f ? CryptoServicePurpose.ENCRYPTION : CryptoServicePurpose.DECRYPTION;
    }
}

