/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.digests.SparkleDigest;
import com.enterprisedt.bouncycastle.crypto.engines.c;
import com.enterprisedt.bouncycastle.crypto.modes.AEADCipher;
import com.enterprisedt.bouncycastle.crypto.params.AEADParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Integers;
import com.enterprisedt.bouncycastle.util.Pack;

public class SparkleEngine
implements AEADCipher {
    private static final int[] a = new int[]{-1209970334, -1083090816, 951376470, 844003128, -1156479509, 1333558103, -809524792, -1028445891};
    private String b;
    private final int[] c;
    private final int[] d;
    private final int[] e;
    private byte[] f;
    private boolean g;
    private a h = com.enterprisedt.bouncycastle.crypto.engines.SparkleEngine$a.a;
    private byte[] i;
    private final int j;
    private final byte[] k;
    private int l = 0;
    private final int m;
    private final int n;
    private final int o;
    private final int p;
    private final int q;
    private final int r;
    private final int s;
    private final int t;
    private final int u;
    private final int v;
    private final int w;
    private final int x;
    private final int y;
    private final int z;
    private final int A;
    private final int B;

    public SparkleEngine(SparkleParameters sparkleParameters) {
        int n2;
        int n3;
        int n4;
        switch (sparkleParameters) {
            case SCHWAEMM128_128: {
                this.m = 128;
                this.n = 128;
                n4 = 128;
                n3 = 256;
                n2 = 128;
                this.o = 7;
                this.p = 10;
                this.b = "SCHWAEMM128-128";
                break;
            }
            case SCHWAEMM256_128: {
                this.m = 128;
                this.n = 256;
                n4 = 128;
                n3 = 384;
                n2 = 128;
                this.o = 7;
                this.p = 11;
                this.b = "SCHWAEMM256-128";
                break;
            }
            case SCHWAEMM192_192: {
                this.m = 192;
                this.n = 192;
                n4 = 192;
                n3 = 384;
                n2 = 192;
                this.o = 7;
                this.p = 11;
                this.b = "SCHWAEMM192-192";
                break;
            }
            case SCHWAEMM256_256: {
                this.m = 256;
                this.n = 256;
                n4 = 256;
                n3 = 512;
                n2 = 256;
                this.o = 8;
                this.p = 12;
                this.b = "SCHWAEMM256-256";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid definition of SCHWAEMM instance");
            }
        }
        this.q = this.m >>> 5;
        this.r = this.m >>> 3;
        this.s = n4 >>> 5;
        this.t = n4 >>> 3;
        this.u = n3 >>> 5;
        this.v = this.n >>> 5;
        this.w = this.n >>> 3;
        int n5 = n2 >>> 6;
        int n6 = n2 >>> 5;
        this.x = this.v > n6 ? n6 - 1 : -1;
        this.y = 1 << n5 << 24;
        this.z = (1 ^ 1 << n5) << 24;
        this.A = (2 ^ 1 << n5) << 24;
        this.B = (3 ^ 1 << n5) << 24;
        this.c = new int[this.u];
        this.d = new int[this.q];
        this.e = new int[this.v];
        this.j = this.w + this.t;
        this.k = new byte[this.j];
    }

    public int getKeyBytesSize() {
        return this.r;
    }

    public int getIVBytesSize() {
        return this.w;
    }

    @Override
    public String getAlgorithmName() {
        return this.b;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        int n2;
        byte[] byArray;
        CipherParameters cipherParameters;
        KeyParameter keyParameter = null;
        if (params instanceof AEADParameters) {
            cipherParameters = (AEADParameters)params;
            keyParameter = ((AEADParameters)cipherParameters).getKey();
            byArray = ((AEADParameters)cipherParameters).getNonce();
            this.i = ((AEADParameters)cipherParameters).getAssociatedText();
            n2 = ((AEADParameters)cipherParameters).getMacSize();
            if (n2 != this.t * 8) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + n2);
            }
        } else if (params instanceof ParametersWithIV) {
            cipherParameters = (ParametersWithIV)params;
            CipherParameters cipherParameters2 = ((ParametersWithIV)cipherParameters).getParameters();
            if (cipherParameters2 instanceof KeyParameter) {
                keyParameter = (KeyParameter)cipherParameters2;
            }
            byArray = ((ParametersWithIV)cipherParameters).getIV();
            this.i = null;
        } else {
            throw new IllegalArgumentException("invalid parameters passed to Sparkle");
        }
        if (keyParameter == null) {
            throw new IllegalArgumentException("Sparkle init parameters must include a key");
        }
        int n3 = this.q * 4;
        if (n3 != keyParameter.getKeyLength()) {
            throw new IllegalArgumentException(this.b + " requires exactly " + n3 + " bytes of key");
        }
        n2 = this.v * 4;
        if (byArray == null || n2 != byArray.length) {
            throw new IllegalArgumentException(this.b + " requires exactly " + n2 + " bytes of IV");
        }
        Pack.littleEndianToInt(keyParameter.getKey(), 0, this.d);
        Pack.littleEndianToInt(byArray, 0, this.e);
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, com.enterprisedt.bouncycastle.crypto.engines.c.a(forEncryption)));
        this.h = forEncryption ? com.enterprisedt.bouncycastle.crypto.engines.SparkleEngine$a.b : com.enterprisedt.bouncycastle.crypto.engines.SparkleEngine$a.f;
        this.reset();
    }

    @Override
    public void processAADByte(byte in) {
        this.a();
        if (this.l == this.w) {
            this.a(this.k, 0);
            this.l = 0;
        }
        this.k[this.l++] = in;
    }

    @Override
    public void processAADBytes(byte[] in, int inOff, int len) {
        if (inOff > in.length - len) {
            throw new DataLengthException("input buffer too short");
        }
        if (len <= 0) {
            return;
        }
        this.a();
        if (this.l > 0) {
            int n2 = this.w - this.l;
            if (len <= n2) {
                System.arraycopy(in, inOff, this.k, this.l, len);
                this.l += len;
                return;
            }
            System.arraycopy(in, inOff, this.k, this.l, n2);
            inOff += n2;
            len -= n2;
            this.a(this.k, 0);
        }
        while (len > this.w) {
            this.a(in, inOff);
            inOff += this.w;
            len -= this.w;
        }
        System.arraycopy(in, inOff, this.k, 0, len);
        this.l = len;
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{in}, 0, 1, out, outOff);
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        if (inOff > in.length - len) {
            throw new DataLengthException("input buffer too short");
        }
        boolean bl = this.b();
        int n2 = 0;
        if (bl) {
            if (this.l > 0) {
                int n3 = this.w - this.l;
                if (len <= n3) {
                    System.arraycopy(in, inOff, this.k, this.l, len);
                    this.l += len;
                    return 0;
                }
                System.arraycopy(in, inOff, this.k, this.l, n3);
                inOff += n3;
                len -= n3;
                this.b(this.k, 0, out, outOff);
                n2 = this.w;
            }
            while (len > this.w) {
                this.b(in, inOff, out, outOff + n2);
                inOff += this.w;
                len -= this.w;
                n2 += this.w;
            }
        } else {
            int n4 = this.j - this.l;
            if (len <= n4) {
                System.arraycopy(in, inOff, this.k, this.l, len);
                this.l += len;
                return 0;
            }
            if (this.l > this.w) {
                this.a(this.k, 0, out, outOff);
                this.l -= this.w;
                System.arraycopy(this.k, this.w, this.k, 0, this.l);
                n2 = this.w;
                if (len <= (n4 += this.w)) {
                    System.arraycopy(in, inOff, this.k, this.l, len);
                    this.l += len;
                    return n2;
                }
            }
            n4 = this.w - this.l;
            System.arraycopy(in, inOff, this.k, this.l, n4);
            inOff += n4;
            len -= n4;
            this.a(this.k, 0, out, outOff + n2);
            n2 += this.w;
            while (len > this.j) {
                this.a(in, inOff, out, outOff + n2);
                inOff += this.w;
                len -= this.w;
                n2 += this.w;
            }
        }
        System.arraycopy(in, inOff, this.k, 0, len);
        this.l = len;
        return n2;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int n2;
        boolean bl = this.b();
        if (bl) {
            n2 = this.l + this.t;
        } else {
            if (this.l < this.t) {
                throw new InvalidCipherTextException("data too short");
            }
            this.l -= this.t;
            n2 = this.l;
        }
        if (outOff > out.length - n2) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.g || this.l > 0) {
            int n3;
            int n4 = this.u - 1;
            this.c[n4] = this.c[n4] ^ (this.l < this.w ? this.A : this.B);
            int[] nArray = new int[this.v];
            for (n3 = 0; n3 < this.l; ++n3) {
                int n5 = n3 >>> 2;
                nArray[n5] = nArray[n5] | (this.k[n3] & 0xFF) << ((n3 & 3) << 3);
            }
            if (this.l < this.w) {
                if (!bl) {
                    n3 = (this.l & 3) << 3;
                    int n6 = this.l >>> 2;
                    nArray[n6] = nArray[n6] | this.c[this.l >>> 2] >>> n3 << n3;
                    n3 = (this.l >>> 2) + 1;
                    System.arraycopy(this.c, n3, nArray, n3, this.v - n3);
                }
                int n7 = this.l >>> 2;
                nArray[n7] = nArray[n7] ^ 128 << ((this.l & 3) << 3);
            }
            n3 = 0;
            while (n3 < this.v / 2) {
                int n8 = n3 + this.v / 2;
                int n9 = this.c[n3];
                int n10 = this.c[n8];
                if (bl) {
                    this.c[n3] = n10 ^ nArray[n3] ^ this.c[this.v + n3];
                    this.c[n8] = n9 ^ n10 ^ nArray[n8] ^ this.c[this.v + (n8 & this.x)];
                } else {
                    this.c[n3] = n9 ^ n10 ^ nArray[n3] ^ this.c[this.v + n3];
                    this.c[n8] = n9 ^ nArray[n8] ^ this.c[this.v + (n8 & this.x)];
                }
                int n11 = n3++;
                nArray[n11] = nArray[n11] ^ n9;
                int n12 = n8;
                nArray[n12] = nArray[n12] ^ n10;
            }
            for (n3 = 0; n3 < this.l; ++n3) {
                out[outOff++] = (byte)(nArray[n3 >>> 2] >>> ((n3 & 3) << 3));
            }
            SparkleEngine.d(this.c, this.p);
        }
        for (int i2 = 0; i2 < this.q; ++i2) {
            int n13 = this.v + i2;
            this.c[n13] = this.c[n13] ^ this.d[i2];
        }
        this.f = new byte[this.t];
        Pack.intToLittleEndian(this.c, this.v, this.s, this.f, 0);
        if (bl) {
            System.arraycopy(this.f, 0, out, outOff, this.t);
        } else if (!Arrays.constantTimeAreEqual(this.t, this.f, 0, this.k, this.l)) {
            throw new InvalidCipherTextException(this.b + " mac does not match");
        }
        this.a(!bl);
        return n2;
    }

    @Override
    public byte[] getMac() {
        return this.f;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        int n2 = Math.max(0, len) - 1;
        switch (this.h) {
            case f: 
            case g: {
                n2 = Math.max(0, n2 - this.t);
                break;
            }
            case h: 
            case i: {
                n2 = Math.max(0, n2 + this.l - this.t);
                break;
            }
            case d: 
            case e: {
                n2 = Math.max(0, n2 + this.l);
                break;
            }
        }
        return n2 - n2 % this.w;
    }

    @Override
    public int getOutputSize(int len) {
        int n2 = Math.max(0, len);
        switch (this.h) {
            case f: 
            case g: {
                return Math.max(0, n2 - this.t);
            }
            case h: 
            case i: {
                return Math.max(0, n2 + this.l - this.t);
            }
            case d: 
            case e: {
                return n2 + this.l + this.t;
            }
        }
        return n2 + this.t;
    }

    @Override
    public void reset() {
        this.a(true);
    }

    private void a() {
        switch (this.h) {
            case f: {
                this.h = com.enterprisedt.bouncycastle.crypto.engines.SparkleEngine$a.g;
                break;
            }
            case b: {
                this.h = com.enterprisedt.bouncycastle.crypto.engines.SparkleEngine$a.c;
                break;
            }
            case g: 
            case c: {
                break;
            }
            case e: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
            default: {
                throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
            }
        }
    }

    private boolean b() {
        switch (this.h) {
            case f: 
            case g: {
                this.a(com.enterprisedt.bouncycastle.crypto.engines.SparkleEngine$a.h);
                return false;
            }
            case b: 
            case c: {
                this.a(com.enterprisedt.bouncycastle.crypto.engines.SparkleEngine$a.d);
                return true;
            }
            case h: {
                return false;
            }
            case d: {
                return true;
            }
            case e: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
        }
        throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
    }

    private void a(a a2) {
        switch (this.h) {
            case g: 
            case c: {
                this.c();
                break;
            }
        }
        this.l = 0;
        this.h = a2;
    }

    private void a(byte[] byArray, int n2) {
        for (int i2 = 0; i2 < this.v / 2; ++i2) {
            int n3 = i2 + this.v / 2;
            int n4 = this.c[i2];
            int n5 = this.c[n3];
            int n6 = Pack.littleEndianToInt(byArray, n2 + i2 * 4);
            int n7 = Pack.littleEndianToInt(byArray, n2 + n3 * 4);
            this.c[i2] = n5 ^ n6 ^ this.c[this.v + i2];
            this.c[n3] = n4 ^ n5 ^ n7 ^ this.c[this.v + (n3 & this.x)];
        }
        SparkleEngine.d(this.c, this.o);
    }

    private void a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (n3 > byArray2.length - this.w) {
            throw new OutputLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 < this.v / 2; ++i2) {
            int n4 = i2 + this.v / 2;
            int n5 = this.c[i2];
            int n6 = this.c[n4];
            int n7 = Pack.littleEndianToInt(byArray, n2 + i2 * 4);
            int n8 = Pack.littleEndianToInt(byArray, n2 + n4 * 4);
            this.c[i2] = n5 ^ n6 ^ n7 ^ this.c[this.v + i2];
            this.c[n4] = n5 ^ n8 ^ this.c[this.v + (n4 & this.x)];
            Pack.intToLittleEndian(n7 ^ n5, byArray2, n3 + i2 * 4);
            Pack.intToLittleEndian(n8 ^ n6, byArray2, n3 + n4 * 4);
        }
        SparkleEngine.d(this.c, this.o);
        this.g = true;
    }

    private void b(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (n3 > byArray2.length - this.w) {
            throw new OutputLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 < this.v / 2; ++i2) {
            int n4 = i2 + this.v / 2;
            int n5 = this.c[i2];
            int n6 = this.c[n4];
            int n7 = Pack.littleEndianToInt(byArray, n2 + i2 * 4);
            int n8 = Pack.littleEndianToInt(byArray, n2 + n4 * 4);
            this.c[i2] = n6 ^ n7 ^ this.c[this.v + i2];
            this.c[n4] = n5 ^ n6 ^ n8 ^ this.c[this.v + (n4 & this.x)];
            Pack.intToLittleEndian(n7 ^ n5, byArray2, n3 + i2 * 4);
            Pack.intToLittleEndian(n8 ^ n6, byArray2, n3 + n4 * 4);
        }
        SparkleEngine.d(this.c, this.o);
        this.g = true;
    }

    private void c() {
        if (this.l < this.w) {
            int n2 = this.u - 1;
            this.c[n2] = this.c[n2] ^ this.y;
            this.k[this.l] = -128;
            while (++this.l < this.w) {
                this.k[this.l] = 0;
            }
        } else {
            int n3 = this.u - 1;
            this.c[n3] = this.c[n3] ^ this.z;
        }
        for (int i2 = 0; i2 < this.v / 2; ++i2) {
            int n4 = i2 + this.v / 2;
            int n5 = this.c[i2];
            int n6 = this.c[n4];
            int n7 = Pack.littleEndianToInt(this.k, i2 * 4);
            int n8 = Pack.littleEndianToInt(this.k, n4 * 4);
            this.c[i2] = n6 ^ n7 ^ this.c[this.v + i2];
            this.c[n4] = n5 ^ n6 ^ n8 ^ this.c[this.v + (n4 & this.x)];
        }
        SparkleEngine.d(this.c, this.p);
    }

    private void a(boolean bl) {
        if (bl) {
            this.f = null;
        }
        Arrays.clear(this.k);
        this.l = 0;
        this.g = false;
        switch (this.h) {
            case f: 
            case b: {
                break;
            }
            case g: 
            case h: 
            case i: {
                this.h = com.enterprisedt.bouncycastle.crypto.engines.SparkleEngine$a.f;
                break;
            }
            case d: 
            case e: 
            case c: {
                this.h = com.enterprisedt.bouncycastle.crypto.engines.SparkleEngine$a.e;
                return;
            }
            default: {
                throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
            }
        }
        System.arraycopy(this.e, 0, this.c, 0, this.v);
        System.arraycopy(this.d, 0, this.c, this.v, this.q);
        SparkleEngine.d(this.c, this.p);
        if (this.i != null) {
            this.processAADBytes(this.i, 0, this.i.length);
        }
    }

    private static int a(int n2) {
        return Integers.rotateRight(n2, 16) ^ n2 & 0xFFFF;
    }

    private static void d(int[] nArray, int n2) {
        switch (nArray.length) {
            case 8: {
                SparkleEngine.a(nArray, n2);
                break;
            }
            case 12: {
                SparkleEngine.b(nArray, n2);
                break;
            }
            case 16: {
                SparkleEngine.c(nArray, n2);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    static void a(int[] nArray, int n2) {
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        int n6 = nArray[3];
        int n7 = nArray[4];
        int n8 = nArray[5];
        int n9 = nArray[6];
        int n10 = nArray[7];
        for (int i2 = 0; i2 < n2; ++i2) {
            n6 ^= i2;
            int n11 = a[0];
            n3 += Integers.rotateRight(n4 ^= a[i2 & 7], 31);
            n4 ^= Integers.rotateRight(n3, 24);
            n3 ^= n11;
            n3 += Integers.rotateRight(n4, 17);
            n4 ^= Integers.rotateRight(n3, 17);
            n3 ^= n11;
            n3 += n4;
            n4 ^= Integers.rotateRight(n3, 31);
            n3 ^= n11;
            n3 += Integers.rotateRight(n4, 24);
            n4 ^= Integers.rotateRight(n3, 16);
            n3 ^= n11;
            n11 = a[1];
            n5 += Integers.rotateRight(n6, 31);
            n6 ^= Integers.rotateRight(n5, 24);
            n5 ^= n11;
            n5 += Integers.rotateRight(n6, 17);
            n6 ^= Integers.rotateRight(n5, 17);
            n5 ^= n11;
            n5 += n6;
            n6 ^= Integers.rotateRight(n5, 31);
            n5 ^= n11;
            n5 += Integers.rotateRight(n6, 24);
            n6 ^= Integers.rotateRight(n5, 16);
            n5 ^= n11;
            n11 = a[2];
            n7 += Integers.rotateRight(n8, 31);
            n8 ^= Integers.rotateRight(n7, 24);
            n7 ^= n11;
            n7 += Integers.rotateRight(n8, 17);
            n8 ^= Integers.rotateRight(n7, 17);
            n7 ^= n11;
            n7 += n8;
            n8 ^= Integers.rotateRight(n7, 31);
            n7 ^= n11;
            n7 += Integers.rotateRight(n8, 24);
            n8 ^= Integers.rotateRight(n7, 16);
            n7 ^= n11;
            n11 = a[3];
            n9 += Integers.rotateRight(n10, 31);
            n10 ^= Integers.rotateRight(n9, 24);
            n9 ^= n11;
            n9 += Integers.rotateRight(n10, 17);
            n10 ^= Integers.rotateRight(n9, 17);
            n9 ^= n11;
            n9 += n10;
            n10 ^= Integers.rotateRight(n9, 31);
            n9 ^= n11;
            n9 += Integers.rotateRight(n10, 24);
            n10 ^= Integers.rotateRight(n9, 16);
            n9 ^= n11;
            n11 = SparkleEngine.a(n3 ^ n5);
            int n12 = SparkleEngine.a(n4 ^ n6);
            int n13 = n3 ^ n7;
            int n14 = n4 ^ n8;
            int n15 = n5 ^ n9;
            int n16 = n6 ^ n10;
            n7 = n3;
            n8 = n4;
            n9 = n5;
            n10 = n6;
            n3 = n15 ^ n12;
            n4 = n16 ^ n11;
            n5 = n13 ^ n12;
            n6 = n14 ^ n11;
        }
        nArray[0] = n3;
        nArray[1] = n4;
        nArray[2] = n5;
        nArray[3] = n6;
        nArray[4] = n7;
        nArray[5] = n8;
        nArray[6] = n9;
        nArray[7] = n10;
    }

    static void b(int[] nArray, int n2) {
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        int n6 = nArray[3];
        int n7 = nArray[4];
        int n8 = nArray[5];
        int n9 = nArray[6];
        int n10 = nArray[7];
        int n11 = nArray[8];
        int n12 = nArray[9];
        int n13 = nArray[10];
        int n14 = nArray[11];
        for (int i2 = 0; i2 < n2; ++i2) {
            n6 ^= i2;
            int n15 = a[0];
            n3 += Integers.rotateRight(n4 ^= a[i2 & 7], 31);
            n4 ^= Integers.rotateRight(n3, 24);
            n3 ^= n15;
            n3 += Integers.rotateRight(n4, 17);
            n4 ^= Integers.rotateRight(n3, 17);
            n3 ^= n15;
            n3 += n4;
            n4 ^= Integers.rotateRight(n3, 31);
            n3 ^= n15;
            n3 += Integers.rotateRight(n4, 24);
            n4 ^= Integers.rotateRight(n3, 16);
            n3 ^= n15;
            n15 = a[1];
            n5 += Integers.rotateRight(n6, 31);
            n6 ^= Integers.rotateRight(n5, 24);
            n5 ^= n15;
            n5 += Integers.rotateRight(n6, 17);
            n6 ^= Integers.rotateRight(n5, 17);
            n5 ^= n15;
            n5 += n6;
            n6 ^= Integers.rotateRight(n5, 31);
            n5 ^= n15;
            n5 += Integers.rotateRight(n6, 24);
            n6 ^= Integers.rotateRight(n5, 16);
            n5 ^= n15;
            n15 = a[2];
            n7 += Integers.rotateRight(n8, 31);
            n8 ^= Integers.rotateRight(n7, 24);
            n7 ^= n15;
            n7 += Integers.rotateRight(n8, 17);
            n8 ^= Integers.rotateRight(n7, 17);
            n7 ^= n15;
            n7 += n8;
            n8 ^= Integers.rotateRight(n7, 31);
            n7 ^= n15;
            n7 += Integers.rotateRight(n8, 24);
            n8 ^= Integers.rotateRight(n7, 16);
            n7 ^= n15;
            n15 = a[3];
            n9 += Integers.rotateRight(n10, 31);
            n10 ^= Integers.rotateRight(n9, 24);
            n9 ^= n15;
            n9 += Integers.rotateRight(n10, 17);
            n10 ^= Integers.rotateRight(n9, 17);
            n9 ^= n15;
            n9 += n10;
            n10 ^= Integers.rotateRight(n9, 31);
            n9 ^= n15;
            n9 += Integers.rotateRight(n10, 24);
            n10 ^= Integers.rotateRight(n9, 16);
            n9 ^= n15;
            n15 = a[4];
            n11 += Integers.rotateRight(n12, 31);
            n12 ^= Integers.rotateRight(n11, 24);
            n11 ^= n15;
            n11 += Integers.rotateRight(n12, 17);
            n12 ^= Integers.rotateRight(n11, 17);
            n11 ^= n15;
            n11 += n12;
            n12 ^= Integers.rotateRight(n11, 31);
            n11 ^= n15;
            n11 += Integers.rotateRight(n12, 24);
            n12 ^= Integers.rotateRight(n11, 16);
            n11 ^= n15;
            n15 = a[5];
            n13 += Integers.rotateRight(n14, 31);
            n14 ^= Integers.rotateRight(n13, 24);
            n13 ^= n15;
            n13 += Integers.rotateRight(n14, 17);
            n14 ^= Integers.rotateRight(n13, 17);
            n13 ^= n15;
            n13 += n14;
            n14 ^= Integers.rotateRight(n13, 31);
            n13 ^= n15;
            n13 += Integers.rotateRight(n14, 24);
            n14 ^= Integers.rotateRight(n13, 16);
            n13 ^= n15;
            n15 = SparkleEngine.a(n3 ^ n5 ^ n7);
            int n16 = SparkleEngine.a(n4 ^ n6 ^ n8);
            int n17 = n3 ^ n9;
            int n18 = n4 ^ n10;
            int n19 = n5 ^ n11;
            int n20 = n6 ^ n12;
            int n21 = n7 ^ n13;
            int n22 = n8 ^ n14;
            n9 = n3;
            n10 = n4;
            n11 = n5;
            n12 = n6;
            n13 = n7;
            n14 = n8;
            n3 = n19 ^ n16;
            n4 = n20 ^ n15;
            n5 = n21 ^ n16;
            n6 = n22 ^ n15;
            n7 = n17 ^ n16;
            n8 = n18 ^ n15;
        }
        nArray[0] = n3;
        nArray[1] = n4;
        nArray[2] = n5;
        nArray[3] = n6;
        nArray[4] = n7;
        nArray[5] = n8;
        nArray[6] = n9;
        nArray[7] = n10;
        nArray[8] = n11;
        nArray[9] = n12;
        nArray[10] = n13;
        nArray[11] = n14;
    }

    public static void sparkle_opt12(SparkleDigest.Friend friend, int[] state, int steps) {
        if (null == friend) {
            throw new NullPointerException("This method is only for use by SparkleDigest");
        }
        SparkleEngine.b(state, steps);
    }

    static void c(int[] nArray, int n2) {
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        int n6 = nArray[3];
        int n7 = nArray[4];
        int n8 = nArray[5];
        int n9 = nArray[6];
        int n10 = nArray[7];
        int n11 = nArray[8];
        int n12 = nArray[9];
        int n13 = nArray[10];
        int n14 = nArray[11];
        int n15 = nArray[12];
        int n16 = nArray[13];
        int n17 = nArray[14];
        int n18 = nArray[15];
        for (int i2 = 0; i2 < n2; ++i2) {
            n6 ^= i2;
            int n19 = a[0];
            n3 += Integers.rotateRight(n4 ^= a[i2 & 7], 31);
            n4 ^= Integers.rotateRight(n3, 24);
            n3 ^= n19;
            n3 += Integers.rotateRight(n4, 17);
            n4 ^= Integers.rotateRight(n3, 17);
            n3 ^= n19;
            n3 += n4;
            n4 ^= Integers.rotateRight(n3, 31);
            n3 ^= n19;
            n3 += Integers.rotateRight(n4, 24);
            n4 ^= Integers.rotateRight(n3, 16);
            n3 ^= n19;
            n19 = a[1];
            n5 += Integers.rotateRight(n6, 31);
            n6 ^= Integers.rotateRight(n5, 24);
            n5 ^= n19;
            n5 += Integers.rotateRight(n6, 17);
            n6 ^= Integers.rotateRight(n5, 17);
            n5 ^= n19;
            n5 += n6;
            n6 ^= Integers.rotateRight(n5, 31);
            n5 ^= n19;
            n5 += Integers.rotateRight(n6, 24);
            n6 ^= Integers.rotateRight(n5, 16);
            n5 ^= n19;
            n19 = a[2];
            n7 += Integers.rotateRight(n8, 31);
            n8 ^= Integers.rotateRight(n7, 24);
            n7 ^= n19;
            n7 += Integers.rotateRight(n8, 17);
            n8 ^= Integers.rotateRight(n7, 17);
            n7 ^= n19;
            n7 += n8;
            n8 ^= Integers.rotateRight(n7, 31);
            n7 ^= n19;
            n7 += Integers.rotateRight(n8, 24);
            n8 ^= Integers.rotateRight(n7, 16);
            n7 ^= n19;
            n19 = a[3];
            n9 += Integers.rotateRight(n10, 31);
            n10 ^= Integers.rotateRight(n9, 24);
            n9 ^= n19;
            n9 += Integers.rotateRight(n10, 17);
            n10 ^= Integers.rotateRight(n9, 17);
            n9 ^= n19;
            n9 += n10;
            n10 ^= Integers.rotateRight(n9, 31);
            n9 ^= n19;
            n9 += Integers.rotateRight(n10, 24);
            n10 ^= Integers.rotateRight(n9, 16);
            n9 ^= n19;
            n19 = a[4];
            n11 += Integers.rotateRight(n12, 31);
            n12 ^= Integers.rotateRight(n11, 24);
            n11 ^= n19;
            n11 += Integers.rotateRight(n12, 17);
            n12 ^= Integers.rotateRight(n11, 17);
            n11 ^= n19;
            n11 += n12;
            n12 ^= Integers.rotateRight(n11, 31);
            n11 ^= n19;
            n11 += Integers.rotateRight(n12, 24);
            n12 ^= Integers.rotateRight(n11, 16);
            n11 ^= n19;
            n19 = a[5];
            n13 += Integers.rotateRight(n14, 31);
            n14 ^= Integers.rotateRight(n13, 24);
            n13 ^= n19;
            n13 += Integers.rotateRight(n14, 17);
            n14 ^= Integers.rotateRight(n13, 17);
            n13 ^= n19;
            n13 += n14;
            n14 ^= Integers.rotateRight(n13, 31);
            n13 ^= n19;
            n13 += Integers.rotateRight(n14, 24);
            n14 ^= Integers.rotateRight(n13, 16);
            n13 ^= n19;
            n19 = a[6];
            n15 += Integers.rotateRight(n16, 31);
            n16 ^= Integers.rotateRight(n15, 24);
            n15 ^= n19;
            n15 += Integers.rotateRight(n16, 17);
            n16 ^= Integers.rotateRight(n15, 17);
            n15 ^= n19;
            n15 += n16;
            n16 ^= Integers.rotateRight(n15, 31);
            n15 ^= n19;
            n15 += Integers.rotateRight(n16, 24);
            n16 ^= Integers.rotateRight(n15, 16);
            n15 ^= n19;
            n19 = a[7];
            n17 += Integers.rotateRight(n18, 31);
            n18 ^= Integers.rotateRight(n17, 24);
            n17 ^= n19;
            n17 += Integers.rotateRight(n18, 17);
            n18 ^= Integers.rotateRight(n17, 17);
            n17 ^= n19;
            n17 += n18;
            n18 ^= Integers.rotateRight(n17, 31);
            n17 ^= n19;
            n17 += Integers.rotateRight(n18, 24);
            n18 ^= Integers.rotateRight(n17, 16);
            n17 ^= n19;
            n19 = SparkleEngine.a(n3 ^ n5 ^ n7 ^ n9);
            int n20 = SparkleEngine.a(n4 ^ n6 ^ n8 ^ n10);
            int n21 = n3 ^ n11;
            int n22 = n4 ^ n12;
            int n23 = n5 ^ n13;
            int n24 = n6 ^ n14;
            int n25 = n7 ^ n15;
            int n26 = n8 ^ n16;
            int n27 = n9 ^ n17;
            int n28 = n10 ^ n18;
            n11 = n3;
            n12 = n4;
            n13 = n5;
            n14 = n6;
            n15 = n7;
            n16 = n8;
            n17 = n9;
            n18 = n10;
            n3 = n23 ^ n20;
            n4 = n24 ^ n19;
            n5 = n25 ^ n20;
            n6 = n26 ^ n19;
            n7 = n27 ^ n20;
            n8 = n28 ^ n19;
            n9 = n21 ^ n20;
            n10 = n22 ^ n19;
        }
        nArray[0] = n3;
        nArray[1] = n4;
        nArray[2] = n5;
        nArray[3] = n6;
        nArray[4] = n7;
        nArray[5] = n8;
        nArray[6] = n9;
        nArray[7] = n10;
        nArray[8] = n11;
        nArray[9] = n12;
        nArray[10] = n13;
        nArray[11] = n14;
        nArray[12] = n15;
        nArray[13] = n16;
        nArray[14] = n17;
        nArray[15] = n18;
    }

    public static void sparkle_opt16(SparkleDigest.Friend friend, int[] state, int steps) {
        if (null == friend) {
            throw new NullPointerException("This method is only for use by SparkleDigest");
        }
        SparkleEngine.c(state, steps);
    }

    private static enum a {
        a,
        b,
        c,
        d,
        e,
        f,
        g,
        h,
        i;

    }

    public static enum SparkleParameters {
        SCHWAEMM128_128,
        SCHWAEMM256_128,
        SCHWAEMM192_192,
        SCHWAEMM256_256;

    }
}

