/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.engines.c;
import com.enterprisedt.bouncycastle.crypto.modes.AEADCipher;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.ByteArrayOutputStream;

public class XoodyakEngine
implements AEADCipher {
    private boolean b;
    private byte[] c;
    private int d;
    private a e;
    private int f;
    private final int g = 48;
    private final int h = 24;
    private byte[] i;
    private byte[] j;
    private final int k = 1;
    private final int l = 2;
    private final int m = 12;
    private final int n = 3;
    private final int o = 4;
    private final int p = 12;
    private final int q = 16;
    final int a = 44;
    private byte[] r;
    private final int[] s = new int[]{88, 56, 960, 208, 288, 20, 96, 44, 896, 240, 416, 18};
    private boolean t;
    private boolean u;
    private boolean v = false;
    private final ByteArrayOutputStream w = new ByteArrayOutputStream();
    private final ByteArrayOutputStream x = new ByteArrayOutputStream();

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.b = forEncryption;
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("Xoodyak init parameters must include an IV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)params;
        this.j = parametersWithIV.getIV();
        if (this.j == null || this.j.length != 16) {
            throw new IllegalArgumentException("Xoodyak requires exactly 16 bytes of IV");
        }
        if (!(parametersWithIV.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException("Xoodyak init parameters must include a key");
        }
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        this.i = keyParameter.getKey();
        if (this.i.length != 16) {
            throw new IllegalArgumentException("Xoodyak key must be 128 bits long");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, com.enterprisedt.bouncycastle.crypto.engines.c.a(forEncryption)));
        this.c = new byte[48];
        this.r = new byte[16];
        this.v = true;
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return "Xoodyak AEAD";
    }

    @Override
    public void processAADByte(byte input) {
        if (this.t) {
            throw new IllegalArgumentException("AAD cannot be added after reading a full block(" + this.getBlockSize() + " bytes) of input for " + (this.b ? "encryption" : "decryption"));
        }
        this.w.write(input);
    }

    @Override
    public void processAADBytes(byte[] input, int inOff, int len) {
        if (this.t) {
            throw new IllegalArgumentException("AAD cannot be added after reading a full block(" + this.getBlockSize() + " bytes) of input for " + (this.b ? "encryption" : "decryption"));
        }
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.w.write(input, inOff, len);
    }

    @Override
    public int processByte(byte input, byte[] output, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{input}, 0, 1, output, outOff);
    }

    private void a() {
        if (!this.t) {
            byte[] byArray = this.w.toByteArray();
            this.a(byArray, 0, byArray.length, this.f, 3);
            this.t = true;
        }
    }

    @Override
    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        if (!this.v) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        if (this.e != com.enterprisedt.bouncycastle.crypto.engines.XoodyakEngine$a.b) {
            throw new IllegalArgumentException("Xoodyak has not been initialised");
        }
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.x.write(input, inOff, len);
        int n2 = this.x.size() - (this.b ? 0 : 16);
        if (n2 >= this.getBlockSize()) {
            byte[] byArray = this.x.toByteArray();
            len = n2 / this.getBlockSize() * this.getBlockSize();
            if (len + outOff > output.length) {
                throw new OutputLengthException("output buffer is too short");
            }
            this.a();
            this.a(byArray, 0, len, output, outOff);
            this.x.reset();
            this.x.write(byArray, len, byArray.length - len);
            return len;
        }
        return 0;
    }

    private int a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5;
        int n6;
        byte[] byArray3 = new byte[24];
        int n7 = n6 = this.u ? 0 : 128;
        for (int i2 = n3; i2 != 0 || !this.u; i2 -= n5) {
            n5 = Math.min(i2, 24);
            if (this.b) {
                System.arraycopy(byArray, n2, byArray3, 0, n5);
            }
            this.a(null, 0, n6);
            for (int i3 = 0; i3 < n5; ++i3) {
                byArray2[n4 + i3] = (byte)(byArray[n2++] ^ this.c[i3]);
            }
            if (this.b) {
                this.a(byArray3, 0, n5, 0);
            } else {
                this.a(byArray2, n4, n5, 0);
            }
            n6 = 0;
            n4 += n5;
            this.u = true;
        }
        return n3;
    }

    @Override
    public int doFinal(byte[] output, int outOff) throws IllegalStateException, InvalidCipherTextException {
        if (!this.v) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        byte[] byArray = this.x.toByteArray();
        int n2 = this.x.size();
        if (this.b && n2 + 16 + outOff > output.length || !this.b && n2 - 16 + outOff > output.length) {
            throw new OutputLengthException("output buffer too short");
        }
        this.a();
        int n3 = 0;
        if (this.b) {
            this.a(byArray, 0, n2, output, outOff);
            this.r = new byte[16];
            this.a(this.r, 16, 64);
            System.arraycopy(this.r, 0, output, outOff += n2, 16);
            n3 = n2 + 16;
        } else {
            int n4;
            n3 = n4 = n2 - 16;
            this.a(byArray, 0, n4, output, outOff);
            this.r = new byte[16];
            this.a(this.r, 16, 64);
            for (int i2 = 0; i2 < 16; ++i2) {
                if (this.r[i2] == byArray[n4++]) continue;
                throw new IllegalArgumentException("Mac does not match");
            }
        }
        this.a(false);
        return n3;
    }

    @Override
    public byte[] getMac() {
        return this.r;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        return len;
    }

    @Override
    public int getOutputSize(int len) {
        return len + 16;
    }

    @Override
    public void reset() {
        if (!this.v) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        this.a(true);
    }

    private void a(boolean bl) {
        if (bl) {
            this.r = null;
        }
        Arrays.fill(this.c, (byte)0);
        this.t = false;
        this.u = false;
        this.d = 2;
        this.x.reset();
        this.w.reset();
        int n2 = this.i.length;
        int n3 = this.j.length;
        byte[] byArray = new byte[44];
        this.e = com.enterprisedt.bouncycastle.crypto.engines.XoodyakEngine$a.b;
        this.f = 44;
        System.arraycopy(this.i, 0, byArray, 0, n2);
        System.arraycopy(this.j, 0, byArray, n2, n3);
        byArray[n2 + n3] = (byte)n3;
        this.a(byArray, 0, n2 + n3 + 1, this.f, 2);
    }

    private void a(byte[] byArray, int n2, int n3, int n4, int n5) {
        int n6;
        do {
            if (this.d != 2) {
                this.a(null, 0, 0);
            }
            n6 = Math.min(n3, n4);
            this.a(byArray, n2, n6, n5);
            n5 = 0;
            n2 += n6;
        } while ((n3 -= n6) != 0);
    }

    private void a(byte[] byArray, int n2, int n3) {
        if (this.e != com.enterprisedt.bouncycastle.crypto.engines.XoodyakEngine$a.a) {
            this.c[47] = (byte)(this.c[47] ^ n3);
        }
        int[] nArray = new int[12];
        Pack.littleEndianToInt(this.c, 0, nArray, 0, nArray.length);
        int[] nArray2 = new int[12];
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        for (int i2 = 0; i2 < 12; ++i2) {
            int n4;
            int n5;
            for (n5 = 0; n5 < 4; ++n5) {
                nArray3[n5] = nArray[this.a(n5, 0)] ^ nArray[this.a(n5, 1)] ^ nArray[this.a(n5, 2)];
            }
            for (n5 = 0; n5 < 4; ++n5) {
                n4 = nArray3[n5 + 3 & 3];
                nArray4[n5] = this.b(n4, 5) ^ this.b(n4, 14);
            }
            for (n5 = 0; n5 < 4; ++n5) {
                for (n4 = 0; n4 < 3; ++n4) {
                    int n6 = this.a(n5, n4);
                    nArray[n6] = nArray[n6] ^ nArray4[n5];
                }
            }
            for (n5 = 0; n5 < 4; ++n5) {
                nArray2[this.a((int)n5, (int)0)] = nArray[this.a(n5, 0)];
                nArray2[this.a((int)n5, (int)1)] = nArray[this.a(n5 + 3, 1)];
                nArray2[this.a((int)n5, (int)2)] = this.b(nArray[this.a(n5, 2)], 11);
            }
            nArray2[0] = nArray2[0] ^ this.s[i2];
            for (n5 = 0; n5 < 4; ++n5) {
                for (n4 = 0; n4 < 3; ++n4) {
                    nArray[this.a((int)n5, (int)n4)] = nArray2[this.a(n5, n4)] ^ ~nArray2[this.a(n5, n4 + 1)] & nArray2[this.a(n5, n4 + 2)];
                }
            }
            for (n5 = 0; n5 < 4; ++n5) {
                nArray2[this.a((int)n5, (int)0)] = nArray[this.a(n5, 0)];
                nArray2[this.a((int)n5, (int)1)] = this.b(nArray[this.a(n5, 1)], 1);
                nArray2[this.a((int)n5, (int)2)] = this.b(nArray[this.a(n5 + 2, 2)], 8);
            }
            System.arraycopy(nArray2, 0, nArray, 0, 12);
        }
        Pack.intToLittleEndian(nArray, 0, nArray.length, this.c, 0);
        this.d = 2;
        if (byArray != null) {
            System.arraycopy(this.c, 0, byArray, 0, n2);
        }
    }

    void a(byte[] byArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n3) {
            int n6 = n5++;
            this.c[n6] = (byte)(this.c[n6] ^ byArray[n2++]);
        }
        int n7 = n3;
        this.c[n7] = (byte)(this.c[n7] ^ 1);
        this.c[47] = (byte)(this.c[47] ^ (this.e == com.enterprisedt.bouncycastle.crypto.engines.XoodyakEngine$a.a ? n4 & 1 : n4));
        this.d = 1;
    }

    private int a(int n2, int n3) {
        return n3 % 3 * 4 + n2 % 4;
    }

    private int b(int n2, int n3) {
        return n2 << (n3 & 0x1F) ^ n2 >>> (32 - n3 & 0x1F);
    }

    public int getBlockSize() {
        return 24;
    }

    public int getKeyBytesSize() {
        return 16;
    }

    public int getIVBytesSize() {
        return 16;
    }

    static enum a {
        a,
        b;

    }
}

