/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.fpe;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.engines.AESEngine;
import com.enterprisedt.bouncycastle.crypto.fpe.FPEEngine;
import com.enterprisedt.bouncycastle.crypto.fpe.a;
import com.enterprisedt.bouncycastle.crypto.params.FPEParameters;
import com.enterprisedt.bouncycastle.util.Properties;

public class FPEFF1Engine
extends FPEEngine {
    public FPEFF1Engine() {
        this(AESEngine.newInstance());
    }

    public FPEFF1Engine(BlockCipher baseCipher) {
        super(baseCipher);
        if (baseCipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("base cipher needs to be 128 bits");
        }
        if (Properties.isOverrideSet("com.enterprisedt.bouncycastle.fpe.disable") || Properties.isOverrideSet("com.enterprisedt.bouncycastle.fpe.disable_ff1")) {
            throw new UnsupportedOperationException("FF1 encryption disabled");
        }
    }

    @Override
    public void init(boolean forEncryption, CipherParameters parameters) {
        this.forEncryption = forEncryption;
        this.fpeParameters = (FPEParameters)parameters;
        this.baseCipher.init(!this.fpeParameters.isUsingInverseFunction(), this.fpeParameters.getKey());
    }

    @Override
    public String getAlgorithmName() {
        return "FF1";
    }

    @Override
    protected int encryptBlock(byte[] inBuf, int inOff, int length, byte[] outBuf, int outOff) {
        byte[] byArray = this.fpeParameters.getRadix() > 256 ? FPEFF1Engine.toByteArray(a.c(this.baseCipher, this.fpeParameters.getRadixConverter(), this.fpeParameters.getTweak(), FPEFF1Engine.toShortArray(inBuf), inOff, length / 2)) : a.c(this.baseCipher, this.fpeParameters.getRadixConverter(), this.fpeParameters.getTweak(), inBuf, inOff, length);
        System.arraycopy(byArray, 0, outBuf, outOff, length);
        return length;
    }

    @Override
    protected int decryptBlock(byte[] inBuf, int inOff, int length, byte[] outBuf, int outOff) {
        byte[] byArray = this.fpeParameters.getRadix() > 256 ? FPEFF1Engine.toByteArray(a.a(this.baseCipher, this.fpeParameters.getRadixConverter(), this.fpeParameters.getTweak(), FPEFF1Engine.toShortArray(inBuf), inOff, length / 2)) : a.a(this.baseCipher, this.fpeParameters.getRadixConverter(), this.fpeParameters.getTweak(), inBuf, inOff, length);
        System.arraycopy(byArray, 0, outBuf, outOff, length);
        return length;
    }
}

