/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.generators;

import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.KeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.constraints.ConstraintUtils;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.enterprisedt.bouncycastle.math.ec.WNafUtil;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    private final String c;
    ECDomainParameters a;
    SecureRandom b;

    public ECKeyPairGenerator() {
        this("ECKeyGen");
    }

    protected ECKeyPairGenerator(String name) {
        this.c = name;
    }

    @Override
    public void init(KeyGenerationParameters param) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)param;
        this.b = eCKeyGenerationParameters.getRandom();
        this.a = eCKeyGenerationParameters.getDomainParameters();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.c, ConstraintUtils.bitsOfSecurityFor(this.a.getCurve()), eCKeyGenerationParameters.getDomainParameters(), CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.a.getN();
        int n2 = bigInteger2.bitLength();
        int n3 = n2 >>> 2;
        while (this.isOutOfRangeD(bigInteger = BigIntegers.createRandomBigInteger(n2, this.b), bigInteger2) || WNafUtil.getNafWeight(bigInteger) < n3) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.a.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.a), new ECPrivateKeyParameters(bigInteger, this.a));
    }

    protected boolean isOutOfRangeD(BigInteger d2, BigInteger n2) {
        return d2.compareTo(ONE) < 0 || d2.compareTo(n2) >= 0;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

