/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.generators;

import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.DerivationFunction;
import com.enterprisedt.bouncycastle.crypto.DerivationParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.macs.HMac;
import com.enterprisedt.bouncycastle.crypto.params.HKDFParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;

public class HKDFBytesGenerator
implements DerivationFunction {
    private HMac a;
    private int b;
    private byte[] c;
    private byte[] d;
    private int e;

    public HKDFBytesGenerator(Digest hash) {
        this.a = new HMac(hash);
        this.b = hash.getDigestSize();
    }

    @Override
    public void init(DerivationParameters param) {
        if (!(param instanceof HKDFParameters)) {
            throw new IllegalArgumentException("HKDF parameters required for HKDFBytesGenerator");
        }
        HKDFParameters hKDFParameters = (HKDFParameters)param;
        if (hKDFParameters.skipExtract()) {
            this.a.init(new KeyParameter(hKDFParameters.getIKM()));
        } else {
            this.a.init(new KeyParameter(this.extractPRK(hKDFParameters.getSalt(), hKDFParameters.getIKM())));
        }
        this.c = hKDFParameters.getInfo();
        this.e = 0;
        this.d = new byte[this.b];
    }

    public byte[] extractPRK(byte[] salt, byte[] ikm) {
        if (salt == null) {
            this.a.init(new KeyParameter(new byte[this.b]));
        } else {
            this.a.init(new KeyParameter(salt));
        }
        this.a.update(ikm, 0, ikm.length);
        byte[] byArray = new byte[this.b];
        this.a.doFinal(byArray, 0);
        return byArray;
    }

    private void a() throws DataLengthException {
        int n2 = this.e / this.b + 1;
        if (n2 >= 256) {
            throw new DataLengthException("HKDF cannot generate more than 255 blocks of HashLen size");
        }
        if (this.e != 0) {
            this.a.update(this.d, 0, this.b);
        }
        this.a.update(this.c, 0, this.c.length);
        this.a.update((byte)n2);
        this.a.doFinal(this.d, 0);
    }

    public Digest getDigest() {
        return this.a.getUnderlyingDigest();
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (this.e + len > 255 * this.b) {
            throw new DataLengthException("HKDF may only be used for 255 * HashLen bytes of output");
        }
        if (this.e % this.b == 0) {
            this.a();
        }
        int n2 = len;
        int n3 = this.e % this.b;
        int n4 = this.b - this.e % this.b;
        int n5 = Math.min(n4, n2);
        System.arraycopy(this.d, n3, out, outOff, n5);
        this.e += n5;
        n2 -= n5;
        outOff += n5;
        while (n2 > 0) {
            this.a();
            n5 = Math.min(this.b, n2);
            System.arraycopy(this.d, 0, out, outOff, n5);
            this.e += n5;
            n2 -= n5;
            outOff += n5;
        }
        return len;
    }
}

