/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.generators;

import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.DerivationParameters;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.MacDerivationFunction;
import com.enterprisedt.bouncycastle.crypto.params.KDFCounterParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import java.math.BigInteger;

public class KDFCounterBytesGenerator
implements MacDerivationFunction {
    private static final BigInteger a = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger b = BigInteger.valueOf(2L);
    private final Mac c;
    private final int d;
    private byte[] e;
    private byte[] f;
    private int g;
    private byte[] h;
    private int i;
    private byte[] j;

    public KDFCounterBytesGenerator(Mac prf) {
        this.c = prf;
        this.d = prf.getMacSize();
        this.j = new byte[this.d];
    }

    @Override
    public void init(DerivationParameters param) {
        if (!(param instanceof KDFCounterParameters)) {
            throw new IllegalArgumentException("Wrong type of arguments given");
        }
        KDFCounterParameters kDFCounterParameters = (KDFCounterParameters)param;
        this.c.init(new KeyParameter(kDFCounterParameters.getKI()));
        this.e = kDFCounterParameters.getFixedInputDataCounterPrefix();
        this.f = kDFCounterParameters.getFixedInputDataCounterSuffix();
        int n2 = kDFCounterParameters.getR();
        this.h = new byte[n2 / 8];
        BigInteger bigInteger = b.pow(n2).multiply(BigInteger.valueOf(this.d));
        this.g = bigInteger.compareTo(a) == 1 ? Integer.MAX_VALUE : bigInteger.intValue();
        this.i = 0;
    }

    @Override
    public Mac getMac() {
        return this.c;
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        int n2 = this.i + len;
        if (n2 < 0 || n2 >= this.g) {
            throw new DataLengthException("Current KDFCTR may only be used for " + this.g + " bytes");
        }
        if (this.i % this.d == 0) {
            this.a();
        }
        int n3 = len;
        int n4 = this.i % this.d;
        int n5 = this.d - this.i % this.d;
        int n6 = Math.min(n5, n3);
        System.arraycopy(this.j, n4, out, outOff, n6);
        this.i += n6;
        n3 -= n6;
        outOff += n6;
        while (n3 > 0) {
            this.a();
            n6 = Math.min(this.d, n3);
            System.arraycopy(this.j, 0, out, outOff, n6);
            this.i += n6;
            n3 -= n6;
            outOff += n6;
        }
        return len;
    }

    private void a() {
        int n2 = this.i / this.d + 1;
        switch (this.h.length) {
            case 4: {
                this.h[0] = (byte)(n2 >>> 24);
            }
            case 3: {
                this.h[this.h.length - 3] = (byte)(n2 >>> 16);
            }
            case 2: {
                this.h[this.h.length - 2] = (byte)(n2 >>> 8);
            }
            case 1: {
                this.h[this.h.length - 1] = (byte)n2;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported size of counter i");
            }
        }
        this.c.update(this.e, 0, this.e.length);
        this.c.update(this.h, 0, this.h.length);
        this.c.update(this.f, 0, this.f.length);
        this.c.doFinal(this.j, 0);
    }
}

