/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.generators;

import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.DerivationFunction;
import com.enterprisedt.bouncycastle.crypto.DerivationParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.params.MGFParameters;

public class MGF1BytesGenerator
implements DerivationFunction {
    private Digest a;
    private byte[] b;
    private int c;

    public MGF1BytesGenerator(Digest digest) {
        this.a = digest;
        this.c = digest.getDigestSize();
    }

    @Override
    public void init(DerivationParameters param) {
        if (!(param instanceof MGFParameters)) {
            throw new IllegalArgumentException("MGF parameters required for MGF1Generator");
        }
        MGFParameters mGFParameters = (MGFParameters)param;
        this.b = mGFParameters.getSeed();
    }

    public Digest getDigest() {
        return this.a;
    }

    private void a(int n2, byte[] byArray) {
        byArray[0] = (byte)(n2 >>> 24);
        byArray[1] = (byte)(n2 >>> 16);
        byArray[2] = (byte)(n2 >>> 8);
        byArray[3] = (byte)(n2 >>> 0);
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (out.length - len < outOff) {
            throw new OutputLengthException("output buffer too small");
        }
        byte[] byArray = new byte[this.c];
        byte[] byArray2 = new byte[4];
        int n2 = 0;
        this.a.reset();
        if (len > this.c) {
            do {
                this.a(n2, byArray2);
                this.a.update(this.b, 0, this.b.length);
                this.a.update(byArray2, 0, byArray2.length);
                this.a.doFinal(byArray, 0);
                System.arraycopy(byArray, 0, out, outOff + n2 * this.c, this.c);
            } while (++n2 < len / this.c);
        }
        if (n2 * this.c < len) {
            this.a(n2, byArray2);
            this.a.update(this.b, 0, this.b.length);
            this.a.update(byArray2, 0, byArray2.length);
            this.a.doFinal(byArray, 0);
            System.arraycopy(byArray, 0, out, outOff + n2 * this.c, len - n2 * this.c);
        }
        return len;
    }
}

