/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.generators;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.PBEParametersGenerator;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.crypto.util.DigestFactory;

public class OpenSSLPBEParametersGenerator
extends PBEParametersGenerator {
    private final Digest a;

    public OpenSSLPBEParametersGenerator() {
        this(DigestFactory.createMD5());
    }

    public OpenSSLPBEParametersGenerator(Digest digest) {
        this.a = digest;
    }

    public void init(byte[] password, byte[] salt) {
        super.init(password, salt, 1);
    }

    private byte[] a(int n2) {
        byte[] byArray = new byte[this.a.getDigestSize()];
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (true) {
            this.a.update(this.password, 0, this.password.length);
            this.a.update(this.salt, 0, this.salt.length);
            this.a.doFinal(byArray, 0);
            int n4 = n2 > byArray.length ? byArray.length : n2;
            System.arraycopy(byArray, 0, byArray2, n3, n4);
            n3 += n4;
            if ((n2 -= n4) == 0) break;
            this.a.reset();
            this.a.update(byArray, 0, byArray.length);
        }
        return byArray2;
    }

    @Override
    public CipherParameters generateDerivedParameters(int keySize) {
        byte[] byArray = this.a(keySize /= 8);
        return new KeyParameter(byArray, 0, keySize);
    }

    @Override
    public CipherParameters generateDerivedParameters(int keySize, int ivSize) {
        byte[] byArray = this.a((keySize /= 8) + (ivSize /= 8));
        return new ParametersWithIV(new KeyParameter(byArray, 0, keySize), byArray, keySize, ivSize);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int keySize) {
        return this.generateDerivedParameters(keySize);
    }
}

