/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.generators;

import com.enterprisedt.bouncycastle.crypto.CipherKeyGenerator;
import com.enterprisedt.bouncycastle.crypto.KeyGenerationParameters;

public class Poly1305KeyGenerator
extends CipherKeyGenerator {
    @Override
    public void init(KeyGenerationParameters param) {
        super.init(new KeyGenerationParameters(param.getRandom(), 256));
    }

    @Override
    public byte[] generateKey() {
        byte[] byArray = super.generateKey();
        Poly1305KeyGenerator.clamp(byArray);
        return byArray;
    }

    public static void clamp(byte[] key) {
        if (key.length != 32) {
            throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
        }
        key[3] = (byte)(key[3] & 0xF);
        key[7] = (byte)(key[7] & 0xF);
        key[11] = (byte)(key[11] & 0xF);
        key[15] = (byte)(key[15] & 0xF);
        key[4] = (byte)(key[4] & 0xFFFFFFFC);
        key[8] = (byte)(key[8] & 0xFFFFFFFC);
        key[12] = (byte)(key[12] & 0xFFFFFFFC);
    }

    public static void checkKey(byte[] key) {
        if (key.length != 32) {
            throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
        }
        Poly1305KeyGenerator.a(key[3], (byte)15);
        Poly1305KeyGenerator.a(key[7], (byte)15);
        Poly1305KeyGenerator.a(key[11], (byte)15);
        Poly1305KeyGenerator.a(key[15], (byte)15);
        Poly1305KeyGenerator.a(key[4], (byte)-4);
        Poly1305KeyGenerator.a(key[8], (byte)-4);
        Poly1305KeyGenerator.a(key[12], (byte)-4);
    }

    private static void a(byte by, byte by2) {
        if ((by & ~by2) != 0) {
            throw new IllegalArgumentException("Invalid format for r portion of Poly1305 key.");
        }
    }
}

