/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.generators;

import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.KeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.constraints.ConstraintUtils;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.enterprisedt.bouncycastle.math.Primes;
import com.enterprisedt.bouncycastle.math.ec.WNafUtil;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class RSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private RSAKeyGenerationParameters b;

    @Override
    public void init(KeyGenerationParameters param) {
        this.b = (RSAKeyGenerationParameters)param;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("RSAKeyGen", ConstraintUtils.bitsOfSecurityForFF(param.getStrength()), null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = null;
        boolean bl = false;
        int n2 = this.b.getStrength();
        int n3 = (n2 + 1) / 2;
        int n4 = n2 - n3;
        int n5 = n2 / 2 - 100;
        if (n5 < n2 / 3) {
            n5 = n2 / 3;
        }
        int n6 = n2 >> 2;
        BigInteger bigInteger = BigInteger.valueOf(2L).pow(n2 / 2);
        BigInteger bigInteger2 = a.shiftLeft(n2 - 1);
        BigInteger bigInteger3 = a.shiftLeft(n5);
        while (!bl) {
            BigInteger bigInteger4;
            BigInteger bigInteger5;
            BigInteger bigInteger6;
            BigInteger bigInteger7;
            BigInteger bigInteger8;
            BigInteger bigInteger9;
            BigInteger bigInteger10;
            BigInteger bigInteger11;
            BigInteger bigInteger12 = this.b.getPublicExponent();
            BigInteger bigInteger13 = this.chooseRandomPrime(n3, bigInteger12, bigInteger2);
            while (true) {
                if ((bigInteger11 = (bigInteger10 = this.chooseRandomPrime(n4, bigInteger12, bigInteger2)).subtract(bigInteger13).abs()).bitLength() < n5 || bigInteger11.compareTo(bigInteger3) <= 0) {
                    continue;
                }
                bigInteger9 = bigInteger13.multiply(bigInteger10);
                if (bigInteger9.bitLength() != n2) {
                    bigInteger13 = bigInteger13.max(bigInteger10);
                    continue;
                }
                if (WNafUtil.getNafWeight(bigInteger9) >= n6) break;
                bigInteger13 = this.chooseRandomPrime(n3, bigInteger12, bigInteger2);
            }
            if (bigInteger13.compareTo(bigInteger10) < 0) {
                bigInteger8 = bigInteger13;
                bigInteger13 = bigInteger10;
                bigInteger10 = bigInteger8;
            }
            if ((bigInteger7 = bigInteger12.modInverse(bigInteger6 = (bigInteger5 = bigInteger13.subtract(a)).divide(bigInteger8 = bigInteger5.gcd(bigInteger4 = bigInteger10.subtract(a))).multiply(bigInteger4))).compareTo(bigInteger) <= 0) continue;
            bl = true;
            bigInteger11 = bigInteger7.remainder(bigInteger5);
            BigInteger bigInteger14 = bigInteger7.remainder(bigInteger4);
            BigInteger bigInteger15 = BigIntegers.modOddInverse(bigInteger13, bigInteger10);
            asymmetricCipherKeyPair = new AsymmetricCipherKeyPair(new RSAKeyParameters(false, bigInteger9, bigInteger12, true), new RSAPrivateCrtKeyParameters(bigInteger9, bigInteger12, bigInteger7, bigInteger13, bigInteger10, bigInteger11, bigInteger14, bigInteger15, true));
        }
        return asymmetricCipherKeyPair;
    }

    protected BigInteger chooseRandomPrime(int bitlength, BigInteger e2, BigInteger sqrdBound) {
        for (int i2 = 0; i2 != 5 * bitlength; ++i2) {
            BigInteger bigInteger = BigIntegers.createRandomPrime(bitlength, 1, this.b.getRandom());
            if (bigInteger.mod(e2).equals(a) || bigInteger.multiply(bigInteger).compareTo(sqrdBound) < 0 || !this.isProbablePrime(bigInteger) || !e2.gcd(bigInteger.subtract(a)).equals(a)) continue;
            return bigInteger;
        }
        throw new IllegalStateException("unable to generate prime number for RSA key");
    }

    protected boolean isProbablePrime(BigInteger x) {
        int n2 = RSAKeyPairGenerator.a(x.bitLength(), this.b.getCertainty());
        return !Primes.hasAnySmallFactors(x) && Primes.isMRProbablePrime(x, this.b.getRandom(), n2);
    }

    private static int a(int n2, int n3) {
        if (n2 >= 1536) {
            return n3 <= 100 ? 3 : (n3 <= 128 ? 4 : 4 + (n3 - 128 + 1) / 2);
        }
        if (n2 >= 1024) {
            return n3 <= 100 ? 4 : (n3 <= 112 ? 5 : 5 + (n3 - 112 + 1) / 2);
        }
        if (n2 >= 512) {
            return n3 <= 80 ? 5 : (n3 <= 100 ? 7 : 7 + (n3 - 100 + 1) / 2);
        }
        return n3 <= 80 ? 40 : 40 + (n3 - 80 + 1) / 2;
    }
}

