/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.hpke;

import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.engines.AESEngine;
import com.enterprisedt.bouncycastle.crypto.modes.AEADCipher;
import com.enterprisedt.bouncycastle.crypto.modes.ChaCha20Poly1305;
import com.enterprisedt.bouncycastle.crypto.modes.GCMBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;

public class AEAD {
    private final short a;
    private final byte[] b;
    private final byte[] c;
    private long d = 0L;
    private AEADCipher e;

    public AEAD(short aeadId, byte[] key, byte[] baseNonce) {
        this.b = key;
        this.c = baseNonce;
        this.a = aeadId;
        this.d = 0L;
        switch (aeadId) {
            case 1: 
            case 2: {
                this.e = new GCMBlockCipher(new AESEngine());
                break;
            }
            case 3: {
                this.e = new ChaCha20Poly1305();
                break;
            }
        }
    }

    public byte[] seal(byte[] aad, byte[] pt, int ptOffset, int ptLength) throws InvalidCipherTextException {
        ParametersWithIV parametersWithIV;
        if (ptOffset < 0 || ptOffset > pt.length) {
            throw new IndexOutOfBoundsException("Invalid offset");
        }
        if (ptOffset + ptLength > pt.length) {
            throw new IndexOutOfBoundsException("Invalid length");
        }
        switch (this.a) {
            case 1: 
            case 2: 
            case 3: {
                parametersWithIV = new ParametersWithIV(new KeyParameter(this.b), this.a());
                break;
            }
            default: {
                throw new IllegalStateException("Export only mode, cannot be used to seal/open");
            }
        }
        this.e.init(true, parametersWithIV);
        this.e.processAADBytes(aad, 0, aad.length);
        byte[] byArray = new byte[this.e.getOutputSize(ptLength)];
        int n2 = this.e.processBytes(pt, ptOffset, ptLength, byArray, 0);
        this.e.doFinal(byArray, n2);
        ++this.d;
        return byArray;
    }

    public byte[] seal(byte[] aad, byte[] pt) throws InvalidCipherTextException {
        return this.seal(aad, pt, 0, pt.length);
    }

    public byte[] open(byte[] aad, byte[] ct, int ctOffset, int ctLength) throws InvalidCipherTextException {
        ParametersWithIV parametersWithIV;
        if (ctOffset < 0 || ctOffset > ct.length) {
            throw new IndexOutOfBoundsException("Invalid offset");
        }
        if (ctOffset + ctLength > ct.length) {
            throw new IndexOutOfBoundsException("Invalid length");
        }
        switch (this.a) {
            case 1: 
            case 2: 
            case 3: {
                parametersWithIV = new ParametersWithIV(new KeyParameter(this.b), this.a());
                break;
            }
            default: {
                throw new IllegalStateException("Export only mode, cannot be used to seal/open");
            }
        }
        this.e.init(false, parametersWithIV);
        this.e.processAADBytes(aad, 0, aad.length);
        byte[] byArray = new byte[this.e.getOutputSize(ctLength)];
        int n2 = this.e.processBytes(ct, ctOffset, ctLength, byArray, 0);
        n2 += this.e.doFinal(byArray, n2);
        ++this.d;
        return byArray;
    }

    public byte[] open(byte[] aad, byte[] ct) throws InvalidCipherTextException {
        return this.open(aad, ct, 0, ct.length);
    }

    private byte[] a() {
        byte[] byArray = Pack.longToBigEndian(this.d);
        int n2 = this.c.length;
        byte[] byArray2 = Arrays.clone(this.c);
        for (int i2 = 0; i2 < 8; ++i2) {
            int n3 = n2 - 8 + i2;
            byArray2[n3] = (byte)(byArray2[n3] ^ byArray[i2]);
        }
        return byArray2;
    }
}

